/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.linalg;

import cn.org.gddsn.linalg.DimensionNotMatchException;

public class Matrix {
    double[][] Mat;
    int nRow;
    int nCol;

    private Matrix() {
    }

    public Matrix(double[][] M, int Row2, int Col) {
        this.nRow = Row2;
        this.nCol = Col;
        this.Mat = new double[this.nRow][this.nCol];
        int i = 0;
        while (i < this.nRow) {
            int j = 0;
            while (j < this.nCol) {
                this.Mat[i][j] = M[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Matrix(double[][] M, int startRow, int Row2, int Col) {
        this.nRow = Row2;
        this.nCol = Col;
        this.Mat = new double[this.nRow][this.nCol];
        int i = 0;
        while (i < this.nRow) {
            int j = 0;
            while (j < this.nCol) {
                this.Mat[i][j] = M[i + startRow][j];
                ++j;
            }
            ++i;
        }
    }

    public Matrix(int Row2, int Col) {
        this.nRow = Row2;
        this.nCol = Col;
        this.Mat = new double[this.nRow][this.nCol];
        int i = 0;
        while (i < this.nRow) {
            int j = 0;
            while (j < this.nCol) {
                this.Mat[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    public void printMat() {
        System.out.println("The Matrix value is:");
        int i = 0;
        while (i < this.nRow) {
            int j = 0;
            while (j < this.nCol) {
                System.out.print(this.Mat[i][j]);
                if (j < this.nCol - 1) {
                    System.out.print(",");
                }
                ++j;
            }
            System.out.println("");
            ++i;
        }
    }

    public int getRow() {
        return this.nRow;
    }

    public int getCol() {
        return this.nCol;
    }

    public double[][] getMat() {
        return this.Mat;
    }

    public Matrix Transport() {
        double[][] TranMat = new double[this.nCol][this.nRow];
        int i = 0;
        while (i < this.nCol) {
            int j = 0;
            while (j < this.nRow) {
                TranMat[i][j] = this.Mat[j][i];
                ++j;
            }
            ++i;
        }
        return new Matrix(TranMat, this.nCol, this.nRow);
    }

    public double Det() throws DimensionNotMatchException {
        if (this.nRow != this.nCol) {
            DimensionNotMatchException e = new DimensionNotMatchException("the Matrix dimCol should be as same as dimRow.");
            throw e;
        }
        return Matrix.Det(this.Mat, this.nRow);
    }

    public static Matrix Multiply(Matrix A, Matrix B) throws DimensionNotMatchException {
        if (A.nCol != B.nRow) {
            DimensionNotMatchException e = new DimensionNotMatchException("Dimension NOT MATCHed.");
            throw e;
        }
        int m = A.nRow;
        double[][] a = A.Mat;
        int n = B.nCol;
        double[][] b = B.Mat;
        int p = A.nCol;
        double[][] c = new double[m][n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                c[i][j] = 0.0;
                int k = 0;
                while (k < p) {
                    double[] dArray = c[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + a[i][k] * b[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return new Matrix(c, m, n);
    }

    public void Multiply(double dn) {
        int i = 0;
        while (i < this.nRow) {
            int j = 0;
            while (j < this.nCol) {
                double[] dArray = this.Mat[i];
                int n = j++;
                dArray[n] = dArray[n] * dn;
            }
            ++i;
        }
    }

    public static Matrix Cov(int[][] M, int row, int colum) {
        double[][] dM = new double[row][colum];
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < colum) {
                dM[i][j] = M[i][j];
                ++j;
            }
            ++i;
        }
        return Matrix.Cov(dM, row, colum);
    }

    public static Matrix Cov(double[][] M, int row, int colum) {
        double[] Mean2 = new double[colum];
        int j = 0;
        while (j < colum) {
            Mean2[j] = 0.0;
            int i = 0;
            while (i < row) {
                int n = j;
                Mean2[n] = Mean2[n] + M[i][j];
                ++i;
            }
            int n = j;
            Mean2[n] = Mean2[n] / (double)row;
            i = 0;
            while (i < row) {
                double[] dArray = M[i];
                int n2 = j;
                dArray[n2] = dArray[n2] - Mean2[j];
                ++i;
            }
            ++j;
        }
        Matrix mm = new Matrix(M, row, colum);
        Matrix mmt = mm.Transport();
        Matrix res = new Matrix(row, colum);
        try {
            res = Matrix.Multiply(mmt, mm);
        }
        catch (Exception exception) {
            // empty catch block
        }
        res.Multiply(1.0 / (double)(row - 1));
        return res;
    }

    public static double Det(double[][] M, int n) {
        int i = 0;
        int ii = 0;
        int j = 0;
        int k = 0;
        int kk = 0;
        double d = 0.0;
        double m = 0.0;
        double[][] A = new double[n + 1][n + 1];
        i = 1;
        while (i <= n) {
            j = 1;
            while (j <= n) {
                A[i][j] = M[i - 1][j - 1];
                ++j;
            }
            ++i;
        }
        int[] p = new int[n + 1];
        k = 1;
        while (k <= n) {
            p[k] = k;
            ++k;
        }
        d = 1.0;
        k = 1;
        while (k <= n - 1) {
            i = k;
            while (i <= n && A[p[i]][k] == 0.0) {
                ++i;
            }
            if (n < i) {
                return 0.0;
            }
            j = i + 1;
            while (j <= n) {
                if (A[p[j]][k] != 0.0 && Math.abs(A[p[i]][k]) < Math.abs(A[p[j]][k])) {
                    i = j;
                }
                ++j;
            }
            kk = p[i];
            if (i != k) {
                p[i] = p[k];
                p[k] = kk;
                d = -d;
            }
            i = k + 1;
            while (i <= n) {
                ii = p[i];
                m = A[ii][k] / A[kk][k];
                if (m != 0.0) {
                    j = k + 1;
                    while (j <= n) {
                        A[ii][j] = A[ii][j] - m * A[kk][j];
                        ++j;
                    }
                }
                ++i;
            }
            ++k;
        }
        i = 1;
        while (i <= n) {
            d *= A[p[i]][i];
            ++i;
        }
        return d;
    }

    private static void _houseHolder(double[][] a, int n, double[][] q, double[] b, double[] c) {
        int i = 0;
        int j = 0;
        int k = 0;
        double h = 0.0;
        double f = 0.0;
        double g = 0.0;
        double h2 = 0.0;
        i = 0;
        while (i <= n - 1) {
            j = 0;
            while (j <= n - 1) {
                q[i][j] = a[i][j];
                ++j;
            }
            ++i;
        }
        i = n - 1;
        while (i >= 1) {
            h = 0.0;
            if (i > 1) {
                k = 0;
                while (k <= i - 1) {
                    h += q[i][k] * q[i][k];
                    ++k;
                }
            }
            if (h + 1.0 == 1.0) {
                c[i] = 0.0;
                if (i == 1) {
                    c[i] = q[i][i - 1];
                }
                b[i] = 0.0;
            } else {
                c[i] = Math.sqrt(h);
                if (q[i][i - 1] > 0.0) {
                    c[i] = -c[i];
                }
                h -= q[i][i - 1] * c[i];
                q[i][i - 1] = q[i][i - 1] - c[i];
                f = 0.0;
                j = 0;
                while (j <= i - 1) {
                    q[j][i] = q[i][j] / h;
                    g = 0.0;
                    k = 0;
                    while (k <= j) {
                        g += q[j][k] * q[i][k];
                        ++k;
                    }
                    if (j + 1 <= i - 1) {
                        k = j + 1;
                        while (k <= i - 1) {
                            g += q[k][j] * q[i][k];
                            ++k;
                        }
                    }
                    c[j] = g / h;
                    f += g * q[j][i];
                    ++j;
                }
                h2 = f / (h + h);
                j = 0;
                while (j <= i - 1) {
                    f = q[i][j];
                    c[j] = g = c[j] - h2 * f;
                    k = 0;
                    while (k <= j) {
                        q[j][k] = q[j][k] - f * c[k] - g * q[i][k];
                        ++k;
                    }
                    ++j;
                }
                b[i] = h;
            }
            --i;
        }
        i = 0;
        while (i <= n - 2) {
            c[i] = c[i + 1];
            ++i;
        }
        c[n - 1] = 0.0;
        b[0] = 0.0;
        i = 0;
        while (i <= n - 1) {
            if (b[i] != 0.0 && i - 1 >= 0) {
                j = 0;
                while (j <= i - 1) {
                    g = 0.0;
                    k = 0;
                    while (k <= i - 1) {
                        g += q[i][k] * q[k][j];
                        ++k;
                    }
                    k = 0;
                    while (k <= i - 1) {
                        q[k][j] = q[k][j] - g * q[k][i];
                        ++k;
                    }
                    ++j;
                }
            }
            b[i] = q[i][i];
            q[i][i] = 1.0;
            if (i - 1 >= 0) {
                j = 0;
                while (j <= i - 1) {
                    q[i][j] = 0.0;
                    q[j][i] = 0.0;
                    ++j;
                }
            }
            ++i;
        }
    }

    private static boolean _solveRealSymEig(int n, double[] b, double[] c, double[][] q, double eps, int l) {
        int i = 0;
        int j = 0;
        int k = 0;
        int m = 0;
        int it = 0;
        double d = 0.0;
        double f = 0.0;
        double h = 0.0;
        double g = 0.0;
        double p = 0.0;
        double r = 0.0;
        double e = 0.0;
        double s = 0.0;
        c[n - 1] = 0.0;
        d = 0.0;
        f = 0.0;
        j = 0;
        while (j <= n - 1) {
            it = 0;
            h = eps * (Math.abs(b[j]) + Math.abs(c[j]));
            if (h > d) {
                d = h;
            }
            m = j;
            while (m <= n - 1 && Math.abs(c[m]) > d) {
                ++m;
            }
            if (m != j) {
                do {
                    if (it == l) {
                        System.out.println("fail");
                        return false;
                    }
                    ++it;
                    g = b[j];
                    p = (b[j + 1] - g) / (2.0 * c[j]);
                    r = Math.sqrt(p * p + 1.0);
                    b[j] = p >= 0.0 ? c[j] / (p + r) : c[j] / (p - r);
                    h = g - b[j];
                    i = j + 1;
                    while (i <= n - 1) {
                        b[i] = b[i] - h;
                        ++i;
                    }
                    f += h;
                    p = b[m];
                    e = 1.0;
                    s = 0.0;
                    i = m - 1;
                    while (i >= j) {
                        g = e * c[i];
                        h = e * p;
                        if (Math.abs(p) >= Math.abs(c[i])) {
                            e = c[i] / p;
                            r = Math.sqrt(e * e + 1.0);
                            c[i + 1] = s * p * r;
                            s = e / r;
                            e = 1.0 / r;
                        } else {
                            e = p / c[i];
                            r = Math.sqrt(e * e + 1.0);
                            c[i + 1] = s * c[i] * r;
                            s = 1.0 / r;
                            e /= r;
                        }
                        p = e * b[i] - s * g;
                        b[i + 1] = h + s * (e * g + s * b[i]);
                        k = 0;
                        while (k <= n - 1) {
                            h = q[k][i + 1];
                            q[k][i + 1] = s * q[k][i] + e * h;
                            q[k][i] = e * q[k][i] - s * h;
                            ++k;
                        }
                        --i;
                    }
                    c[j] = s * p;
                    b[j] = e * p;
                } while (Math.abs(c[j]) > d);
            }
            b[j] = b[j] + f;
            ++j;
        }
        i = 0;
        while (i <= n - 1) {
            k = i;
            p = b[i];
            if (i + 1 <= n - 1) {
                j = i + 1;
                while (j <= n - 1 && b[j] <= p) {
                    k = j;
                    p = b[j];
                    ++j;
                }
            }
            if (k != i) {
                b[k] = b[i];
                b[i] = p;
                j = 0;
                while (j <= n - 1) {
                    p = q[j][i];
                    q[j][i] = q[j][k];
                    q[j][k] = p;
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean calRealSymMatrixEig(int n, double[][] M, double[] eigValue, double[][] eigVector) {
        double[] c = new double[n];
        double eps = 1.0E-6;
        int L = 100;
        Matrix._houseHolder(M, n, eigVector, eigValue, c);
        return Matrix._solveRealSymEig(n, eigValue, c, eigVector, eps, L);
    }
}

