/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.client;

import cn.org.gddsn.liss.client.LissException;
import cn.org.gddsn.liss.client.LissResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import org.apache.log4j.Logger;

public class LissControlSocket {
    static Logger logger;
    float version = -1.0f;
    static final String EOL = "\r\n";
    public static final String RT_DATA_TRANSPORT = "RT";
    public static final String NRT_DATA_TRANSPORT = "NRT";
    private static final int CONTROL_PORT = 5000;
    private Socket controlSock = null;
    private Writer writer = null;
    private BufferedReader reader = null;
    private String connectionInfo = "";
    private int timeOut = 160000;
    private String remoteHostAddress = null;
    private int remotePort = -1;
    private String localHostAddress = null;
    private int localPort = -1;
    private boolean throughFirewall = true;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.client.LissClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public LissControlSocket(String remoteHost, int port) throws IOException, LissException {
        this.controlSock = new Socket(remoteHost, port);
        this.controlSock.setSoTimeout(this.timeOut);
        this.getLocalHostAddress();
        this.getLocalHostPort();
        this.getRemoteHostAddress();
        this.getRemoteHostPort();
        this.connectionInfo = String.valueOf(this.controlSock.getLocalAddress().getHostName()) + ":" + this.controlSock.getLocalPort() + "->" + this.controlSock.getInetAddress().getHostName() + ":" + this.controlSock.getPort();
        this.connectionInfo = "Established " + this.connectionInfo + " at " + new Date();
        this.initStreams();
        this.validateConnection();
    }

    public LissControlSocket(String remoteHost) throws IOException, LissException {
        this(remoteHost, 5000);
    }

    public void setTimeOut(int ms) {
        this.timeOut = ms;
    }

    public void setThroughFirewall(boolean throughFirewall) {
        this.throughFirewall = throughFirewall;
    }

    public String getSocketConnectionInfo() {
        return this.connectionInfo;
    }

    private void validateConnection() throws IOException, LissException {
        LissResponse reply = this.readReply();
        this.validateReply(reply, "220");
        String hello = reply.getMessage();
        int idx = hello.indexOf("Version ");
        if (idx != -1) {
            try {
                String sver = hello.substring(idx + 8, idx + 11);
                this.version = Float.parseFloat(sver);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initStreams() throws IOException {
        InputStream is = this.controlSock.getInputStream();
        this.reader = new BufferedReader(new InputStreamReader(is));
        OutputStream os = this.controlSock.getOutputStream();
        this.writer = new OutputStreamWriter(os);
    }

    public void logout() throws IOException {
        this.writer.close();
        this.reader.close();
        this.controlSock.close();
    }

    ServerSocket createDataServerSocket(String dataType) throws IOException, LissException {
        ServerSocket dataServerSocket = new ServerSocket(0);
        dataServerSocket.setSoTimeout(this.timeOut);
        StringBuffer command = new StringBuffer("PORT " + dataType + " ");
        String host = this.controlSock.getLocalAddress().getHostAddress();
        command.append(host.replace('.', ','));
        int port = dataServerSocket.getLocalPort();
        command.append(',');
        command.append(port / 256);
        command.append(',');
        command.append(port % 256);
        LissResponse reply = this.sendCommand(command.toString());
        this.validateReply(reply, "200");
        return dataServerSocket;
    }

    Socket createPassiveDataSocket(String dataType) throws IOException, LissException {
        LissResponse reply = this.sendCommand("PASV " + dataType + " ");
        String[] validCode1 = new String[]{"227", "228"};
        this.validateReply(reply, validCode1);
        String message = reply.getMessage();
        int bracket1 = message.indexOf(40);
        int bracket2 = message.indexOf(41);
        String ipData = message.substring(bracket1 + 1, bracket2);
        int[] parts = new int[6];
        int len = ipData.length();
        int partCount = 0;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < len && partCount <= 6) {
            char ch = ipData.charAt(i);
            if (Character.isDigit(ch)) {
                buf.append(ch);
            } else if (ch != ',') {
                throw new LissException("Malformed PASV reply: " + reply);
            }
            if (ch == ',' || i + 1 == len) {
                try {
                    parts[partCount++] = Integer.parseInt(buf.toString());
                    buf.setLength(0);
                }
                catch (NumberFormatException ex) {
                    throw new LissException("Malformed PASV reply: " + reply);
                }
            }
            ++i;
        }
        String ipAddress = String.valueOf(parts[0]) + "." + parts[1] + "." + parts[2] + "." + parts[3];
        if (this.throughFirewall) {
            ipAddress = this.getRemoteHostAddress();
        }
        int port = (parts[4] << 8) + parts[5];
        if (logger.isDebugEnabled()) {
            logger.debug("PASV IP: " + ipAddress);
        }
        Socket dSocket = new Socket(ipAddress, port);
        dSocket.setSoTimeout(this.timeOut);
        return dSocket;
    }

    public LissResponse sendCommand(String command) throws IOException {
        this.writer.write(String.valueOf(command) + EOL);
        if (logger.isDebugEnabled()) {
            logger.debug("Sent command: " + command);
        }
        this.writer.flush();
        return this.readReply();
    }

    LissResponse readReply() throws IOException {
        return new LissResponse(this.reader);
    }

    public void validateReply(LissResponse reply, String expectedReplyCode) throws IOException, LissException {
        String replyCode = reply.getReturnCode();
        if (!replyCode.equals(expectedReplyCode)) {
            throw new LissException(reply.getMessage());
        }
    }

    public void validateReply(LissResponse reply, String[] expectedReplyCodes) throws IOException, LissException {
        String replyCode = reply.getReturnCode();
        int i = 0;
        while (i < expectedReplyCodes.length) {
            if (replyCode.equals(expectedReplyCodes[i])) {
                return;
            }
            ++i;
        }
        throw new LissException(reply.getMessage());
    }

    public String getLocalHostAddress() {
        if (this.localHostAddress == null) {
            this.localHostAddress = this.controlSock.getLocalAddress().getHostAddress();
        }
        return this.localHostAddress;
    }

    public int getLocalHostPort() {
        if (this.localPort == -1) {
            this.localPort = this.controlSock.getLocalPort();
        }
        return this.localPort;
    }

    String getRemoteHostAddress() {
        if (this.remoteHostAddress == null) {
            this.remoteHostAddress = this.controlSock.getInetAddress().getHostAddress();
        }
        return this.remoteHostAddress;
    }

    public boolean isThroughFirewall() {
        return this.throughFirewall;
    }

    int getRemoteHostPort() {
        if (this.remotePort == -1) {
            this.remotePort = this.controlSock.getPort();
        }
        return this.remotePort;
    }

    String getRemoteHostName() {
        InetAddress addr = this.controlSock.getInetAddress();
        return addr.getHostName();
    }

    public String getDetailHeader() {
        return String.valueOf(this.getLocalHostAddress()) + ":" + this.getLocalHostPort() + "/" + this.getRemoteHostName() + ":" + this.getRemoteHostPort();
    }
}

