/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.manager;

import cn.org.gddsn.liss.client.LissClient;
import cn.org.gddsn.util.Log4jConfig;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;

public class CLI {
    static Logger logger;
    static XmlBeanFactory factory;
    private LissClient lissClient;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.manager.CLI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public LissClient getLissClient() {
        return this.lissClient;
    }

    public void setLissClient(LissClient lissClient) {
        this.lissClient = lissClient;
    }

    public void ui(String[] args) throws Exception {
        String[] params;
        StringBuffer buf;
        String[] params2;
        String param;
        Options options = new Options();
        Option help = new Option("help", "print this message");
        Option add = new Option("add", "add operation");
        Option delete = new Option("delete", "delete operation");
        Option list = new Option("list", "list operation");
        Option update = new Option("update", "update operation");
        OptionGroup operationGroup = new OptionGroup();
        operationGroup.addOption(add).addOption(delete).addOption(list).addOption(update);
        OptionBuilder.withArgName((String)"sbox-config.xml");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"XML config file, sbox-config.xml");
        Option config = OptionBuilder.create((String)"config");
        OptionBuilder.withArgName((String)"stn0 stn1 ...");
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withDescription((String)"station");
        Option station = OptionBuilder.create((String)"station");
        OptionBuilder.withArgName((String)"user@ipaddress");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"user");
        Option user = OptionBuilder.create((String)"user");
        OptionBuilder.withArgName((String)"enable YES ...");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Server Buffer");
        Option buffer = OptionBuilder.create((String)"buffer");
        OptionBuilder.withArgName((String)"JDBCDriver s1  ...");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"connection Pool");
        Option pool = OptionBuilder.create((String)"pool");
        OptionBuilder.withArgName((String)"sendBufferSize num  ...");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"set socket buffer size.");
        Option socketBuffer = OptionBuilder.create((String)"socketBuffer");
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"use value for given property");
        Option props = OptionBuilder.create((String)"props");
        OptionBuilder.withArgName((String)"host gddsn.org.cn port 5000 ...");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"The source of Server");
        Option source = OptionBuilder.create((String)"source");
        OptionBuilder.withArgName((String)"host=gddsn.org.cn port=5000 ...");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"The target of Server");
        Option target = OptionBuilder.create((String)"target");
        OptionBuilder.withArgName((String)"id=1 tty=tty0 commParam=cp0 ...");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"linkmap of Serial or ComServ");
        Option linkmap = OptionBuilder.create((String)"linkmap");
        OptionBuilder.withArgName((String)"stn0=chanMask0 ...");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"add station to specified user");
        Option adds = OptionBuilder.create((String)"adds");
        OptionBuilder.withArgName((String)"stn0 stn1 ...");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"delete station to specified user");
        Option dels = OptionBuilder.create((String)"dels");
        OptionGroup typeGroup = new OptionGroup();
        typeGroup.addOption(config).addOption(station).addOption(user).addOption(buffer).addOption(socketBuffer).addOption(pool).addOption(source).addOption(target).addOption(linkmap).addOption(props);
        OptionBuilder.withArgName((String)"Server config");
        OptionBuilder.withDescription((String)"Server config");
        Option server = OptionBuilder.create((String)"Server");
        OptionBuilder.withArgName((String)"profile name");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withDescription((String)"Server2Server config");
        Option server2Server = OptionBuilder.create((String)"Server2Server");
        OptionBuilder.withArgName((String)"Serial to Server");
        OptionBuilder.withDescription((String)"Serial2Server config");
        Option serial2Server = OptionBuilder.create((String)"Serial2Server");
        OptionBuilder.withArgName((String)"Comserv to Server");
        OptionBuilder.withDescription((String)"Comserv2Server config");
        Option comServ2Server = OptionBuilder.create((String)"ComServ2Server");
        OptionGroup mainType = new OptionGroup();
        mainType.addOption(config).addOption(server).addOption(server2Server).addOption(serial2Server).addOption(comServ2Server);
        options.addOption(help).addOptionGroup(operationGroup).addOptionGroup(mainType).addOptionGroup(typeGroup).addOption(adds).addOption(dels);
        BasicParser parser = new BasicParser();
        CommandLine cmd = parser.parse(options, args);
        if (args.length == 0 || cmd.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("CLI", options);
            System.exit(-1);
        } else if (cmd.hasOption(list.getOpt()) && cmd.hasOption(config.getOpt())) {
            param = cmd.getOptionValue(config.getOpt());
            logger.info("Downloading sbox-config to " + param + " ...");
            FileOutputStream fos = new FileOutputStream(param);
            this.lissClient.getXmlConfig(fos);
            logger.info("Download sbox-config succeed.");
        } else if (cmd.hasOption(update.getOpt()) && cmd.hasOption(config.getOpt())) {
            param = cmd.getOptionValue(config.getOpt());
            logger.info("Uploading sbox-config to " + param + " ...");
            FileInputStream fin = new FileInputStream(param);
            this.lissClient.setXmlConfig(fin);
            logger.info("Uploading sobx-config succeed.");
        }
        if (cmd.hasOption(server.getOpt())) {
            if (cmd.hasOption(pool.getOpt())) {
                logger.info("Updating Connection Pool...");
                params2 = cmd.getOptionValues(pool.getOpt());
                buf = new StringBuffer("pool ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                this.lissClient.setServer(buf.substring(0));
                logger.info("Update Connection Pool success");
            } else if (cmd.hasOption(buffer.getOpt())) {
                logger.info("Updating buffer option...");
                params2 = cmd.getOptionValues(buffer.getOpt());
                buf = new StringBuffer("buffer ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                this.lissClient.setServer(buf.substring(0));
                logger.info("Update buffer option success");
            } else if (cmd.hasOption(socketBuffer.getOpt())) {
                logger.info("Updating socketbuffer option...");
                params2 = cmd.getOptionValues(socketBuffer.getOpt());
                buf = new StringBuffer("socketBuffer ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                this.lissClient.setServer(buf.substring(0));
                logger.info("Update socketbuffer option success");
            } else if (cmd.hasOption(add.getOpt()) && cmd.hasOption(station.getOpt())) {
                this.lissClient.addStation(cmd.getOptionValues(station.getOpt()));
                logger.info("Add station operation success");
            } else if (cmd.hasOption(delete.getOpt()) && cmd.hasOption(station.getOpt())) {
                this.lissClient.deleteStation(cmd.getOptionValues(station.getOpt()));
                logger.info("Delete station operation success");
            } else if (cmd.hasOption(add.getOpt()) && cmd.hasOption(user.getOpt())) {
                params2 = cmd.getOptionValues(user.getOpt());
                if (params2.length != 2) {
                    logger.info("Syntax in -user option");
                } else {
                    logger.info("Adding user " + params2[0]);
                    this.lissClient.addUser(params2[0], params2[1]);
                    logger.info("Add user " + params2[0] + " succeed.");
                }
            } else if (cmd.hasOption(delete.getOpt()) && cmd.hasOption(user.getOpt())) {
                param = cmd.getOptionValue(user.getOpt());
                logger.info("Deleting user " + param);
                this.lissClient.deleteUser(param);
                logger.info("Delete user " + param + " succeed.");
            } else if (cmd.hasOption(list.getOpt()) && cmd.hasOption(station.getOpt())) {
                String[] stns = this.lissClient.getAllStationCode();
                buf = new StringBuffer();
                int i = 0;
                while (i < stns.length) {
                    buf.append(' ');
                    buf.append(stns[i]);
                    ++i;
                }
                logger.info("Total stations: " + buf);
            } else if (cmd.hasOption(list.getOpt()) && cmd.hasOption(user.getOpt())) {
                param = cmd.getOptionValue(user.getOpt());
                logger.info("Listing user " + param);
                logger.info(this.lissClient.getUser(param));
                logger.info("List user " + param + " succeed.");
            } else if (cmd.hasOption(list.getOpt())) {
                logger.info("listing server config...");
                logger.info(this.lissClient.setServer("list"));
                logger.info("list server config succeed.");
            } else if (cmd.hasOption(update.getOpt()) && cmd.hasOption(user.getOpt())) {
                int i;
                StringBuffer buf2;
                String usr = cmd.getOptionValue(user.getOpt());
                logger.info("modifing the props for user " + usr);
                if (cmd.hasOption(props.getOpt())) {
                    params = cmd.getOptionValues(props.getOpt());
                    buf2 = new StringBuffer();
                    i = 0;
                    while (i < params.length / 2) {
                        buf2.append(' ');
                        buf2.append(params[i * 2]);
                        buf2.append('=');
                        buf2.append(params[i * 2 + 1]);
                        ++i;
                    }
                    this.lissClient.modifyUser(usr, buf2.substring(0));
                    logger.info("modified the props for user " + usr + " succeeded.");
                }
                if (cmd.hasOption(adds.getOpt())) {
                    logger.info("Adding station to user " + usr);
                    params = cmd.getOptionValues(adds.getOpt());
                    buf2 = new StringBuffer();
                    i = 0;
                    while (i < params.length / 2) {
                        buf2.append(' ');
                        buf2.append(params[i * 2]);
                        buf2.append('=');
                        buf2.append(params[i * 2 + 1]);
                        ++i;
                    }
                    this.lissClient.modifyUser(usr, " adds" + buf2.substring(0));
                    logger.info("add " + buf2.substring(0) + " to user " + usr + " succeed.");
                }
                if (cmd.hasOption(dels.getOpt())) {
                    logger.info("Deleting station to user " + usr);
                    params = cmd.getOptionValues(dels.getOpt());
                    buf2 = new StringBuffer();
                    i = 0;
                    while (i < params.length) {
                        buf2.append(' ');
                        buf2.append(params[i]);
                        ++i;
                    }
                    this.lissClient.modifyUser(usr, " dels" + buf2.substring(0));
                    logger.info("Delete " + buf2.substring(0) + " for user " + usr + " succeed.");
                }
                logger.info("set User properties:");
            }
        } else if (cmd.hasOption(serial2Server.getOpt())) {
            if (cmd.hasOption(list.getOpt())) {
                logger.info("Listing Serial2Server config:");
                logger.info(this.lissClient.setSerial2Server("list"));
                logger.info("List Serial2Server config succeed.");
            } else if (cmd.hasOption(socketBuffer.getOpt())) {
                logger.info("Updating socketbuffer option...");
                params2 = cmd.getOptionValues(socketBuffer.getOpt());
                buf = new StringBuffer("socketBuffer ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                this.lissClient.setSerial2Server(buf.substring(0));
                logger.info("Update socketbuffer option success");
            } else if (cmd.hasOption(props.getOpt())) {
                logger.info("Setting Serial2Server Options:");
                params2 = cmd.getOptionValues(props.getOpt());
                buf = new StringBuffer("SET ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                logger.info(this.lissClient.setSerial2Server(buf.substring(0)));
                logger.info("Set Serial2Server Options succeed.");
            } else if (cmd.hasOption(target.getOpt())) {
                logger.info("Setting Serial2Server target:");
                params2 = cmd.getOptionValues(target.getOpt());
                buf = new StringBuffer("TARGET ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                logger.info(this.lissClient.setSerial2Server(buf.substring(0)));
                logger.info("Set Serial2Server target succeed.");
            } else if (cmd.hasOption(add.getOpt()) && cmd.hasOption(linkmap.getOpt())) {
                logger.info("Adding linkmap");
                params2 = cmd.getOptionValues(linkmap.getOpt());
                buf = new StringBuffer("addLinkmap ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                logger.info(this.lissClient.setSerial2Server(buf.substring(0)));
                logger.info("Add linkmap succeed.");
            } else if (cmd.hasOption(update.getOpt()) && cmd.hasOption(linkmap.getOpt())) {
                logger.info("modifing linkmap");
                params2 = cmd.getOptionValues(linkmap.getOpt());
                buf = new StringBuffer("modifyLinkmap ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                logger.info(this.lissClient.setSerial2Server(buf.substring(0)));
                logger.info("Modify linkmap succeed.");
            } else if (cmd.hasOption(delete.getOpt()) && cmd.hasOption(linkmap.getOpt())) {
                logger.info("Deleting linkmap");
                params2 = cmd.getOptionValues(linkmap.getOpt());
                buf = new StringBuffer("deleteLinkmap ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                logger.info(this.lissClient.setSerial2Server(buf.substring(0)));
                logger.info("Delete linkmap succeed.");
            }
        } else if (cmd.hasOption(comServ2Server.getOpt())) {
            if (cmd.hasOption(list.getOpt())) {
                logger.info("Listing Comserv2Server config:");
                logger.info(this.lissClient.setComServ2Server("list"));
                logger.info("List Comserv2Server config succeed.");
            } else if (cmd.hasOption(socketBuffer.getOpt())) {
                logger.info("Updating socketbuffer option...");
                params2 = cmd.getOptionValues(socketBuffer.getOpt());
                buf = new StringBuffer("socketBuffer ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                this.lissClient.setComServ2Server(buf.substring(0));
                logger.info("Update socketbuffer option success");
            } else if (cmd.hasOption(props.getOpt())) {
                logger.info("Setting Comserv2Server Options:");
                params2 = cmd.getOptionValues(props.getOpt());
                buf = new StringBuffer("SET ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                logger.info(this.lissClient.setComServ2Server(buf.substring(0)));
                logger.info("Set Comserv2Server Options succeed.");
            } else if (cmd.hasOption(target.getOpt())) {
                logger.info("Setting Comserv2Server target:");
                params2 = cmd.getOptionValues(target.getOpt());
                buf = new StringBuffer("TARGET ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                logger.info(this.lissClient.setComServ2Server(buf.substring(0)));
                logger.info("Set Comserv2Server target succeed.");
            } else if (cmd.hasOption(add.getOpt()) && cmd.hasOption(linkmap.getOpt())) {
                logger.info("Adding linkmap");
                params2 = cmd.getOptionValues(linkmap.getOpt());
                buf = new StringBuffer("addLinkmap ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                logger.info(this.lissClient.setComServ2Server(buf.substring(0)));
                logger.info("Add linkmap succeed.");
            } else if (cmd.hasOption(update.getOpt()) && cmd.hasOption(linkmap.getOpt())) {
                logger.info("Modifing linkmap");
                params2 = cmd.getOptionValues(linkmap.getOpt());
                buf = new StringBuffer("modifyLinkmap ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                logger.info(this.lissClient.setComServ2Server(buf.substring(0)));
                logger.info("Modify linkmap succeed.");
            } else if (cmd.hasOption(delete.getOpt()) && cmd.hasOption(linkmap.getOpt())) {
                logger.info("Deleting linkmap");
                params2 = cmd.getOptionValues(linkmap.getOpt());
                buf = new StringBuffer("deleteLinkmap ");
                int i = 0;
                while (i < params2.length / 2) {
                    buf.append(' ');
                    buf.append(params2[i * 2]);
                    buf.append('=');
                    buf.append(params2[i * 2 + 1]);
                    ++i;
                }
                logger.info(this.lissClient.setComServ2Server(buf.substring(0)));
                logger.info("Delete linkmap succeed.");
            }
        } else if (cmd.hasOption(server2Server.getOpt())) {
            String profile = cmd.getOptionValue(server2Server.getOpt());
            if (cmd.hasOption(list.getOpt())) {
                logger.info("Listing Server2Server config:");
                logger.info(this.lissClient.setServer2Server(String.valueOf(profile) + " list"));
                logger.info("List Server2Server config succeed.");
            } else if (cmd.hasOption(socketBuffer.getOpt())) {
                logger.info("Updating socketbuffer option...");
                params = cmd.getOptionValues(socketBuffer.getOpt());
                StringBuffer buf3 = new StringBuffer("socketBuffer ");
                int i = 0;
                while (i < params.length / 2) {
                    buf3.append(' ');
                    buf3.append(params[i * 2]);
                    buf3.append('=');
                    buf3.append(params[i * 2 + 1]);
                    ++i;
                }
                this.lissClient.setServer2Server(buf3.substring(0));
                logger.info("Update socketbuffer option success");
            } else if (cmd.hasOption(props.getOpt())) {
                logger.info("Setting Server2Server Options:");
                params = cmd.getOptionValues(props.getOpt());
                StringBuffer buf4 = new StringBuffer(String.valueOf(profile) + " SET ");
                int i = 0;
                while (i < params.length / 2) {
                    buf4.append(' ');
                    buf4.append(params[i * 2]);
                    buf4.append('=');
                    buf4.append(params[i * 2 + 1]);
                    ++i;
                }
                logger.info(this.lissClient.setServer2Server(buf4.substring(0)));
                logger.info("Set Server2Server Options succeed.");
            } else if (cmd.hasOption(target.getOpt())) {
                logger.info("Setting Server2Server target:");
                params = cmd.getOptionValues(target.getOpt());
                StringBuffer buf5 = new StringBuffer(String.valueOf(profile) + " TARGET ");
                int i = 0;
                while (i < params.length / 2) {
                    buf5.append(' ');
                    buf5.append(params[i * 2]);
                    buf5.append('=');
                    buf5.append(params[i * 2 + 1]);
                    ++i;
                }
                logger.info(this.lissClient.setServer2Server(buf5.substring(0)));
                logger.info("Set Server2Server target succeed.");
            } else if (cmd.hasOption(source.getOpt())) {
                logger.info("Setting Server2Server source:");
                params = cmd.getOptionValues(source.getOpt());
                StringBuffer buf6 = new StringBuffer(String.valueOf(profile) + " SOURCE ");
                int i = 0;
                while (i < params.length / 2) {
                    buf6.append(' ');
                    buf6.append(params[i * 2]);
                    buf6.append('=');
                    buf6.append(params[i * 2 + 1]);
                    ++i;
                }
                logger.info(this.lissClient.setServer2Server(buf6.substring(0)));
                logger.info("Set Server2Server SOURCE succeed.");
            } else if (cmd.hasOption(add.getOpt()) && cmd.hasOption(station.getOpt())) {
                logger.info("Adding station");
                params = cmd.getOptionValues(station.getOpt());
                StringBuffer buf7 = new StringBuffer(String.valueOf(profile) + " addStation ");
                int i = 0;
                while (i < params.length) {
                    buf7.append(' ');
                    buf7.append(params[i]);
                    ++i;
                }
                logger.info(this.lissClient.setServer2Server(buf7.substring(0)));
                logger.info("Add station succeed.");
            } else if (cmd.hasOption(delete.getOpt()) && cmd.hasOption(station.getOpt())) {
                logger.info("Deleting station");
                params = cmd.getOptionValues(station.getOpt());
                StringBuffer buf8 = new StringBuffer(String.valueOf(profile) + " deleteStation ");
                int i = 0;
                while (i < params.length) {
                    buf8.append(' ');
                    buf8.append(params[i]);
                    ++i;
                }
                logger.info(this.lissClient.setServer2Server(buf8.substring(0)));
                logger.info("Delete station succeed.");
            }
        }
        this.lissClient.quit();
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain("CLI.properties");
        FileSystemResource res = new FileSystemResource("CLI.xml");
        factory = new XmlBeanFactory(res);
        CLI cli = (CLI)factory.getBean("cli");
        cli.ui(args);
    }
}

