/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.message;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.io.LittleEndianOutputStream;
import cn.org.gddsn.liss.message.LoginUserInfo;
import cn.org.gddsn.liss.message.MessageParseException;
import cn.org.gddsn.liss.message.Result;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ConnectionStatus
extends Result {
    static Logger logger;
    Vector conn = new Vector();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.message.ConnectionStatus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public ConnectionStatus(Result res) throws MessageParseException {
        super(res);
        this.parse();
    }

    private void parse() throws MessageParseException {
        FilterInputStream di = null;
        if (this.subType != 131077) {
            throw new MessageParseException("parse Error in ConnectionStatus");
        }
        try {
            di = this.wordOrder == 0 ? new LittleEndianInputStream(new ByteArrayInputStream(this.getData())) : new DataInputStream(new ByteArrayInputStream(this.getData()));
            int nUser = di.readInt();
            int i = 0;
            while (i < nUser) {
                byte[] userb = new byte[16];
                di.readFully(userb, 0, 16);
                String user = new String(userb).trim();
                byte[] ipb = new byte[32];
                di.readFully(ipb, 0, 32);
                String ipAddress = new String(ipb).trim();
                byte[] portb = new byte[16];
                di.readFully(portb, 0, 16);
                String port = new String(portb).trim();
                int permission = di.readInt();
                int priority = di.readInt();
                Date loginTime = new Date(di.readLong());
                long seconds = di.readLong();
                byte[] lastb = new byte[4096];
                di.readFully(lastb, 0, 4096);
                String lastCommand = new String(lastb).trim();
                boolean rtDataPortWorking = di.readLong() != 0L;
                Date rtDataPortBrokenTime = new Date(di.readLong());
                LoginUserInfo info = new LoginUserInfo(user, ipAddress, port, permission, priority, loginTime, seconds, lastCommand, rtDataPortWorking, rtDataPortBrokenTime);
                this.conn.add(info);
                ++i;
            }
        }
        catch (IOException ioEx) {
            throw new MessageParseException("parse Error in ConnectionStatus, throw IOException");
        }
    }

    public static byte[] buildConnectionStatus(Vector conn) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(conn.size() * 4096);
        LittleEndianOutputStream los = new LittleEndianOutputStream(bos);
        try {
            int nUser = conn.size();
            los.writeInt(nUser);
            int i = 0;
            while (i < nUser) {
                LoginUserInfo info = (LoginUserInfo)conn.elementAt(i);
                los.writeBytes(info.getUser(), 16);
                los.writeBytes(info.getIPAddress(), 32);
                los.writeBytes(info.getPort(), 16);
                los.writeInt(info.getPermission());
                los.writeInt(info.getPriority());
                los.writeLong(info.getLoginTime().getTime());
                los.writeLong(info.getSeconds());
                los.writeBytes(info.getLastCommand(), 4096);
                los.writeLong(info.IsRtDataPortWorking() ? 1 : 0);
                los.writeLong(info.getRtDataPortBrokenTime().getTime());
                ++i;
            }
            los.close();
            bos.close();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
        return bos.toByteArray();
    }

    public LoginUserInfo[] getConnectionStatus() {
        int count = this.conn.size();
        LoginUserInfo[] info = new LoginUserInfo[count];
        int i = 0;
        while (i < count) {
            info[i] = (LoginUserInfo)this.conn.elementAt(i);
            ++i;
        }
        return info;
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer(4096);
        strBuffer.append(super.toString());
        int i = 0;
        while (i < this.conn.size()) {
            LoginUserInfo info = (LoginUserInfo)this.conn.elementAt(i);
            strBuffer.append(String.valueOf(info.toString()) + "\n");
            ++i;
        }
        return strBuffer.toString();
    }
}

