/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.message;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.io.LittleEndianOutputStream;
import cn.org.gddsn.liss.message.MessageParseException;
import cn.org.gddsn.liss.message.Result;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class LocationSMS
extends Result {
    static Logger logger;
    Location_Frame lframe = new Location_Frame();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.message.LocationSMS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public LocationSMS(Result res) throws MessageParseException {
        super(res);
        this.parse();
    }

    private void parse() throws MessageParseException {
        FilterInputStream di = null;
        if ((this.subType & 0x10000) != 65536) {
            throw new MessageParseException("parse Error in LocationSMS");
        }
        try {
            di = this.wordOrder == 0 ? new LittleEndianInputStream(new ByteArrayInputStream(this.getData())) : new DataInputStream(new ByteArrayInputStream(this.getData()));
            this.parseLocation_Frame((DataInput)((Object)di));
        }
        catch (IOException ioEx) {
            throw new MessageParseException("parse Error in LocationSMS, throw IOException");
        }
    }

    public static byte[] buildLocationSMSData(Location_Frame lframe) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        LittleEndianOutputStream los = new LittleEndianOutputStream(bos);
        try {
            los.writeBytes("LOCATION", 16);
            los.writeBytes("Ver 1.0", 12);
            los.writeInt(lframe.epic_id);
            los.writeBytes("", 28);
            los.writeInt(lframe.src_id);
            los.writeBytes("", 32);
            los.writeBytes("BJ-DSN", 80);
            los.writeInt(lframe.stn_sum);
            los.writeFloat(lframe.centlat);
            los.writeFloat(lframe.centlon);
            los.writeFloat(lframe.centalt);
            los.writeInt(lframe.year);
            los.writeInt(lframe.month);
            los.writeInt(lframe.day);
            los.writeInt(lframe.hour);
            los.writeInt(lframe.min);
            los.writeFloat(lframe.sec);
            los.writeDouble(lframe.unused1);
            los.writeDouble(lframe.otime);
            los.writeFloat(lframe.lat);
            los.writeFloat(lframe.lon);
            los.writeFloat(lframe.depth);
            los.writeFloat(lframe.delta);
            los.writeFloat(lframe.azmuth);
            los.writeFloat(lframe.ox);
            los.writeFloat(lframe.oy);
            los.writeInt(lframe.x);
            los.writeInt(lframe.y);
            los.writeFloat(lframe.ML);
            los.writeFloat(lframe.MD);
            los.writeFloat(lframe.MS);
            los.writeFloat(lframe.Mb);
            los.writeFloat(lframe.mB);
            los.writeFloat(lframe.Mm);
            los.writeFloat(lframe.res);
            los.writeFloat(lframe.epic_act);
            los.writeFloat(lframe.depth_act);
            los.writeInt(lframe.stn);
            los.writeInt(lframe.loc_stn);
            los.writeInt(lframe.nphase);
            los.writeInt(lframe.n_loc_phase);
            los.writeByte(lframe.C1);
            los.writeByte(lframe.C2);
            los.writeByte(lframe.C3);
            los.writeByte(lframe.unused);
            los.close();
            bos.close();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
        return bos.toByteArray();
    }

    void parseLocation_Frame(DataInput di) throws IOException {
        byte[] buf = new byte[1024];
        di.readFully(buf, 0, 16);
        di.readFully(buf, 0, 12);
        this.lframe.epic_id = di.readInt();
        di.readFully(buf, 0, 28);
        this.lframe.src_id = di.readInt();
        di.readFully(buf, 0, 32);
        di.readFully(buf, 0, 80);
        this.lframe.stn_sum = di.readInt();
        this.lframe.centlat = di.readFloat();
        this.lframe.centlon = di.readFloat();
        this.lframe.centalt = di.readFloat();
        this.lframe.year = di.readInt();
        this.lframe.month = di.readInt();
        this.lframe.day = di.readInt();
        this.lframe.hour = di.readInt();
        this.lframe.min = di.readInt();
        this.lframe.sec = di.readFloat();
        this.lframe.unused1 = di.readDouble();
        this.lframe.otime = di.readDouble();
        this.lframe.lat = di.readFloat();
        this.lframe.lon = di.readFloat();
        this.lframe.depth = di.readFloat();
        this.lframe.delta = di.readFloat();
        this.lframe.azmuth = di.readFloat();
        this.lframe.ox = di.readFloat();
        this.lframe.oy = di.readFloat();
        this.lframe.x = di.readInt();
        this.lframe.y = di.readInt();
        this.lframe.ML = di.readFloat();
        this.lframe.MD = di.readFloat();
        this.lframe.MS = di.readFloat();
        this.lframe.Mb = di.readFloat();
        this.lframe.mB = di.readFloat();
        this.lframe.Mm = di.readFloat();
        this.lframe.res = di.readFloat();
        this.lframe.epic_act = di.readFloat();
        this.lframe.depth_act = di.readFloat();
        this.lframe.stn = di.readInt();
        this.lframe.loc_stn = di.readInt();
        this.lframe.nphase = di.readInt();
        this.lframe.n_loc_phase = di.readInt();
        this.lframe.C1 = di.readByte();
        this.lframe.C2 = di.readByte();
        this.lframe.C3 = di.readByte();
        this.lframe.unused = di.readByte();
    }

    public static void main(String[] args) {
    }

    public static class Location_Frame {
        public static final String magic = "LOCATION";
        public static final String VERSION = "Ver 1.0";
        public int epic_id;
        public String epic;
        public int src_id;
        public String netName;
        public byte[] netNameBytes = new byte[80];
        public int stn_sum;
        public float centlat;
        public float centlon;
        public float centalt;
        public int year;
        public int month;
        public int day;
        public int hour;
        public int min;
        public float sec;
        public double unused1;
        public double otime;
        public float lat;
        public float lon;
        public float depth;
        public float delta;
        public float azmuth;
        public float ox;
        public float oy;
        public int x;
        public int y;
        public float ML;
        public float MD;
        public float MS;
        public float Mb;
        public float mB;
        public float Mm;
        public float res;
        public float epic_act;
        public float depth_act;
        public int stn;
        public int loc_stn;
        public int nphase;
        public int n_loc_phase;
        byte C1;
        byte C2;
        byte C3;
        byte unused;
    }
}

