/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.message;

import cn.org.gddsn.convert.cs_printf;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LoginUserInfo
implements Comparable,
Cloneable {
    static SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss");
    public String user;
    public String ipAddress;
    public String port;
    public int permission;
    public int priority;
    public Date loginTime;
    public long seconds;
    public String lastCommand = "";
    public boolean rtDataPortWorking = false;
    public Date rtDataPortBrokenTime = new Date();
    public boolean forceToQuit = false;

    public LoginUserInfo() {
    }

    public LoginUserInfo(String user, String ipAddress, String port, int permission, int priority, Date loginTime, long seconds, String lastCommand, boolean rtDataPortWorking, Date rtDataPortBrokenTime) {
        this.user = user;
        this.ipAddress = ipAddress;
        this.port = port;
        this.permission = permission;
        this.priority = priority;
        this.loginTime = loginTime;
        this.seconds = seconds;
        this.lastCommand = lastCommand;
        this.rtDataPortWorking = rtDataPortWorking;
        this.rtDataPortBrokenTime = rtDataPortBrokenTime;
    }

    public LoginUserInfo(String user, String ipAddress, String port, int permission, int priority) {
        this(user, ipAddress, port, permission, priority, new Date(), -1L, "", false, new Date());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getFullUserName() {
        return String.valueOf(this.user) + "@" + this.ipAddress;
    }

    public String getUser() {
        return this.user;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public String getPort() {
        return this.port;
    }

    public int getPermission() {
        return this.permission;
    }

    public int getPriority() {
        return this.priority;
    }

    public Date getLoginTime() {
        return this.loginTime;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public String getLastCommand() {
        return this.lastCommand;
    }

    public boolean IsRtDataPortWorking() {
        return this.rtDataPortWorking;
    }

    public Date getRtDataPortBrokenTime() {
        return this.rtDataPortBrokenTime;
    }

    public int compareTo(Object o) {
        LoginUserInfo obj = (LoginUserInfo)o;
        if (this.permission < obj.permission) {
            return 1;
        }
        if (this.permission > obj.permission) {
            return -1;
        }
        if (this.priority < obj.priority) {
            return 1;
        }
        if (this.priority > obj.priority) {
            return -1;
        }
        return 0;
    }

    public String printLastCommand() {
        StringBuffer buf = new StringBuffer(60);
        cs_printf cp = new cs_printf(buf);
        cp.printf("%-8s", this.user);
        cp.printf("%-24s", String.valueOf(this.ipAddress) + ":" + this.port);
        cp.printf("%-s", this.lastCommand);
        return buf.substring(0);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(60);
        cs_printf cp = new cs_printf(buf);
        cp.printf("%-8s", this.user);
        cp.printf("%-24s", String.valueOf(this.ipAddress) + ":" + this.port);
        cp.printf("%-22s", sdf.format(this.loginTime));
        if (this.seconds == -1L) {
            cp.printf("%-16s", "still logged in");
        } else {
            int day = (int)(this.seconds / 86400L);
            int left = (int)(this.seconds % 86400L);
            int hour = left / 3600;
            int min = (left %= 3600) / 60;
            cp.printf("%-16s", day + "+" + hour + ":" + min);
        }
        return buf.substring(0);
    }
}

