/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.message;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.io.LittleEndianOutputStream;
import cn.org.gddsn.liss.message.MessageParseException;
import cn.org.gddsn.liss.message.Result;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MemoryStatus
extends Result {
    static Logger logger;
    private int totalInM;
    private int freeInM;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.message.MemoryStatus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public MemoryStatus(Result res) throws MessageParseException {
        super(res);
        this.parse();
    }

    private void parse() throws MessageParseException {
        FilterInputStream di = null;
        if (this.subType != 131075) {
            throw new MessageParseException("parse Error in MemoryStatus");
        }
        try {
            di = this.wordOrder == 0 ? new LittleEndianInputStream(new ByteArrayInputStream(this.getData())) : new DataInputStream(new ByteArrayInputStream(this.getData()));
            this.totalInM = di.readInt();
            this.freeInM = di.readInt();
        }
        catch (IOException ioEx) {
            throw new MessageParseException("parse Error in MemoryStatus, throw IOException");
        }
    }

    public static byte[] buildMemoryStatusData(int totalInM, int freeInM) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
        LittleEndianOutputStream los = new LittleEndianOutputStream(bos);
        try {
            los.writeInt(totalInM);
            los.writeInt(freeInM);
            los.close();
            bos.close();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
        return bos.toByteArray();
    }

    public int getTotalInM() {
        return this.totalInM;
    }

    public int getFreeInM() {
        return this.freeInM;
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer(1024);
        strBuffer.append(super.toString());
        strBuffer.append("Total memory( MB ) :\t" + this.totalInM + "\n");
        strBuffer.append("Free memory( MB ) :\t" + this.freeInM + "\n");
        return strBuffer.toString();
    }
}

