/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.message;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.io.LittleEndianOutputStream;
import cn.org.gddsn.liss.message.MessageParseException;
import cn.org.gddsn.liss.message.Result;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class NetWorkStatus
extends Result {
    static Logger logger;
    private int readRateInKperSec;
    private int writeRateInKperSec;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.message.NetWorkStatus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public NetWorkStatus(Result res) throws MessageParseException {
        super(res);
        this.parse();
    }

    private void parse() throws MessageParseException {
        FilterInputStream di = null;
        if (this.subType != 131076) {
            throw new MessageParseException("parse Error in MemoryStatus");
        }
        try {
            di = this.wordOrder == 0 ? new LittleEndianInputStream(new ByteArrayInputStream(this.getData())) : new DataInputStream(new ByteArrayInputStream(this.getData()));
            this.readRateInKperSec = di.readInt();
            this.writeRateInKperSec = di.readInt();
        }
        catch (IOException ioEx) {
            throw new MessageParseException("parse Error in MemoryStatus, throw IOException");
        }
    }

    public static byte[] buildNetworkStatusData(int readRateInKperSec, int writeRateInKperSec) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
        LittleEndianOutputStream los = new LittleEndianOutputStream(bos);
        try {
            los.writeInt(readRateInKperSec);
            los.writeInt(writeRateInKperSec);
            los.close();
            bos.close();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
        return bos.toByteArray();
    }

    public int getReadRateInKperSec() {
        return this.readRateInKperSec;
    }

    public int getWriteRateInKperSec() {
        return this.writeRateInKperSec;
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer(1024);
        strBuffer.append(super.toString());
        strBuffer.append("Receive Rate (KB/s):\t" + this.readRateInKperSec + "\n");
        strBuffer.append("Send Rate (KB/s):\t" + this.writeRateInKperSec + "\n");
        return strBuffer.toString();
    }
}

