/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.message;

import cn.org.gddsn.convert.CStringToJava;
import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.io.LittleEndianOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.log4j.Logger;

public class Result {
    static Logger logger;
    static int MAX_MESSAGE_LENGTH;
    static final int HEAD_LENGTH = 96;
    public static final int PRIORITY_EMERG = 0;
    public static final int PRIORITY_ALERT = 1;
    public static final int PRIORITY_CRIT = 2;
    public static final int PRIORITY_ERR = 3;
    public static final int PRIORITY_WARNING = 4;
    public static final int PRIORITY_NOTICE = 5;
    public static final int PRIORITY_INFO = 6;
    public static final int PRIORITY_DEBUG = 7;
    private static final String[] PRIORITY_NAME;
    public static final int MAIN_TYPE_LOCALTION = 65536;
    public static final int LOCALTION_XML = 65568;
    public static final int LOCALTION_REAL = 65537;
    public static final int LOCALTION_IAS = 65538;
    public static final int LOCALTION_CATA = 65540;
    public static final int LOCALTION_TEST = 65544;
    public static final int MAIN_TYPE_MONITOR = 131072;
    public static final int MAIN_TYPE_DYNAMICS = 262144;
    public static final int MAIN_TYPE_INTENSITY = 524288;
    public static final int TYPE_DISK_SPACE = 131073;
    public static final int TYPE_WAVEFORM_STREAM_STATUS = 131074;
    public static final int TYPE_MEMORY_STATUS = 131075;
    public static final int TYPE_NETWORK_STATUS = 131076;
    public static final int TYPE_CONNECTION_STATUS = 131077;
    public static final int TYPE_SMS = 131078;
    public static final int TYPE_EVENT_ALARM = 131079;
    public static final int TYPE_LOG = 131328;
    public static final int TYPE_SUBSYSTEM = 131200;
    protected byte[] bytes = null;
    protected int wordOrder = -1;
    protected int priority;
    protected static final byte[] reserved1;
    protected int length;
    protected int subType;
    protected String networkID;
    protected String nodeID;
    protected int netFlag;
    protected Date msgTime;
    protected static final byte[] reserved2;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.message.Result");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        MAX_MESSAGE_LENGTH = 0x100000;
        PRIORITY_NAME = new String[]{"EMERG", "ALERT", "CRIT", "ERR", "WARNING", "NOTICE", "INFO", "DEBUG"};
        reserved1 = new byte[2];
        reserved2 = new byte[24];
    }

    private Result() {
    }

    public Result(Result ares) {
        this.bytes = ares.bytes;
        this.wordOrder = ares.wordOrder;
        this.priority = ares.priority;
        this.length = ares.length;
        this.subType = ares.subType;
        this.networkID = ares.networkID;
        this.nodeID = ares.nodeID;
        this.netFlag = ares.netFlag;
        this.msgTime = ares.msgTime;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] getData() {
        byte[] data = new byte[this.bytes.length - 96];
        System.arraycopy(this.bytes, 96, data, 0, data.length);
        return data;
    }

    public int getLength() {
        return this.length;
    }

    public int getType() {
        return this.subType;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getNetworkID() {
        return this.networkID;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public int getNetFlag() {
        return this.netFlag;
    }

    public Date getMsgTime() {
        return this.msgTime;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("[word order: \t" + (this.wordOrder == 0 ? "Intel\r\n" : "SPARC\r\n"));
        sbuf.append(" Frame Length: \t" + this.length + "\r\n");
        sbuf.append(" priority: \t" + PRIORITY_NAME[this.priority] + "\r\n");
        sbuf.append(" Info Type: \t0x" + Integer.toHexString(this.subType) + "\r\n");
        sbuf.append(" network ID: \t" + this.networkID + "\r\n");
        sbuf.append(" Node ID: \t" + this.nodeID + "\r\n");
        sbuf.append(" NetFlag: \t" + (this.netFlag == 0 ? "Native\r\n" : "OutSide\r\n"));
        sbuf.append(" Msg Time: \t" + this.msgTime + " ]\r\n");
        return sbuf.substring(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result buildResult(boolean bIntel, int priority, int type, String networkID, String nodeID, int netFlag, Date msgTime, byte[] data) {
        Result res = new Result();
        res.wordOrder = bIntel ? 0 : 1;
        res.length = 96 + data.length - 4 - 4;
        res.priority = priority;
        if (priority < 0 || priority > 8) {
            priority = 7;
        }
        res.subType = type;
        res.networkID = networkID;
        res.nodeID = nodeID;
        res.netFlag = netFlag;
        res.msgTime = msgTime;
        ByteArrayOutputStream bos = null;
        FilterOutputStream dos = null;
        FilterOutputStream leis = null;
        try {
            block14: {
                try {
                    bos = new ByteArrayOutputStream(96 + data.length);
                    if (bIntel) {
                        leis = new LittleEndianOutputStream(bos);
                        ((LittleEndianOutputStream)leis).writeByte(res.wordOrder);
                        ((LittleEndianOutputStream)leis).writeByte(res.priority);
                        leis.write(reserved1);
                        ((LittleEndianOutputStream)leis).writeInt(res.length);
                        ((LittleEndianOutputStream)leis).writeInt(res.subType);
                        leis.write(CStringToJava.pad(res.networkID, 16, '\u0000').getBytes());
                        leis.write(CStringToJava.pad(res.nodeID, 32, '\u0000').getBytes());
                        ((LittleEndianOutputStream)leis).writeInt(res.netFlag);
                        ((LittleEndianOutputStream)leis).writeLong(res.msgTime.getTime());
                        leis.write(reserved2);
                        leis.write(data);
                        leis.close();
                        bos.close();
                        res.bytes = bos.toByteArray();
                        break block14;
                    }
                    dos = new DataOutputStream(bos);
                    ((DataOutputStream)dos).writeByte(res.wordOrder);
                    ((DataOutputStream)dos).writeByte(res.priority);
                    dos.write(reserved1);
                    ((DataOutputStream)dos).writeInt(res.length);
                    ((DataOutputStream)dos).writeInt(res.subType);
                    dos.write(CStringToJava.pad(res.networkID, 16, '\u0000').getBytes());
                    dos.write(CStringToJava.pad(res.nodeID, 32, '\u0000').getBytes());
                    ((DataOutputStream)dos).writeInt(res.netFlag);
                    ((DataOutputStream)dos).writeLong(res.msgTime.getTime());
                    dos.write(reserved2);
                    dos.write(data);
                    dos.close();
                    bos.close();
                    res.bytes = bos.toByteArray();
                }
                catch (IOException ioEx) {
                    logger.warn(ioEx.getMessage(), ioEx);
                }
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                if (dos != null) {
                    dos.close();
                    dos = null;
                }
                if (leis != null) {
                    leis.close();
                    leis = null;
                }
                if (bos == null) throw throwable;
                bos.close();
                bos = null;
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return res;
        }
        if (dos != null) {
            dos.close();
            dos = null;
        }
        if (leis != null) {
            leis.close();
            leis = null;
        }
        if (bos == null) return res;
        bos.close();
        bos = null;
        return res;
    }

    public static Result buildResult(InputStream in) throws IOException {
        Result res = new Result();
        res.wordOrder = in.read();
        if (res.wordOrder == -1) {
            throw new EOFException();
        }
        res.priority = in.read();
        if (res.priority < 0 || res.priority > 7) {
            res.priority = 7;
        }
        in.skip(2L);
        if (res.wordOrder == 0) {
            LittleEndianInputStream leis = new LittleEndianInputStream(in);
            res.length = leis.readInt();
            if (res.length > MAX_MESSAGE_LENGTH) {
                res.length = MAX_MESSAGE_LENGTH;
            }
            if (res.length < 96) {
                return null;
            }
            res.bytes = new byte[8 + res.length];
            res.bytes[0] = 0;
            res.bytes[1] = (byte)res.priority;
            res.bytes[4] = (byte)(res.length >>> 0 & 0xFF);
            res.bytes[5] = (byte)(res.length >>> 8 & 0xFF);
            res.bytes[6] = (byte)(res.length >>> 16 & 0xFF);
            res.bytes[7] = (byte)(res.length >>> 24 & 0xFF);
            Result.readAll(leis, res.bytes, 8, res.length);
            leis = new LittleEndianInputStream(new ByteArrayInputStream(res.bytes, 8, res.length));
            res.subType = leis.readInt();
            byte[] tmp = new byte[16];
            leis.read(tmp);
            res.networkID = new String(tmp).trim();
            tmp = new byte[32];
            leis.read(tmp);
            res.nodeID = new String(tmp).trim();
            res.netFlag = leis.readInt();
            res.msgTime = new Date(leis.readLong());
            leis = null;
            tmp = null;
        } else {
            DataInputStream dis = new DataInputStream(in);
            res.length = dis.readInt();
            if (res.length > MAX_MESSAGE_LENGTH) {
                res.length = MAX_MESSAGE_LENGTH;
            }
            if (res.length < 96) {
                return null;
            }
            res.bytes = new byte[8 + res.length];
            res.bytes[0] = 1;
            res.bytes[1] = (byte)res.priority;
            res.bytes[4] = (byte)(res.length >>> 24 & 0xFF);
            res.bytes[5] = (byte)(res.length >>> 16 & 0xFF);
            res.bytes[6] = (byte)(res.length >>> 8 & 0xFF);
            res.bytes[7] = (byte)(res.length >>> 0 & 0xFF);
            Result.readAll(dis, res.bytes, 8, res.length);
            dis = new DataInputStream(new ByteArrayInputStream(res.bytes, 8, res.length));
            res.subType = dis.readInt();
            byte[] tmp = new byte[16];
            dis.read(tmp);
            res.networkID = new String(tmp).trim();
            tmp = new byte[32];
            dis.read(tmp);
            res.nodeID = new String(tmp).trim();
            res.netFlag = dis.readInt();
            res.msgTime = new Date(dis.readLong());
            dis = null;
            byte[] byArray = null;
        }
        return res;
    }

    private static void readAll(InputStream in, byte[] buf, int indx, int length) throws IOException {
        int idx = indx;
        int len = length;
        int nRead = 0;
        while ((nRead = in.read(buf, idx, len)) > 0) {
            idx += nRead;
            if ((len -= nRead) != 0) continue;
            return;
        }
        throw new EOFException();
    }
}

