/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port;

import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import edu.iris.timeutils.TimeStamp;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class MiniSeedHeaderFilter {
    static Logger logger;
    public static final int ORDER_BY_NONE = 0;
    public static final int ORDER_BY_CHANNEL = 1;
    public static final int ORDER_BY_CHANNEL_BAUD = 2;
    public static final int ORDER_BY_LOC_ID = 3;
    public static final int ORDER_BY_STATION = 4;
    public static final int ORDER_BY_NETWORK = 5;
    public static final int ORDER_BY_ALL = 6;
    private boolean correctStartTime = false;
    private Hashtable tbl = new Hashtable();
    private int orderBy = 0;
    private Hashtable channelMapping = null;
    private String defaultMappingNetwork = null;
    private String defaultMappingLocID = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.MiniSeedHeaderFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public GenericMiniSeedRecord filter(GenericMiniSeedRecord gmsr) {
        if (this.correctStartTime) {
            this.correctStartTime(gmsr);
        }
        this.orderBy(gmsr);
        return gmsr;
    }

    private void correctStartTime(GenericMiniSeedRecord gmsr) {
        int wei = (int)Math.ceil(Math.log(gmsr.getSampleRate()) / Math.log(10.0)) + 1;
        int ex = 9 - wei;
        long sec = gmsr.getStartTime().getTime() / 1000L;
        double fracSec = (double)gmsr.getStartTime().getNanoSecs() / 1.0E9;
        int ns = (int)((double)Math.round(fracSec * Math.pow(10.0, wei)) * Math.pow(10.0, ex));
        if (ns == 1000000000) {
            ++sec;
            ns = 0;
        }
        if (ns < 0 || (long)ns > 999999999L) {
            logger.warn("ns=" + ns + " is invalid!, do not correct Start Time, ignore!");
        }
        TimeStamp ts = new TimeStamp(sec * 1000L);
        ts.setNanos(ns);
        gmsr.setStartTime(ts);
    }

    private void orderBy(GenericMiniSeedRecord gmsr) {
        String temp = String.valueOf(gmsr.getNetwork()) + "/" + gmsr.getStation() + "/" + gmsr.getLocID() + "/" + gmsr.getChannel();
        int len = temp.length();
        String key = "";
        switch (this.orderBy) {
            case 0: {
                return;
            }
            case 1: {
                key = temp;
                break;
            }
            case 2: {
                key = temp.substring(0, len - 2);
                break;
            }
            case 3: {
                key = String.valueOf(gmsr.getNetwork()) + "/" + gmsr.getStation() + "/" + gmsr.getLocID();
                break;
            }
            case 4: {
                key = String.valueOf(gmsr.getNetwork()) + "/" + gmsr.getStation();
                break;
            }
            case 5: {
                key = gmsr.getNetwork();
                break;
            }
            case 6: {
                break;
            }
        }
        Sequence seq = (Sequence)this.tbl.get(key);
        if (seq == null) {
            seq = new Sequence();
            this.tbl.put(key, seq);
        }
        gmsr.setSequenceNumber(seq.seq);
        seq.incSeq();
    }

    public Hashtable getChannelMapping() {
        return this.channelMapping;
    }

    public boolean isCorrectStartTime() {
        return this.correctStartTime;
    }

    public String getDefaultMappingLocID() {
        return this.defaultMappingLocID;
    }

    public String getDefaultMappingNetwork() {
        return this.defaultMappingNetwork;
    }

    public int getOrderBy() {
        return this.orderBy;
    }

    public void setChannelMapping(Hashtable channelMapping) {
        this.channelMapping = channelMapping;
    }

    public void setCorrectStartTime(boolean correctStartTime) {
        this.correctStartTime = correctStartTime;
    }

    public void setDefaultMappingLocID(String defaultMappingLocID) {
        this.defaultMappingLocID = defaultMappingLocID;
    }

    public void setDefaultMappingNetwork(String defaultMappingNetwork) {
        this.defaultMappingNetwork = defaultMappingNetwork;
    }

    public void setOrderBy(int orderBy) {
        this.orderBy = orderBy;
    }

    private static class Sequence {
        public int seq = 0;

        private Sequence() {
        }

        public void incSeq() {
            this.seq = (this.seq + 1) % 1000000;
        }
    }
}

