/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port;

import cn.org.gddsn.liss.port.AbstractMiniSeedPort;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniseedFormatException;
import edu.iris.miniseedutils.steim.UnrecognizedBlocketteException;
import edu.iris.miniseedutils.steim.UnrecognizedFormatException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketException;
import org.apache.log4j.Logger;

public abstract class MiniSeedPort
extends AbstractMiniSeedPort {
    static Logger logger;
    protected String host = "127.0.0.1";
    protected int port = 5000;
    protected Thread sendSeedDataThread = null;
    protected InputStream receiveFromLISS = null;
    protected MiniSeedPort thisPort;
    private byte[] buf = new byte[8192];
    private byte[] dummy = new byte[512];
    private int trIdx = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.ComServPort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public MiniSeedPort() {
    }

    public MiniSeedPort(String newServerName, int newSeedPort) {
        this.host = newServerName;
        this.port = newSeedPort;
    }

    public void closePort() {
        super.closePort();
        this.clean();
    }

    private void clean() {
        this.trIdx = 0;
        try {
            if (this.receiveFromLISS != null) {
                this.receiveFromLISS.close();
            }
            this.receiveFromLISS = null;
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            logger.warn("Failed I/O to " + this.host + " : " + ioEx + " in this.close()");
        }
    }

    public boolean connectOK() {
        return this.receiveFromLISS != null;
    }

    public int indexOf(byte[] buffer, byte[] str, int fromIndex) {
        return MiniSeedPort.indexOf(buffer, 0, buffer.length, str, 0, str.length, fromIndex);
    }

    static int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int i = sourceOffset + fromIndex;
        int max = sourceOffset + (sourceCount - targetCount);
        block0: while (true) {
            if (i <= max && source[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end) {
                if (source[j++] == target[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i - sourceOffset;
    }

    public byte[] readMiniSeedFrame() throws IOException {
        GenericMiniSeedRecord gmsRec = null;
        try {
            gmsRec = this.getCurrentMiniSeedData();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        if (gmsRec == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(gmsRec);
        }
        return gmsRec.getBytes();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GenericMiniSeedRecord getCurrentMiniSeedData() {
        if (!this.connectOK()) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.connectServer()) {
                return null;
            }
        }
        int blkSize = 512;
        int realRecSize = 0;
        GenericMiniSeedRecord gmsr = null;
        byte[] aaaa = new byte[]{-86, -86, -86, -86, -86, -86, -86, -86};
        try {
            while (true) {
                if (this.trIdx >= blkSize) {
                    int kkk = this.indexOf(this.buf, aaaa, 0);
                    if (kkk != -1) {
                        logger.warn("Got aaaa string at: " + kkk);
                        this.writeBadBlock();
                    }
                    try {
                        if (GenericMiniSeedRecord.getRecordLength(this.buf) == -1) {
                            throw new UnrecognizedBlocketteException("Data only Blockette[1000] NOT FOUND");
                        }
                        break;
                    }
                    catch (MiniseedFormatException msfEx) {
                        logger.warn(msfEx.getMessage(), msfEx);
                        this.writeBadBlock();
                        System.arraycopy(this.buf, 0, this.dummy, 0, blkSize);
                        this.trIdx -= blkSize;
                        System.arraycopy(this.buf, blkSize, this.buf, 0, this.trIdx);
                        return null;
                    }
                    catch (UnrecognizedBlocketteException ubEx) {
                        logger.warn(ubEx.getMessage(), ubEx);
                        this.writeBadBlock();
                        System.arraycopy(this.buf, 0, this.dummy, 0, blkSize);
                        this.trIdx -= blkSize;
                        System.arraycopy(this.buf, blkSize, this.buf, 0, this.trIdx);
                        return null;
                    }
                    catch (UnrecognizedFormatException ufEx) {
                        logger.warn(ufEx.getMessage(), ufEx);
                        this.writeBadBlock();
                        System.arraycopy(this.buf, 0, this.dummy, 0, blkSize);
                        this.trIdx -= blkSize;
                        System.arraycopy(this.buf, blkSize, this.buf, 0, this.trIdx);
                        return null;
                    }
                    catch (Exception ex1) {
                        logger.warn(ex1.getMessage(), ex1);
                        this.writeBadBlock();
                        System.arraycopy(this.buf, 0, this.dummy, 0, blkSize);
                        this.trIdx -= blkSize;
                        System.arraycopy(this.buf, blkSize, this.buf, 0, this.trIdx);
                        return null;
                    }
                }
                realRecSize = this.receiveFromLISS.read(this.buf, this.trIdx, blkSize);
                if (realRecSize == -1) {
                    logger.warn("God, reach the end of Stream");
                    throw new SocketException("God, reach the end of Stream");
                }
                this.trIdx += realRecSize;
            }
            try {
                gmsr = GenericMiniSeedRecord.buildMiniSeedRecord(this.buf);
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage(), ex);
                this.clean();
                this.writeBadBlock();
                return null;
            }
            if (gmsr == null) {
                logger.warn("Get Null miniseed.");
                this.writeBadBlock();
            }
            System.arraycopy(this.buf, 0, this.dummy, 0, blkSize);
            this.trIdx -= blkSize;
            System.arraycopy(this.buf, blkSize, this.buf, 0, this.trIdx);
        }
        catch (SocketException sEx) {
            logger.warn(sEx.getMessage(), sEx);
            this.clean();
            try {
                Thread.sleep(5000L);
                return null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
        catch (InterruptedIOException iioEx) {
            logger.warn("InterruptedIOException in MiniSeedPort.GenericMiniSeedRecord");
            this.clean();
            try {
                Thread.sleep(240000L);
                return null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
        catch (IOException ioEx) {
            this.clean();
            logger.warn(ioEx.getMessage(), ioEx);
        }
        catch (Exception ex) {
            logger.warn(ex);
            logger.warn("trIdx: " + this.trIdx);
            logger.warn("blkSize: " + blkSize);
            this.clean();
            logger.warn(ex.getMessage(), ex);
        }
        if (gmsr == null) {
            return null;
        }
        if (gmsr.getSampleRate() == 0.0) return null;
        try {
            gmsr.decompress();
            return gmsr;
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            this.writeBadBlock();
            return null;
        }
    }

    private void writeBadBlock() {
        try {
            FileOutputStream fos = new FileOutputStream("buildMiniSeedRecordErr.bin", true);
            fos.write(this.dummy);
            fos.write(this.buf);
            fos.flush();
            fos.close();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }
}

