/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port;

import cn.org.gddsn.liss.port.AbstractMiniSeedPort;
import cn.org.gddsn.liss.port.MiniSeedStreamEncoder;
import cn.org.gddsn.liss.port.NetworkDataFrameInput;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;

public class MiniSeedPortFromDataFrame
extends AbstractMiniSeedPort {
    private MiniSeedStreamEncoder miniSeedStreamEncoder;
    private NetworkDataFrameInput client;
    private boolean connectOK = false;

    public void closePort() {
        super.closePort();
        try {
            this.client.close();
        }
        catch (Exception ex) {
            AbstractMiniSeedPort.logger.warn(ex.getMessage(), ex);
        }
        this.client = null;
    }

    public boolean connectServer() {
        AbstractMiniSeedPort.logger.info("Connecting " + this.client.getHost() + ":" + this.client.getPort() + " Server");
        try {
            this.client.connect();
            this.client.prepareProcess();
            this.miniSeedStreamEncoder = new MiniSeedStreamEncoder(this.client);
            this.connectOK = true;
        }
        catch (UnknownHostException uhEx) {
            AbstractMiniSeedPort.logger.warn("Unknown host " + this.client.getHost() + " : " + uhEx);
            this.connectOK = false;
            return false;
        }
        catch (InterruptedIOException iEx) {
            AbstractMiniSeedPort.logger.warn(String.valueOf(this.client.getHost()) + ":" + this.client.getPort() + " Timeout");
            this.connectOK = false;
            return false;
        }
        catch (IOException ioEx) {
            AbstractMiniSeedPort.logger.warn("Failed I/O to " + this.client.getHost() + ":" + this.client.getPort() + " : " + ioEx);
            this.connectOK = false;
            return false;
        }
        AbstractMiniSeedPort.logger.info("Connected " + this.client.getHost() + ":" + this.client.getPort());
        return true;
    }

    public boolean connectOK() {
        return this.connectOK;
    }

    public byte[] readMiniSeedFrame() throws IOException {
        if (!this.connectOK() && !this.connectServer()) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
        byte[] buf = null;
        try {
            buf = this.miniSeedStreamEncoder.readMiniSeedRecord();
        }
        catch (IOException ioEx) {
            try {
                this.client.close();
            }
            catch (Exception ex) {
                AbstractMiniSeedPort.logger.warn(ex.getMessage(), ex);
            }
            this.connectOK = false;
            throw ioEx;
        }
        return buf;
    }

    public void setMaxCompressSamples(int maxSamples) {
        this.miniSeedStreamEncoder.setMaxSamplesInMiniSeed(maxSamples);
    }

    public NetworkDataFrameInput getClient() {
        return this.client;
    }

    public void setClient(NetworkDataFrameInput client) {
        this.client = client;
    }
}

