/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port;

import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.MiniSeedStreamEncoder;
import cn.org.gddsn.liss.port.SerialConnectionException;
import cn.org.gddsn.liss.port.SerialParameters;
import cn.org.gddsn.liss.port.altus.AltusInputStream;
import cn.org.gddsn.liss.port.edas.DataFrameInputStream;
import cn.org.gddsn.liss.port.geotech.GeoTechInputStream;
import cn.org.gddsn.liss.port.guralp.GuralpInputStream;
import cn.org.gddsn.liss.port.mr2002.MR2002InputStream;
import cn.org.gddsn.liss.port.tde.TdeInputStream;
import cn.org.gddsn.liss.port.tyt.TytInputStream;
import cn.org.gddsn.util.Log4jConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;
import org.apache.log4j.Logger;

public class SerialConnection
implements CommPortOwnershipListener,
DataFrameInput {
    static Logger logger;
    public static final int DATA_TYPE_EDAS = 0;
    public static final int DATA_TYPE_ALTUS = 1;
    public static final int DATA_TYPE_DR24 = 2;
    public static final int DATA_TYPE_EDAS_REQ = 3;
    public static final int DATA_TYPE_TYT = 4;
    public static final int DATA_TYPE_TDE = 5;
    public static final int DATA_TYPE_GCF = 6;
    public static final int DATA_TYPE_MR2002 = 7;
    private SerialParameters parameters;
    private OutputStream os;
    private DataFrameInput dFrameIn;
    private MiniSeedStreamEncoder msis;
    private CommPortIdentifier portId;
    private SerialPort sPort;
    private boolean open;
    private int receiveThreshold = -1;
    private int receiveTimeout = 10;
    private int receiveFramingByte = 0;
    private int inputBufferSize = 1024;
    private int outputBufferSize = 0;
    private String[] chanDis;
    private int original_site_id = -1;
    private int data_type = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.SerialConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public SerialConnection(SerialParameters parameters, int stnOrder, int[] chanOrder) {
        this.parameters = parameters;
        this.open = false;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public SerialParameters getSerialParameters() {
        return this.parameters;
    }

    public int get_original_site_id() {
        return this.original_site_id;
    }

    public void setDataType(int data_type) {
        this.data_type = data_type;
    }

    public SerialConnection(SerialParameters parameters) {
        this.parameters = parameters;
        this.open = false;
    }

    public String[] getChannelDiscription() {
        return this.chanDis;
    }

    public void setChannelDiscription(String[] chanDis) {
        this.chanDis = chanDis;
    }

    public void setMaxCompressSamples(int maxSamples) {
        this.msis.setMaxSamplesInMiniSeed(maxSamples);
    }

    public void openConnection() throws SerialConnectionException {
        logger.info("Opening Serial port");
        try {
            this.portId = CommPortIdentifier.getPortIdentifier((String)this.parameters.getPortName());
        }
        catch (NoSuchPortException e) {
            logger.warn(e.getMessage());
            throw new SerialConnectionException(e.getMessage());
        }
        try {
            this.sPort = (SerialPort)this.portId.open("RTS", 30000);
        }
        catch (PortInUseException e) {
            logger.warn(e.getMessage());
            throw new SerialConnectionException(e.getMessage());
        }
        try {
            this.setConnectionParameters();
        }
        catch (SerialConnectionException e) {
            logger.warn(e.getMessage());
            this.sPort.close();
            throw e;
        }
        try {
            this.os = this.sPort.getOutputStream();
            if (this.data_type == 0) {
                this.dFrameIn = new DataFrameInputStream(this.sPort.getInputStream(), this.parameters.getPortName(), this.chanDis);
            } else if (this.data_type == 3) {
                DataFrameInputStream dFrameIn1 = new DataFrameInputStream(this.sPort.getInputStream(), this.parameters.getPortName(), this.chanDis);
                dFrameIn1.setRequest(this.sPort.getOutputStream());
                this.dFrameIn = dFrameIn1;
            } else if (this.data_type == 1) {
                this.dFrameIn = new AltusInputStream(this.sPort.getInputStream(), this.parameters.getPortName(), this.chanDis);
            } else if (this.data_type == 2) {
                this.dFrameIn = new GeoTechInputStream(this.sPort.getInputStream(), this.sPort.getOutputStream(), this.parameters.getPortName(), this.chanDis);
            } else if (this.data_type == 4) {
                this.dFrameIn = new TytInputStream(this.sPort.getInputStream(), this.parameters.getPortName(), this.chanDis);
            } else if (this.data_type == 5) {
                this.dFrameIn = new TdeInputStream(this.sPort.getInputStream(), this.parameters.getPortName(), this.chanDis);
            } else if (this.data_type == 6) {
                this.dFrameIn = new GuralpInputStream(this.sPort.getInputStream(), this.sPort.getOutputStream(), this.parameters.getPortName(), this.chanDis);
            } else if (this.data_type == 7) {
                this.dFrameIn = new MR2002InputStream(this.sPort.getInputStream(), this.sPort.getOutputStream(), this.parameters.getPortName(), this.chanDis);
            }
            this.msis = new MiniSeedStreamEncoder(this.dFrameIn);
        }
        catch (IOException e) {
            this.sPort.close();
            logger.warn(e.getMessage());
            throw new SerialConnectionException("Error opening I/O streams");
        }
        try {
            this.sPort.enableReceiveTimeout(this.receiveTimeout);
            this.sPort.setInputBufferSize(this.inputBufferSize);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            // empty catch block
        }
        this.portId.addPortOwnershipListener((CommPortOwnershipListener)this);
        this.open = true;
        logger.info("Opened Serial port");
    }

    public void setConnectionParameters() throws SerialConnectionException {
        int oldBaudRate = this.sPort.getBaudRate();
        int oldDatabits = this.sPort.getDataBits();
        int oldStopbits = this.sPort.getStopBits();
        int oldParity = this.sPort.getParity();
        int oldFlowControl = this.sPort.getFlowControlMode();
        try {
            this.sPort.setSerialPortParams(this.parameters.getBaudRate(), this.parameters.getDatabits(), this.parameters.getStopbits(), this.parameters.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            this.parameters.setBaudRate(oldBaudRate);
            this.parameters.setDatabits(oldDatabits);
            this.parameters.setStopbits(oldStopbits);
            this.parameters.setParity(oldParity);
            throw new SerialConnectionException("Unsupported parameter");
        }
        try {
            this.sPort.setFlowControlMode(this.parameters.getFlowControlIn() | this.parameters.getFlowControlOut());
        }
        catch (UnsupportedCommOperationException e) {
            throw new SerialConnectionException("Unsupported flow control");
        }
    }

    public void close() {
        if (!this.open) {
            return;
        }
        if (this.sPort != null) {
            this.sPort.removeEventListener();
            this.sPort.close();
            try {
                this.os.close();
                this.msis.close();
            }
            catch (IOException e) {
                logger.warn("In closeConnection: " + e);
            }
            this.portId.removePortOwnershipListener((CommPortOwnershipListener)this);
        }
        this.open = false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public DataFrame[] readDataFrame() throws IOException {
        DataFrame[] adFrame;
        block4: {
            adFrame = null;
            try {
                adFrame = this.dFrameIn.readDataFrame();
                if (adFrame != null) break block4;
                logger.warn("From " + this.sPort.getName() + " Get It NULL");
                return null;
            }
            catch (IOException ex) {
                logger.warn(ex.getMessage(), ex);
                return null;
            }
        }
        if (this.data_type == 3) {
            DataFrameInputStream dFrameIn1 = (DataFrameInputStream)this.dFrameIn;
            this.original_site_id = dFrameIn1.get_original_site_id();
        }
        logger.debug("From " + this.sPort.getName() + " Get It!");
        return adFrame;
    }

    public byte[] readMiniSeedFrame() {
        try {
            byte[] buf = this.msis.readMiniSeedRecord();
            return buf;
        }
        catch (IOException ex) {
            logger.warn("Read " + this.sPort.getName() + " Error");
            logger.warn(ex.getMessage(), ex);
            return null;
        }
    }

    public void ownershipChange(int type) {
        if (type == 3) {
            // empty if block
        }
    }

    public void addEventListener(SerialPortEventListener serialPortEventListener) throws SerialConnectionException {
        try {
            this.sPort.addEventListener(serialPortEventListener);
        }
        catch (TooManyListenersException e) {
            this.sPort.close();
            throw new SerialConnectionException("too many listeners added");
        }
        this.sPort.notifyOnDataAvailable(true);
    }

    public void removeEventListener() {
        this.sPort.removeEventListener();
    }

    public static void main0(String[] args) throws IOException {
        SerialParameters sp = new SerialParameters();
        SerialConnection sCon = new SerialConnection(sp);
        String[] cDis = new String[]{"IC/SHT/-1/BHZ:BHE:BHN", "IC/LCH/04/SHZ:SHE:SHN"};
        if (args.length < 1) {
            logger.error("Usage:\n java cn.gd.seismology.realtimestream comport speed");
            System.exit(-1);
        } else if (args.length == 1) {
            sp.setPortName(args[0]);
            sCon.setChannelDiscription(cDis);
        } else {
            sp.setPortName(args[0]);
            sp.setBaudRate(Integer.parseInt(args[1]));
            cDis = new String[args.length - 2];
            int i = 2;
            while (i < args.length) {
                cDis[i - 2] = args[i];
                ++i;
            }
            sCon.setChannelDiscription(cDis);
        }
        try {
            sCon.openConnection();
        }
        catch (SerialConnectionException i) {
            // empty catch block
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        logger.info("sleep done");
        DataFrame[] dfs = null;
        while (true) {
            if ((dfs = sCon.readDataFrame()) != null) {
                logger.debug(dfs[0]);
                continue;
            }
            logger.warn("Lost at least one second packet");
        }
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain("SerialConnection.properties");
        SerialParameters sp = new SerialParameters();
        sp.setBaudRate(19200);
        sp.setPortName("/dev/cuaU0");
        SerialConnection sCon = new SerialConnection(sp);
        String[] cDis = new String[]{"GD/LDB/00/BHZ:BHE:BHN"};
        sCon.setChannelDiscription(cDis);
        if (args.length < 1) {
            logger.error("Usage:\n java cn.gd.seismology.realtimestream comport speed data_type channel_discription");
            System.exit(-1);
        } else if (args.length == 1) {
            sp.setPortName(args[0]);
            sCon.setDataType(0);
            logger.info(String.valueOf(args[0]) + " data type is: EDAS");
            logger.info(String.valueOf(args[0]) + " com Port seed is: 9600");
        } else {
            sp.setPortName(args[0]);
            sp.setBaudRate(Integer.parseInt(args[1]));
            logger.info(String.valueOf(args[0]) + " com Port speed is: " + args[1]);
            if (args[2].equalsIgnoreCase("EDAS")) {
                sCon.setDataType(0);
                logger.info(String.valueOf(args[0]) + " data type is: EDAS");
            } else if (args[2].equalsIgnoreCase("EDAS_REQ")) {
                sCon.setDataType(3);
                logger.info(String.valueOf(args[0]) + " data type is: EDAS_REQ");
            } else if (args[2].equalsIgnoreCase("ALTUS")) {
                sCon.setDataType(1);
                logger.info(String.valueOf(args[0]) + " data type is: ALTUS");
            } else if (args[2].equalsIgnoreCase("DR24")) {
                sCon.setDataType(2);
                logger.info(String.valueOf(args[0]) + " data type is: DR24");
            } else if (args[2].equalsIgnoreCase("TYT")) {
                sCon.setDataType(4);
                logger.info(String.valueOf(args[0]) + " data type is: TYT");
            } else if (args[2].equalsIgnoreCase("TDE")) {
                sCon.setDataType(5);
                logger.info(String.valueOf(args[0]) + " data type is: TDE");
            } else if (args[2].equalsIgnoreCase("GCF")) {
                sCon.setDataType(6);
                logger.info(String.valueOf(args[0]) + " data type is: GCF");
            } else if (args[2].equalsIgnoreCase("MR2002")) {
                sCon.setDataType(7);
                logger.info(String.valueOf(args[0]) + " data type is: MR2002");
            }
            cDis = new String[args.length - 3];
            if (cDis.length != 0) {
                int i = 3;
                while (i < args.length) {
                    cDis[i - 3] = args[i];
                    ++i;
                }
                sCon.setChannelDiscription(cDis);
            }
        }
        try {
            sCon.openConnection();
        }
        catch (SerialConnectionException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        logger.info("sleep done");
        DataFrame[] dfs = null;
        while (true) {
            if ((dfs = sCon.readDataFrame()) != null) {
                logger.debug(dfs[0]);
                continue;
            }
            logger.warn("Lost at least one second packet");
        }
    }
}

