/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.edas;

import cn.org.gddsn.io.BitInputStream;
import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.liss.port.CmdResponseManager;
import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.LogLostManager;
import cn.org.gddsn.liss.port.SiteInfo;
import cn.org.gddsn.liss.port.TimeInDataFrame;
import cn.org.gddsn.liss.port.edas.FrameParseException;
import cn.org.gddsn.liss.port.edas.GenericDataFrame;
import cn.org.gddsn.liss.port.edas.GenericFrame;
import cn.org.gddsn.liss.port.edas.Rsp_2072_Frame;
import cn.org.gddsn.util.EdasSteim2;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.log4j.Logger;

public class DataFrameInputStream
implements DataFrameInput {
    static Logger logger;
    private static final short CMD_DATA_FLAG_24_STEIM2 = 21981;
    private static final short CMD_DATA_FLAG_24_COMPRESS = 21964;
    private static final short CMD_DATA_FLAG_24_3_SR_01 = 21947;
    private static final short CMD_DATA_FLAG_24_3_SR_50 = 21930;
    private static final short CMD_DATA_FLAG_16_3_SR_50 = 21845;
    private static final short CMD_DATA_FLAG_24_TDE = -32640;
    private static final String[] compCode;
    InputStream in;
    String comPort;
    private int samps;
    private int sampRate;
    private int chns;
    private static final int[] frameHead;
    private int headLen = frameHead.length;
    private int totalFrameLength;
    private int commonHeaderLength = 6;
    private int compressHeaderLength = 10;
    private int steim2HeaderLength = 14;
    private int localCheckSumLen = 12;
    private int[] head = new int[4];
    private short siteID;
    private short cmd;
    private short length;
    private int second;
    private byte flag;
    private byte localCheckSum;
    private byte[] chn1;
    private byte[] chn2;
    private byte[] chn3;
    private short checkSum;
    private byte[] buffer;
    private int threshHold;
    private SiteInfo siteInfo = null;
    private LogLostManager logLostManager = new LogLostManager();
    private int original_site_id = -1;
    private OutputStream req_os = null;
    private int chanDiscriptionNum = 1;
    private static final int[][] ebit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.edas.DataFrameInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        compCode = new String[]{"Z", "E", "N"};
        frameHead = new int[]{191, 19, 151, 116};
        ebit = new int[][]{{5, 7, 8, 9}, {6, 8, 9, 10}, {7, 9, 10, 11}, {8, 10, 11, 12}, {8, 10, 12, 13}, {9, 11, 13, 14}, {9, 11, 14, 15}, {10, 12, 15, 16}, {10, 12, 15, 17}, {11, 13, 16, 18}, {11, 14, 17, 19}, {12, 15, 18, 20}, {13, 16, 19, 21}, {14, 17, 20, 22}, {15, 18, 21, 23}, {16, 19, 21, 24}};
    }

    public DataFrameInputStream(InputStream in, String comPort, String[] chanDiscription) {
        this.in = in;
        this.comPort = comPort;
        this.samps = 50;
        this.sampRate = 50;
        this.chns = 3;
        this.totalFrameLength = 464;
        this.threshHold = (this.totalFrameLength + 4) * 2;
        this.buffer = new byte[4096];
        this.siteInfo = new SiteInfo(chanDiscription, compCode);
        this.chanDiscriptionNum = chanDiscription.length;
    }

    public int get_original_site_id() {
        return this.original_site_id;
    }

    public final DataFrame[] readDataFrame() throws IOException {
        DataFrame[] dfs = null;
        if (!this.hasEnoughData()) {
            return null;
        }
        if (!this.findFrameHead()) {
            return null;
        }
        if (!this.handleCommonHeader()) {
            return null;
        }
        if (this.cmd == 21981 && this.handleSteim2Data() && this.validCheckSum()) {
            dfs = this.decodeSteim2(this.buffer, this.steim2HeaderLength, this.totalFrameLength - this.steim2HeaderLength - 2);
        } else if (this.cmd == 21964 && this.handleCompressData() && this.validCheckSum()) {
            dfs = this.decompress(this.buffer, this.compressHeaderLength, this.length);
            if (this.siteID >= 50) {
                try {
                    CmdResponseManager.addCmdResponse(this.comPort, new GenericDataFrame(GenericFrame.buildGenericFrame(this.buffer, 0)));
                }
                catch (FrameParseException ex) {
                    logger.warn(ex.getMessage(), ex);
                }
            }
        } else if (this.cmd == 21947 || this.cmd == 21930 || this.cmd == -32640 || this.cmd == 21845) {
            if (this.readSmallHeader() && this.validLocalCheckSum() && this.readDataAndCheckSum() && this.validCheckSum()) {
                dfs = this.decodeUncompressData(this.buffer, this.localCheckSumLen, this.totalFrameLength - this.localCheckSumLen);
            }
        } else {
            this.handleCommandResponse();
        }
        if (this.logLostManager != null && dfs != null) {
            int i = 0;
            while (i < dfs.length) {
                LogLostManager.TimeInfo timeInfo = new LogLostManager.TimeInfo();
                timeInfo.date = dfs[i].time * 1000L + dfs[i].ns / 1000000L;
                timeInfo.length = dfs[i].data.length * 1000 / dfs[i].sampRate;
                this.logLostManager.log(dfs[i].getChannelLocator(), timeInfo);
                ++i;
            }
        }
        if (dfs != null && dfs[0].getChannelLocator().getStationCode().equals("")) {
            logger.warn(String.valueOf(this.comPort) + ": got unknown ChannelLocator, may be need to config chanDisc.");
        }
        return dfs;
    }

    public void setLogLostManager(LogLostManager logLostManager) {
        this.logLostManager = logLostManager;
    }

    private boolean findFrameHead() throws IOException {
        int ret;
        int i = 0;
        while (i < this.headLen) {
            this.head[i] = 0;
            ++i;
        }
        int firstIdx = 0;
        boolean found = false;
        while ((ret = this.in.read()) != -1) {
            this.head[firstIdx % this.headLen] = ret;
            int i2 = firstIdx;
            while (i2 < firstIdx + this.headLen) {
                if (this.head[(i2 + 1) % this.headLen] != frameHead[i2 - firstIdx]) {
                    found = false;
                    break;
                }
                found = true;
                ++i2;
            }
            if (found) break;
            ++firstIdx;
            firstIdx %= this.headLen;
        }
        if (!found) {
            logger.warn(String.valueOf(this.siteInfo.getChannelLocator(this.siteID, "Z").getStationCode()) + " has enough data to read, but I can't found Frame Header \"bf,13,97,74\".");
        }
        return found;
    }

    private boolean hasEnoughData() throws IOException {
        int delay = 3000;
        int count = 0;
        int ac = 0;
        while (delay != 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ac = this.in.available();
            if (ac >= this.threshHold) break;
            if (count++ > 998 && this.in.available() == 0) {
                throw new IOException("Should have data available");
            }
            --delay;
        }
        delay = 3000 - delay;
        return true;
    }

    public int getTotalChannels() {
        return this.siteInfo.getChannalSize();
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean handleCommonHeader() throws IOException {
        this.readFully(this.buffer, 0, this.commonHeaderLength);
        LittleEndianInputStream leIn = new LittleEndianInputStream(new ByteArrayInputStream(this.buffer, 0, this.commonHeaderLength));
        int site_id_tmp = this.original_site_id = (int)leIn.readShort();
        this.siteID = (short)(site_id_tmp % 2);
        if (logger.isDebugEnabled()) {
            logger.debug("SiteID: " + this.siteID);
        }
        this.cmd = leIn.readShort();
        if (logger.isDebugEnabled()) {
            logger.debug("cmd: " + Integer.toHexString(this.cmd));
        }
        this.length = leIn.readShort();
        if (this.length > 2048) {
            logger.warn(String.valueOf(this.siteInfo.getChannelLocator(this.siteID, "Z").getStationCode()) + " Frame Length > 0x800, ignore this frame data!");
            return false;
        }
        this.totalFrameLength = this.length + this.commonHeaderLength;
        leIn.close();
        return true;
    }

    private boolean readSmallHeader() throws IOException {
        this.readFully(this.buffer, this.commonHeaderLength, this.localCheckSumLen - this.commonHeaderLength);
        return true;
    }

    private boolean validLocalCheckSum() throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(this.buffer, 0, this.localCheckSumLen);
        int localSum = 0;
        try {
            int i = 0;
            while (i < this.localCheckSumLen) {
                localSum += bIn.read();
                ++i;
            }
            bIn.close();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        this.fillUncompressSmallHeader();
        if (this.req_os != null) {
            return true;
        }
        if ((localSum & 0xFF) == 0) {
            return true;
        }
        if (this.cmd == 21845) {
            logger.warn("Local checksum fail");
            return false;
        }
        return true;
    }

    private void fillUncompressSmallHeader() throws IOException {
        LittleEndianInputStream leIn = new LittleEndianInputStream(new ByteArrayInputStream(this.buffer, 0, this.localCheckSumLen));
        int site_id_tmp = this.original_site_id = (int)leIn.readShort();
        this.siteID = (short)(site_id_tmp % 2);
        this.cmd = leIn.readShort();
        this.length = leIn.readShort();
        this.second = leIn.readInt();
        this.flag = leIn.readByte();
        this.flag = (byte)(this.flag & 0xF);
        boolean bTrigger = (this.flag & 0x10) != 0;
        this.flag = (byte)(this.flag & 7);
        this.localCheckSum = leIn.readByte();
        leIn.close();
        switch (this.cmd) {
            case 21947: {
                this.samps = 10;
                this.sampRate = 1;
                this.chns = 3;
                this.siteID = 1;
                if (bTrigger) {
                    this.siteID = (short)(this.siteID + 50);
                }
                this.totalFrameLength = 2 + this.chns * this.samps * 3 + this.localCheckSumLen;
                break;
            }
            case 21930: {
                this.samps = 50;
                this.sampRate = 50;
                this.chns = 3;
                if (this.chanDiscriptionNum == 1) {
                    this.siteID = 0;
                }
                if (bTrigger) {
                    this.siteID = (short)(this.siteID + 50);
                }
                this.sampRate = this.samps = (this.length - 8) / this.chns / 3;
                this.totalFrameLength = 2 + this.chns * this.samps * 3 + this.localCheckSumLen;
                break;
            }
            case -32640: {
                this.sampRate = this.samps = (this.length - 8) / this.chns / 3;
                this.totalFrameLength = 2 + this.chns * this.samps * 3 + this.localCheckSumLen;
                this.siteID = 0;
                if (!bTrigger) break;
                this.siteID = (short)(this.siteID + 50);
                break;
            }
            case 21845: {
                this.chns = 3;
                this.sampRate = this.samps = (this.length - 8) / this.chns / 2;
                this.siteID = 0;
                if (bTrigger) {
                    this.siteID = (short)(this.siteID + 50);
                }
                this.totalFrameLength = 2 + this.chns * this.samps * 2 + this.localCheckSumLen;
            }
        }
    }

    private boolean readDataAndCheckSum() throws IOException {
        this.readFully(this.buffer, this.localCheckSumLen, this.totalFrameLength - this.localCheckSumLen);
        return true;
    }

    private boolean validCheckSum() throws IOException {
        LittleEndianInputStream leIn = new LittleEndianInputStream(new ByteArrayInputStream(this.buffer, 0, this.totalFrameLength));
        int size = leIn.available() / 2;
        int sum = 0;
        int i = 0;
        while (i < size) {
            sum += leIn.readUnsignedShort();
            ++i;
        }
        leIn.close();
        if ((sum & 0xFFFF) == 0) {
            return true;
        }
        logger.warn("Check sum FAIL");
        return false;
    }

    private DataFrame[] decodeUncompressData(byte[] buf, int aindex, int alength) throws IOException {
        LittleEndianInputStream leIn = new LittleEndianInputStream(new ByteArrayInputStream(buf, aindex, alength));
        DataFrame[] dFrame = new DataFrame[this.chns];
        int i = 0;
        while (i < this.chns) {
            dFrame[i] = new DataFrame();
            dFrame[i].data = new int[this.samps];
            dFrame[i].flag = this.flag;
            dFrame[i].siteID = this.siteID;
            dFrame[i].time = this.second;
            dFrame[i].sampRate = this.sampRate;
            dFrame[i].setChannelLocator(this.siteInfo.getChannelLocator(this.siteID, compCode[i]));
            int j = 0;
            while (j < this.samps) {
                switch (this.cmd) {
                    case -32640: 
                    case 21930: 
                    case 21947: {
                        dFrame[i].data[j] = leIn.readInt24();
                        break;
                    }
                    case 21845: {
                        dFrame[i].data[j] = leIn.readShort();
                    }
                }
                ++j;
            }
            ++i;
        }
        leIn.close();
        TimeInDataFrame.getTimeInDataFrame().setDate(new Date(dFrame[0].time * 1000L));
        return dFrame;
    }

    public void setRequest(OutputStream req_os) {
        this.req_os = req_os;
        new ReqThread().start();
    }

    public void requestNewDataFrame(byte[] buf) throws IOException {
        this.req_os.write(buf);
        this.req_os.flush();
    }

    public void requestNewDataFrame() throws IOException {
        if (this.original_site_id == -1) {
            this.requestNewDataFrame(GenericFrame.build_1072_Frame());
            try {
                Thread.sleep(980L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.info("Try to get site id...");
            return;
        }
        this.req_os.write(GenericFrame.build_1012_3C_Frame(this.original_site_id, 0));
        this.req_os.flush();
    }

    private boolean handleSteim2Data() throws IOException {
        this.readFully(this.buffer, this.commonHeaderLength, this.steim2HeaderLength - this.commonHeaderLength);
        LittleEndianInputStream leIn = new LittleEndianInputStream(new ByteArrayInputStream(this.buffer, this.commonHeaderLength, this.steim2HeaderLength - this.commonHeaderLength));
        leIn.readShort();
        this.second = leIn.readInt();
        int flag1 = leIn.read();
        switch (flag1 >>> 4) {
            case 0: {
                this.sampRate = 1;
                break;
            }
            case 1: {
                this.sampRate = 10;
                break;
            }
            case 2: {
                this.sampRate = 20;
                break;
            }
            case 3: {
                this.sampRate = 50;
                break;
            }
            case 4: {
                this.sampRate = 100;
                break;
            }
            case 5: {
                this.sampRate = 125;
                break;
            }
            case 6: {
                this.sampRate = 200;
                break;
            }
            case 7: {
                this.sampRate = 500;
            }
        }
        this.samps = this.sampRate;
        this.flag = (byte)(flag1 & 0xF);
        int flag2 = leIn.read();
        this.chns = flag2 & 0xF;
        int compressFlag = flag2 >>> 4;
        leIn.close();
        this.readFully(this.buffer, this.steim2HeaderLength, this.totalFrameLength - this.steim2HeaderLength);
        return true;
    }

    private DataFrame[] decodeSteim2(byte[] buf, int start, int len) throws IOException {
        int[] data = new int[this.chns * this.sampRate];
        EdasSteim2.decodeSteim2(buf, start, len, data);
        DataFrame[] dFrame = new DataFrame[this.chns];
        int i = 0;
        while (i < this.chns) {
            dFrame[i] = new DataFrame();
            dFrame[i].data = new int[this.samps];
            System.arraycopy(data, i * this.sampRate, dFrame[i].data, 0, this.sampRate);
            dFrame[i].flag = this.flag;
            dFrame[i].siteID = this.siteID;
            dFrame[i].time = this.second;
            dFrame[i].sampRate = this.sampRate;
            dFrame[i].setChannelLocator(this.siteInfo.getChannelLocator(this.siteID, compCode[i]));
            ++i;
        }
        TimeInDataFrame.getTimeInDataFrame().setDate(new Date(dFrame[0].time * 1000L));
        return dFrame;
    }

    private boolean handleCompressData() throws IOException {
        this.readFully(this.buffer, this.commonHeaderLength, this.compressHeaderLength - this.commonHeaderLength);
        LittleEndianInputStream leIn = new LittleEndianInputStream(new ByteArrayInputStream(this.buffer, this.commonHeaderLength, this.compressHeaderLength - this.commonHeaderLength));
        this.second = leIn.readInt();
        leIn.close();
        this.readFully(this.buffer, this.compressHeaderLength, this.totalFrameLength - this.compressHeaderLength);
        return true;
    }

    private DataFrame[] decompress(byte[] buf, int aindex, int alen) throws IOException {
        boolean bTrigger;
        BitInputStream bis = new BitInputStream(new ByteArrayInputStream(buf, aindex, alen));
        bis.readBits(4);
        boolean bl = bTrigger = bis.readBit() != 0;
        if (bTrigger) {
            this.siteID = (short)(this.siteID + 50);
        }
        boolean bLongSec = bis.readBit() != 0;
        this.flag = (byte)bis.readBits(2);
        this.samps = this.sampRate = bis.readInt12();
        this.chns = 3;
        int[] offset = new int[this.chns];
        offset[0] = 0;
        offset[1] = bis.readInt12();
        offset[2] = bis.readInt12();
        int totalBits = 36;
        DataFrame[] dFrame = new DataFrame[this.chns];
        int i = 0;
        while (i < this.chns) {
            dFrame[i] = new DataFrame();
            dFrame[i].data = new int[this.samps];
            dFrame[i].flag = this.flag;
            dFrame[i].siteID = this.siteID;
            dFrame[i].time = this.second;
            dFrame[i].sampRate = this.sampRate;
            dFrame[i].setChannelLocator(this.siteInfo.getChannelLocator(this.siteID, compCode[i]));
            int idx1 = bis.readBits(4);
            int[] idx2 = new int[this.sampRate / 10];
            int j = 0;
            while (j < idx2.length) {
                idx2[j] = bis.readBits(2);
                ++j;
            }
            dFrame[i].data[0] = bis.readSignedBits(24);
            totalBits += 4 + idx2.length * 2 + 24;
            int n = 1;
            int k = 0;
            while (k < 9) {
                dFrame[i].data[n] = dFrame[i].data[n - 1] + bis.readSignedBits(ebit[idx1][idx2[0]]);
                ++n;
                ++k;
            }
            totalBits += 9 * ebit[idx1][idx2[0]];
            int j2 = 1;
            while (j2 < idx2.length) {
                int k2 = 0;
                while (k2 < 10) {
                    dFrame[i].data[n] = dFrame[i].data[n - 1] + bis.readSignedBits(ebit[idx1][idx2[j2]]);
                    ++n;
                    ++k2;
                }
                totalBits += 10 * ebit[idx1][idx2[j2]];
                ++j2;
            }
            if (totalBits % 8 != 0) {
                bis.readBits(8 - totalBits % 8);
            }
            totalBits = 0;
            ++i;
        }
        TimeInDataFrame.getTimeInDataFrame().setDate(new Date(dFrame[0].time * 1000L));
        return dFrame;
    }

    private boolean handleCommandResponse() throws IOException {
        this.readFully(this.buffer, this.commonHeaderLength, this.totalFrameLength - this.commonHeaderLength);
        GenericFrame gFrame = GenericFrame.buildGenericFrame(this.buffer, 0);
        if (gFrame.getCmd() == 8306) {
            try {
                Rsp_2072_Frame dFrame = new Rsp_2072_Frame(gFrame);
                logger.info(dFrame);
                this.original_site_id = dFrame.getSiteID();
            }
            catch (FrameParseException ex) {
                logger.warn(ex.getMessage(), ex);
            }
        }
        CmdResponseManager.addCmdResponse(this.comPort, gFrame);
        return true;
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IOException("out of Index");
        }
        InputStream in = this.in;
        int n = 0;
        while (n < len) {
            int count = in.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }

    class ReqThread
    extends Thread {
        public void run() {
            try {
                DataFrameInputStream.this.requestNewDataFrame(GenericFrame.build_1072_Frame());
            }
            catch (IOException ioEx) {
                logger.warn(ioEx.getMessage(), ioEx);
            }
            try {
                DataFrameInputStream.this.requestNewDataFrame(GenericFrame.build_1072_Frame());
            }
            catch (IOException ioEx) {
                logger.warn(ioEx.getMessage(), ioEx);
            }
            try {
                while (true) {
                    try {
                        Thread.sleep(980L);
                    }
                    catch (InterruptedException ioEx) {
                        // empty catch block
                    }
                    DataFrameInputStream.this.requestNewDataFrame();
                }
            }
            catch (IOException ioEx) {
                logger.warn(ioEx.getMessage(), ioEx);
                return;
            }
        }
    }
}

