/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.edas;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.io.LittleEndianOutputStream;
import cn.org.gddsn.liss.port.DataFrame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import org.apache.log4j.Logger;

public class EDAS3DataFrame
extends DataFrame {
    static Logger logger;
    public static final int CMD_DATA_FLAG_24_COMPRESS = 21964;
    public static final int CMD_DATA_FLAG_24_3_SR_01 = 21947;
    public static final int CMD_DATA_FLAG_24_3_SR_50 = 21930;
    public static final int CMD_DATA_FLAG_16_3_SR_50 = 21845;
    public static final int[] frameHead;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.edas.EDAS3DataFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        frameHead = new int[]{191, 19, 151, 116};
    }

    public static byte[] buildRawEDAS3DataFrame(DataFrame[] dfs) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(512);
        LittleEndianOutputStream los = new LittleEndianOutputStream(bos);
        int i = 0;
        while (i < frameHead.length) {
            los.write(frameHead[i]);
            ++i;
        }
        los.writeShort(dfs[0].siteID);
        los.writeShort(21930);
        int length = 8;
        int i2 = 0;
        while (i2 < dfs.length) {
            length += dfs[i2].data.length * 3;
            ++i2;
        }
        los.writeShort(length);
        los.writeInt((int)dfs[0].time);
        los.write(dfs[0].flag);
        los.close();
        bos.close();
        byte[] header1 = bos.toByteArray();
        ByteArrayInputStream bIn = new ByteArrayInputStream(header1, frameHead.length, header1.length - frameHead.length);
        int clen = bIn.available();
        int localSum = 0;
        try {
            int i3 = 0;
            while (i3 < clen) {
                localSum += bIn.read();
                ++i3;
            }
            bIn.close();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        localSum = ~localSum + 1 & 0xFF;
        bos = new ByteArrayOutputStream(512);
        los = new LittleEndianOutputStream(bos);
        los.writeBytes(header1, header1.length);
        los.write(localSum);
        int i4 = 0;
        while (i4 < dfs.length) {
            int j = 0;
            while (j < dfs[i4].data.length) {
                los.writeInt24(dfs[i4].data[j]);
                ++j;
            }
            ++i4;
        }
        los.close();
        bos.close();
        byte[] b_data = bos.toByteArray();
        LittleEndianInputStream leIn = new LittleEndianInputStream(new ByteArrayInputStream(b_data, frameHead.length, b_data.length - frameHead.length));
        int size = leIn.available() / 2;
        int sum = 0;
        int i5 = 0;
        while (i5 < size) {
            sum += leIn.readUnsignedShort();
            ++i5;
        }
        leIn.close();
        sum = ~sum + 1 & 0xFFFF;
        byte[] b_df = new byte[frameHead.length + 6 + length];
        System.arraycopy(b_data, 0, b_df, 0, b_data.length);
        b_df[b_data.length] = (byte)(sum & 0xFF);
        b_df[b_data.length + 1] = (byte)(sum >> 8 & 0xFF);
        return b_df;
    }

    public static void main(String[] args) {
        DataFrame[] edfs = new EDAS3DataFrame[3];
        int i = 0;
        while (i < 3) {
            edfs[i] = new EDAS3DataFrame();
            edfs[i].siteID = 1;
            edfs[i].flag = 0;
            edfs[i].time = new Date().getTime() / 1000L;
            edfs[i].data = new int[50];
            int j = 0;
            while (j < 50) {
                edfs[i].data[j] = -25 + j;
                ++j;
            }
            ++i;
        }
        try {
            byte[] buf = EDAS3DataFrame.buildRawEDAS3DataFrame(edfs);
            LittleEndianInputStream leIn = new LittleEndianInputStream(new ByteArrayInputStream(buf, 4, buf.length - 4));
            int size = leIn.available() / 2;
            int sum = 0;
            int i2 = 0;
            while (i2 < size) {
                sum += leIn.readUnsignedShort();
                ++i2;
            }
            leIn.close();
            if ((sum & 0xFFFF) == 0) {
                System.err.println("check ok");
            }
            FileOutputStream fos = new FileOutputStream("/tmp/edas.tmp");
            fos.write(buf);
            fos.close();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }
}

