/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.edas;

import cn.org.gddsn.liss.port.edas.Edas24ControlResponse;
import cn.org.gddsn.liss.port.edas.Edas24ControlSocket;
import cn.org.gddsn.liss.port.edas.Edas24Exception;
import cn.org.gddsn.liss.port.edas.Edas24IPIO;
import cn.org.gddsn.util.Log4jConfig;
import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.Logger;

public class Edas24Client {
    static Logger logger;
    private Edas24ControlSocket control = null;
    int dataPort = 8001;
    private Socket data = null;
    private Edas24IPIO edas24IPIO;
    private int timeOut = 120000;
    private int sendBufferSize = -1;
    private String remoteHost;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.edas.Edas24Client");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public Edas24Client(String remoteHost, int port) throws IOException, Edas24Exception {
        this.control = new Edas24ControlSocket(remoteHost, port);
        logger.info("Connected " + remoteHost + ":" + port);
        this.remoteHost = remoteHost;
    }

    public Edas24Client(String remoteHost) throws IOException, Edas24Exception {
        this.control = new Edas24ControlSocket(remoteHost);
        this.remoteHost = remoteHost;
    }

    Edas24ControlSocket getEdas24ControlSocket() {
        return this.control;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public void setTimeOut(int ms) {
        this.timeOut = ms;
        this.control.setTimeOut(this.timeOut);
        try {
            if (this.data != null) {
                this.data.setSoTimeout(this.timeOut);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getSocketConnectionInfo() {
        return this.control.getSocketConnectionInfo();
    }

    private void skipLine(Edas24ControlResponse reply) throws IOException, Edas24Exception {
        reply = this.control.readReply();
        this.control.validateReply(reply, "109");
    }

    public synchronized Edas24IPIO login(String user, String password) throws IOException, Edas24Exception {
        Edas24ControlResponse reply = this.control.sendCommand(user);
        this.control.validateReply(reply, "102");
        reply = this.control.sendCommand(password);
        this.control.validateReply(reply, "107");
        reply = this.control.readReply();
        this.control.validateReply(reply, "108");
        this.dataPort = Integer.parseInt(reply.getMessage().substring(4, 8));
        this.data = new Socket(this.remoteHost, this.dataPort);
        if (this.sendBufferSize != -1) {
            this.data.setSendBufferSize(this.sendBufferSize);
        }
        this.data.setSoTimeout(this.timeOut);
        this.edas24IPIO = new Edas24IPIO();
        this.edas24IPIO.setIO(this.data.getInputStream(), this.data.getOutputStream());
        reply = this.control.readReply();
        this.control.validateReply(reply, "104");
        this.skipLine(reply);
        logger.info("User " + user + " loggin on " + this.remoteHost);
        return this.edas24IPIO;
    }

    public synchronized void logout() throws IOException, Edas24Exception {
        Edas24ControlResponse reply = this.control.sendCommand("BYE");
        this.control.validateReply(reply, "300");
        logger.info("logout " + this.remoteHost);
    }

    public synchronized Edas24IPIO rtsOn() throws IOException, Edas24Exception {
        Edas24ControlResponse reply = this.control.sendCommand("RTS ON");
        String[] validCodes1 = new String[]{"110"};
        this.control.validateReply(reply, validCodes1);
        while ((reply = this.control.readReply()).getReturnCode().equals("110")) {
        }
        this.control.validateReply(reply, "109");
        logger.info("Open Real Time Stream.");
        return this.edas24IPIO;
    }

    public synchronized String rtsOff() throws IOException, Edas24Exception {
        Edas24ControlResponse reply = this.control.sendCommand("RTS OFF");
        this.control.validateReply(reply, "112");
        String ret = reply.getMessage();
        this.skipLine(reply);
        logger.info("Close Real Time Stream.");
        return ret;
    }

    public synchronized String rts() throws IOException, Edas24Exception {
        Edas24ControlResponse reply = this.control.sendCommand("RTS");
        this.control.validateReply(reply, "115");
        String ret = reply.getMessage();
        this.skipLine(reply);
        return ret;
    }

    public synchronized void requestData(int no, int second, int length) throws IOException, Edas24IPIO.Edas24IPIOException {
        Edas24IPIO.Frame request = Edas24IPIO.buildDataRequestFrame(no, second, length);
        this.edas24IPIO.writeFrame(request);
    }

    public synchronized Edas24IPIO.Frame getRtsFrame() throws IOException, Edas24IPIO.Edas24IPIOException {
        Edas24IPIO.Frame frame = this.edas24IPIO.readFrame();
        if (logger.isDebugEnabled()) {
            logger.debug("calc checksum: " + Integer.toHexString(frame.calculateCheckSum()));
        }
        if (frame.header.type.get() == 21981) {
            Edas24IPIO.EDAS_STEIM2 data = (Edas24IPIO.EDAS_STEIM2)frame.body;
            if (frame.calculateCheckSum() != frame.tailer.checksum.get()) {
                logger.warn("checksum error for got STEIM2 packet");
            }
            Edas24IPIO.Frame ack = Edas24IPIO.buildAckFrame(frame.header.no.get(), data.second.get());
            if (logger.isDebugEnabled()) {
                logger.debug("ACK Frame: " + (Object)((Object)ack));
            }
            this.edas24IPIO.writeFrame(ack);
        } else if (frame.header.type.get() == 21930) {
            Edas24IPIO.EDAS_55AA data = (Edas24IPIO.EDAS_55AA)frame.body;
            if (frame.calculateCheckSum() != frame.tailer.checksum.get()) {
                logger.warn("checksum error for got EDAS_55AA packet");
            }
            Edas24IPIO.Frame ack = Edas24IPIO.buildAckFrame(frame.header.no.get(), data.second.get());
            if (logger.isDebugEnabled()) {
                logger.debug("ACK Frame: " + (Object)((Object)ack));
            }
            this.edas24IPIO.writeFrame(ack);
        }
        return frame;
    }

    public String getDetailHeader() {
        return this.control.getDetailHeader();
    }

    public String getLocalHostAddress() {
        return this.control.getLocalHostAddress();
    }

    String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    void checkResponse(String[] validCodes) throws IOException, Edas24Exception {
        Edas24ControlResponse reply = this.control.readReply();
        this.control.validateReply(reply, validCodes);
    }

    protected void closeTransferSocket() throws IOException {
        if (this.data != null) {
            this.data.close();
            this.data = null;
        }
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain("Edas24Client.properties");
        Edas24Client edas24client = new Edas24Client("192.9.210.103", 5000);
        edas24client.setSendBufferSize(128);
        edas24client.setTimeOut(5000);
        edas24client.login("root", "arca100");
        edas24client.rtsOn();
        Edas24IPIO.Frame frm = edas24client.getEdas24IPIO().inquire(0, 0);
        Edas24IPIO.STATION_INFO sta = (Edas24IPIO.STATION_INFO)frm.body;
        System.out.println(sta.toString());
        frm = edas24client.getEdas24IPIO().inquire(0, 33);
        Edas24IPIO.SINE_PARAM info = (Edas24IPIO.SINE_PARAM)frm.body;
        info.pointNum.set((short)13);
        info.freqs[0].periods.set((short)5);
        frm = edas24client.getEdas24IPIO().config(0, 33, info);
        System.out.println(info.freqs[0].periods.get());
        int n = 1000;
        while (n-- != 0) {
            edas24client.getRtsFrame();
        }
        edas24client.logout();
    }

    public Edas24IPIO getEdas24IPIO() {
        return this.edas24IPIO;
    }
}

