/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.edas;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.util.StructUtil;
import cn.org.gddsn.security.Bytes;
import cn.org.gddsn.util.EdasSteim2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javolution.io.Struct;
import org.apache.log4j.Logger;

public class Edas24IPIO {
    static Logger logger;
    private DataInputStream in;
    private DataOutputStream out;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.edas.Edas24IPIO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public void setIO(InputStream in, OutputStream out) {
        this.in = new DataInputStream(in);
        this.out = new DataOutputStream(out);
    }

    public void writeFrame(Frame frame) throws Edas24IPIOException, IOException {
        this.out.write(frame.toByteArray());
        this.out.flush();
        if (logger.isDebugEnabled()) {
            logger.debug("Send Frame: " + (Object)((Object)frame));
        }
    }

    public Frame readFrame() throws Edas24IPIOException, IOException {
        Frame frame = new Frame();
        frame.header.readFully(this.in);
        int type = frame.header.type.get();
        if (type == 20480) {
            frame.body = new ERROR_BROADCAST();
            frame.body.readFully(this.in);
            frame.tailer.readFully(this.in);
            logger.warn("Got Error Broadcast Frame: " + (Object)((Object)frame));
            return frame;
        }
        switch (type & 0xFFF) {
            case 0: {
                frame.body = new STATION_INFO();
                frame.body.readFully(this.in);
                break;
            }
            case 5: {
                frame.body = new SAMPLE_RATE();
                frame.body.readFully(this.in);
                break;
            }
            case 3: {
                frame.body = new HI_FILTER();
                frame.body.readFully(this.in);
                break;
            }
            case 7: {
                frame.body = new INPUT_CONTROL();
                frame.body.readFully(this.in);
                break;
            }
            case 50: {
                frame.body = new BAUD_RATE();
                frame.body.readFully(this.in);
                break;
            }
            case 32: {
                frame.body = new PULSE_PARAM();
                frame.body.readFully(this.in);
                break;
            }
            case 33: {
                SINE_PARAM param = new SINE_PARAM();
                param.readFully(this.in);
                param.freqs = new SINE_FREQ[param.pointNum.get()];
                int i = 0;
                while (i < param.freqs.length) {
                    param.freqs[i] = new SINE_FREQ();
                    param.freqs[i].readFully(this.in);
                    ++i;
                }
                frame.body = param;
                break;
            }
            case 34: {
                frame.body = new RANDOM_PARAM();
                frame.body.readFully(this.in);
                break;
            }
            case 35: {
                frame.body = new STRONG_PARAM();
                frame.body.readFully(this.in);
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                frame.body = new START_CALI();
                frame.body.readFully(this.in);
                break;
            }
            case 134: {
                DAS das = new DAS();
                das.readFully(this.in);
                das.info = new DAS_INFO[das.sum.get()];
                int i = 0;
                while (i < das.info.length) {
                    das.info[i] = new DAS_INFO();
                    das.info[i].readFully(this.in);
                    ++i;
                }
                frame.body = das;
                break;
            }
            case 135: {
                SENSOR sensor = new SENSOR();
                sensor.readFully(this.in);
                sensor.info = new SENSOR_INFO[sensor.sum.get()];
                int i = 0;
                while (i < sensor.info.length) {
                    sensor.info[i] = new SENSOR_INFO();
                    sensor.info[i].readFully(this.in);
                    ++i;
                }
                frame.body = sensor;
                break;
            }
            case 136: {
                frame.body = new Body();
                frame.body.readFully(this.in);
                break;
            }
            case 145: {
                frame.body = new TRIGGER_CLOCK();
                frame.body.readFully(this.in);
                break;
            }
            case 146: {
                frame.body = new TRIGGER_EXTERNAL();
                frame.body.readFully(this.in);
                break;
            }
            case 148: {
                int trigNum = (frame.header.length.get() - 4) / 36;
                TRIGGER_AUTO auto = new TRIGGER_AUTO();
                auto.trig = new TRIGGER_INFO[trigNum];
                int j = 0;
                while (j < trigNum) {
                    auto.trig[j] = new TRIGGER_INFO();
                    auto.trig[j].readFully(this.in);
                    ++j;
                }
                break;
            }
            case 129: {
                frame.body = new GPS_INFO();
                frame.body.readFully(this.in);
                break;
            }
            case 130: {
                frame.body = new VOLTAGE();
                frame.body.readFully(this.in);
                break;
            }
            case 131: {
                frame.body = new TEMPERATURE();
                frame.body.readFully(this.in);
                break;
            }
            case 132: {
                frame.body = new CLOCK_ERR();
                frame.body.readFully(this.in);
                break;
            }
            case 198: {
                frame.body = new CLEAR_BUFFER();
                frame.body.readFully(this.in);
                break;
            }
            case 177: {
                frame.body = new Body();
                frame.body.readFully(this.in);
                break;
            }
            case 193: {
                frame.body = new HEART_BEAT_FREQ();
                frame.body.readFully(this.in);
                break;
            }
            case 178: {
                frame.body = new EVENT_INFO();
                frame.body.readFully(this.in);
                break;
            }
            case 179: {
                frame.body = new Body();
                frame.body.readFully(this.in);
                break;
            }
            case 240: {
                frame.body = new EVENT_TRIGGER_START();
                frame.body.readFully(this.in);
                break;
            }
            case 241: {
                frame.body = new EVENT_TRIGGER_END();
                frame.body.readFully(this.in);
                break;
            }
            case 242: {
                frame.body = new ACCEL_INFO();
                frame.body.readFully(this.in);
                break;
            }
            case 200: {
                frame.body = new Body();
                frame.body.readFully(this.in);
                break;
            }
            case 3829: {
                frame.body = new RESET_FACTORY();
                frame.body.readFully(this.in);
                break;
            }
            case 208: {
                frame.body = new IP();
                frame.body.readFully(this.in);
                break;
            }
            case 3826: {
                frame.body = new FLUSH_BUFFER();
                frame.body.readFully(this.in);
                break;
            }
            case 3827: {
                frame.body = new STOP();
                frame.body.readFully(this.in);
                break;
            }
            case 3828: {
                frame.body = new RESET();
                frame.body.readFully(this.in);
                break;
            }
            case 1450: {
                EDAS_55AA edas = new EDAS_55AA();
                edas.sec_16lo = frame.header.REV.get();
                edas.alloc(frame.header.length.get());
                frame.body = edas;
                frame.body.readFully(this.in);
                this.in.readFully(edas.zdata);
                break;
            }
            case 1484: {
                frame.body = new Body();
                frame.body.readFully(this.in);
                break;
            }
            case 1501: {
                EDAS_STEIM2 edas_steim2 = new EDAS_STEIM2();
                edas_steim2.alloc(frame.header.length.get());
                frame.body = edas_steim2;
                frame.body.readFully(this.in);
                this.in.readFully(edas_steim2.zdata);
                break;
            }
            case 4095: {
                logger.warn("Got FAILT Frame type: " + (Object)((Object)frame.header));
                frame.body = new Body();
                int chksum = frame.header.REV.get();
                frame.tailer.checksum.set(chksum);
                frame.header.REV.set(0);
                return frame;
            }
            default: {
                logger.warn("Got unknow Frame type: " + (Object)((Object)frame.header));
                if (frame.header.sync.get() == 1956058047) {
                    frame.unknown = new byte[frame.header.length.get() - 4];
                    this.in.readFully(frame.unknown);
                    break;
                }
                throw new Edas24IPIOException("Got unknow Frame type: " + (Object)((Object)frame.header));
            }
        }
        frame.tailer.readFully(this.in);
        if (logger.isDebugEnabled()) {
            logger.debug("Got Frame: " + (Object)((Object)frame));
        }
        return frame;
    }

    public Frame calibrate(int no, int type) throws Edas24IPIOException, IOException {
        this.writeFrame(Edas24IPIO.buildGenericRequestFrame(no, 4096 + type));
        Frame retFrm = null;
        do {
            if ((retFrm = this.readFrame()) != null) continue;
            return null;
        } while ((retFrm.header.type.get() & 0xFFF) != type);
        return retFrm;
    }

    public Frame inquire(int no, int type) throws Edas24IPIOException, IOException {
        this.writeFrame(Edas24IPIO.buildGenericRequestFrame(no, 16384 + type));
        Frame retFrm = null;
        do {
            if ((retFrm = this.readFrame()) != null) continue;
            return null;
        } while ((retFrm.header.type.get() & 0xFFF) != type);
        return retFrm;
    }

    public Frame config(int no, int type, Body info) throws Edas24IPIOException, IOException {
        Frame frm = new Frame();
        frm.header.no.set(no);
        frm.header.length.set(info.toByteArray().length + 4);
        frm.header.type.set(4096 + type);
        frm.body = info;
        frm.fillCheckSum();
        this.writeFrame(frm);
        Frame retFrm = null;
        do {
            if ((retFrm = this.readFrame()) != null) continue;
            return null;
        } while ((retFrm.header.type.get() & 0xFFF) != type);
        return retFrm;
    }

    public static Frame buildAckFrame(int no, long second) {
        Frame ack = new Frame();
        ack.header.no.set(no);
        ack.header.length.set(8);
        ack.header.type.set(30583);
        ACK ack_body = new ACK();
        ack_body.second.set(second);
        ack.body = ack_body;
        ack.fillCheckSum();
        return ack;
    }

    public static Frame buildGenericRequestFrame(int no, int type) {
        Frame frm = new Frame();
        frm.header.no.set(no);
        frm.header.length.set(4);
        frm.header.type.set(type);
        frm.fillCheckSum();
        return frm;
    }

    public static Frame buildDataRequestFrame(int no, int second, int length) {
        Frame frm = new Frame();
        frm.header.no.set(no);
        frm.header.length.set(10);
        frm.header.type.set(4112);
        DATA_REQUEST req_body = new DATA_REQUEST();
        req_body.second.set((long)second);
        req_body.length.set(length);
        frm.body = req_body;
        frm.fillCheckSum();
        return frm;
    }

    public static class ACCEL_INFO
    extends Body {
        public final Struct.Utf8String sta = new Struct.Utf8String((Struct)this, 8);
        public final Struct.Float64 trigTime = new Struct.Float64((Struct)this);
        public final Struct.Float32 accel = new Struct.Float32((Struct)this);
        public final Struct.Float32 pga_ud = new Struct.Float32((Struct)this);
        public final Struct.Float32 pga_ew = new Struct.Float32((Struct)this);
        public final Struct.Float32 pge_ns = new Struct.Float32((Struct)this);
        public final Struct.Float32 pu_1 = new Struct.Float32((Struct)this);
        public final Struct.Float32 pu_2 = new Struct.Float32((Struct)this);
        public final Struct.Float32 pu_5 = new Struct.Float32((Struct)this);
        public final Struct.Float32 pu_8 = new Struct.Float32((Struct)this);
        public final Struct.Float32 period = new Struct.Float32((Struct)this);
        public final Struct.Float32 duration = new Struct.Float32((Struct)this);
        public final Struct.Float64 pga_ud_time = new Struct.Float64((Struct)this);
        public final Struct.Float64 pga_ew_time = new Struct.Float64((Struct)this);
        public final Struct.Float64 pga_ns_time = new Struct.Float64((Struct)this);
    }

    public static class ACK
    extends Body {
        public final Struct.Unsigned32 second = new Struct.Unsigned32((Struct)this);

        public String toString() {
            return "second=" + Long.toHexString(this.second.get());
        }
    }

    public static class BAUD_RATE
    extends Body {
        public final Struct.Signed16 portFlag = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 controlWord = new Struct.Signed16((Struct)this);
        public final Struct.Signed32 baud = new Struct.Signed32((Struct)this);
        public final Struct.Utf8String port = new Struct.Utf8String((Struct)this, 16);
    }

    public static class BEAT_INFO
    extends Body {
        public final Struct.Signed16 exvol = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 invol = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 batvol = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 tem = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeerr = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 freqerr = new Struct.Signed16((Struct)this);
    }

    public static class BOXTEM_INFO
    extends Body {
        public final Struct.Signed16 tem = new Struct.Signed16((Struct)this);
    }

    public static class Body
    extends Struct {
        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public boolean isPacked() {
            return true;
        }

        public byte[] toByteArray() throws IOException {
            ByteBuffer bb = this.getByteBuffer();
            byte[] buf = new byte[this.size()];
            int i = 0;
            while (i < buf.length) {
                buf[i] = bb.get(i);
                ++i;
            }
            return buf;
        }

        public String toString() {
            return StructUtil.struct2String(this);
        }
    }

    public static class CLEAR_BUFFER
    extends Body {
        public final Struct.Signed16 rev = new Struct.Signed16((Struct)this);
    }

    public static class CLOCK_ERR
    extends Body {
        public final Struct.Signed16 timeErr = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 freqErr = new Struct.Signed16((Struct)this);
    }

    public static class DAS
    extends Body {
        public final Struct.Signed32 sum = new Struct.Signed32((Struct)this);
        public DAS_INFO[] info = null;

        public byte[] toByteArray() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(super.toByteArray(), 0, this.size());
            int i = 0;
            while (i < this.sum.get()) {
                this.info[i].write(baos);
                ++i;
            }
            return baos.toByteArray();
        }
    }

    public static class DAS_INFO
    extends Body {
        public final Struct.Utf8String port = new Struct.Utf8String((Struct)this, 16);
        public final Struct.Signed32 baudrate = new Struct.Signed32((Struct)this);
        public final Struct.Utf8String version = new Struct.Utf8String((Struct)this, 16);
        public final Struct.Utf8String company = new Struct.Utf8String((Struct)this, 32);
        public final Struct.Utf8String sn = new Struct.Utf8String((Struct)this, 16);
        public final Struct.Signed16 seisum = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 rev = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 firsei = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 secsei = new Struct.Signed16((Struct)this);
    }

    public static class DATA_REQUEST
    extends Body {
        public final Struct.Unsigned32 second = new Struct.Unsigned32((Struct)this);
        public final Struct.Unsigned16 length = new Struct.Unsigned16((Struct)this);

        public String toString() {
            return "second=" + Long.toHexString(this.second.get()) + "length=" + Long.toHexString(this.length.get());
        }
    }

    public static class EDAS_55AA
    extends Body {
        public final Struct.Unsigned16 second = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned8 flag1 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 flag2 = new Struct.Unsigned8((Struct)this);
        public static final int OFFSET = 8;
        public int sec_16lo;
        public byte[] zdata;
        public int sampRate;
        public int samps;
        public int flag;
        public int chns = 3;
        public int compressFlag;

        public void alloc(int length) {
            this.zdata = new byte[length - 8];
        }

        public byte[] toByteArray() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(super.toByteArray(), 0, this.size());
            baos.write(this.zdata);
            return baos.toByteArray();
        }

        public DataFrame[] decode() {
            boolean bTrigger;
            this.flag = (byte)(this.flag1.get() & 0xF);
            int siteID = 0;
            boolean bl = bTrigger = (this.flag & 0x10) != 0;
            if (bTrigger) {
                siteID += 50;
            }
            this.sampRate = this.samps = this.zdata.length / this.chns / 3;
            DataFrame[] dFrame = new DataFrame[this.chns];
            try {
                LittleEndianInputStream leIn = new LittleEndianInputStream(new ByteArrayInputStream(this.zdata));
                int i = 0;
                while (i < this.chns) {
                    dFrame[i] = new DataFrame();
                    dFrame[i].data = new int[this.samps];
                    dFrame[i].flag = this.flag & 0xF;
                    dFrame[i].siteID = 0;
                    dFrame[i].time = (this.second.get() << 16) + this.sec_16lo;
                    dFrame[i].sampRate = this.sampRate;
                    int j = 0;
                    while (j < this.samps) {
                        dFrame[i].data[j] = leIn.readInt24();
                        ++j;
                    }
                    ++i;
                }
                leIn.close();
            }
            catch (IOException ioEx) {
                logger.warn(ioEx.getMessage(), ioEx);
                return null;
            }
            return dFrame;
        }

        public String toString() {
            return "second=" + Long.toHexString((this.second.get() << 16) + this.sec_16lo) + "/flag1=" + Integer.toHexString(this.flag1.get()) + "/flag2=" + Integer.toHexString(this.flag2.get());
        }
    }

    public static class EDAS_STEIM2
    extends Body {
        public final Struct.Unsigned32 second = new Struct.Unsigned32((Struct)this);
        public final Struct.Unsigned8 flag1 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 flag2 = new Struct.Unsigned8((Struct)this);
        public static final int OFFSET = 10;
        public byte[] zdata;
        public int sampRate;
        public int samps;
        public int flag;
        public int chns;
        public int compressFlag;

        public void alloc(int length) {
            this.zdata = new byte[length - 10];
        }

        public byte[] toByteArray() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(super.toByteArray(), 0, this.size());
            baos.write(this.zdata);
            return baos.toByteArray();
        }

        public DataFrame[] decode() {
            switch (this.flag1.get() >>> 4) {
                case 0: {
                    this.sampRate = 1;
                    break;
                }
                case 1: {
                    this.sampRate = 10;
                    break;
                }
                case 2: {
                    this.sampRate = 20;
                    break;
                }
                case 3: {
                    this.sampRate = 50;
                    break;
                }
                case 4: {
                    this.sampRate = 100;
                    break;
                }
                case 5: {
                    this.sampRate = 125;
                    break;
                }
                case 6: {
                    this.sampRate = 200;
                    break;
                }
                case 7: {
                    this.sampRate = 500;
                }
            }
            this.samps = this.sampRate;
            this.flag = (byte)(this.flag1.get() & 0xF);
            this.chns = this.flag2.get() & 0xF;
            this.compressFlag = this.flag2.get() >>> 4;
            int[] data = new int[this.chns * this.sampRate];
            EdasSteim2.decodeSteim2(this.zdata, 0, this.zdata.length, data);
            DataFrame[] dFrame = new DataFrame[this.chns];
            int i = 0;
            while (i < this.chns) {
                dFrame[i] = new DataFrame();
                dFrame[i].data = new int[this.samps];
                System.arraycopy(data, i * this.sampRate, dFrame[i].data, 0, this.sampRate);
                dFrame[i].flag = this.flag;
                dFrame[i].siteID = 0;
                dFrame[i].time = this.second.get();
                dFrame[i].sampRate = this.sampRate;
                ++i;
            }
            return dFrame;
        }

        public String toString() {
            return "second=" + Long.toHexString(this.second.get()) + "/flag1=" + Integer.toHexString(this.flag1.get()) + "/flag2=" + Integer.toHexString(this.flag2.get());
        }
    }

    public static class ERROR_BROADCAST
    extends Body {
        public final Struct.Signed16 errorType = new Struct.Signed16((Struct)this);
    }

    public static class EVENT_INFO
    extends Body {
    }

    public static class EVENT_TRIGGER_END
    extends Body {
        public final Struct.Signed32 startTime = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 endTime = new Struct.Signed32((Struct)this);
        public final Struct.Signed16 trigFlag = new Struct.Signed16((Struct)this);
    }

    public static class EVENT_TRIGGER_START
    extends Body {
        public final Struct.Signed32 startTime = new Struct.Signed32((Struct)this);
        public final Struct.Signed16 trigFlag = new Struct.Signed16((Struct)this);
    }

    public static class Edas24IPIOException
    extends Exception {
        public Edas24IPIOException() {
        }

        public Edas24IPIOException(String s) {
            super(s);
        }
    }

    public static class FLUSH_BUFFER
    extends Body {
        public final Struct.Signed16 rev = new Struct.Signed16((Struct)this);
    }

    public static class Frame
    extends Struct {
        public final Header header = (Header)this.inner(new Header());
        public Body body = null;
        public byte[] unknown = new byte[0];
        public final Tailer tailer = (Tailer)this.inner(new Tailer());

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public Frame() {
            this.header.sync.set(1956058047);
        }

        public boolean isPacked() {
            return true;
        }

        public byte[] toByteArray() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.header.write(baos);
            if (this.body != null) {
                baos.write(this.body.toByteArray());
            } else {
                baos.write(this.unknown);
            }
            this.tailer.write(baos);
            return baos.toByteArray();
        }

        public String toString() {
            String buf = "\n\tHeader: " + (Object)((Object)this.header) + "\n";
            if (this.body != null) {
                try {
                    buf = String.valueOf(buf) + "\tBody: " + Bytes.toString(this.body.toByteArray()) + "\n";
                }
                catch (IOException iOException) {}
            } else {
                buf = String.valueOf(buf) + "\tBody: " + Bytes.toString(this.unknown) + "\n";
            }
            buf = String.valueOf(buf) + "\tTailer: " + (Object)((Object)this.tailer);
            return buf;
        }

        int calculateCheckSum() {
            int checksum = 0;
            ByteBuffer sbuf = this.header.getByteBuffer();
            ((Buffer)sbuf).position(4);
            int p = 4;
            while (p < this.header.size()) {
                checksum += sbuf.getShort(p) & 0xFFFF;
                p += 2;
            }
            if (this.body != null) {
                byte[] buf = null;
                try {
                    buf = this.body.toByteArray();
                    sbuf = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                int p2 = 0;
                while (p2 < buf.length) {
                    checksum += sbuf.getShort(p2) & 0xFFFF;
                    p2 += 2;
                }
            } else {
                sbuf = ByteBuffer.wrap(this.unknown).order(ByteOrder.LITTLE_ENDIAN);
                p = 0;
                while (p < this.unknown.length) {
                    checksum += sbuf.getShort(p) & 0xFFFF;
                    p += 2;
                }
            }
            return 0 - checksum & 0xFFFF;
        }

        public void fillCheckSum() {
            this.tailer.checksum.set(this.calculateCheckSum());
        }
    }

    public static class GPS_INFO
    extends Body {
        public final Struct.Signed8 sync = new Struct.Signed8((Struct)this);
        public final Struct.Signed8 month = new Struct.Signed8((Struct)this);
        public final Struct.Signed8 day = new Struct.Signed8((Struct)this);
        public final Struct.Signed8 hour = new Struct.Signed8((Struct)this);
        public final Struct.Signed8 minute = new Struct.Signed8((Struct)this);
        public final Struct.Signed8 second = new Struct.Signed8((Struct)this);
        public final Struct.Signed16 year = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 dop = new Struct.Signed16((Struct)this);
        public final Struct.Signed8 rcvStatus = new Struct.Signed8((Struct)this);
        public final Struct.Signed8 star = new Struct.Signed8((Struct)this);
        public final Struct.Signed32 lat = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 lon = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 alt = new Struct.Signed32((Struct)this);
        public STAR_DETAIL[] star_detail = (STAR_DETAIL[])this.array(new STAR_DETAIL[6]);
        public final Struct.Signed32 nextCorrectTime = new Struct.Signed32((Struct)this);
    }

    public static class GPS_STATE
    extends Body {
        public final Struct.Signed16 gpsState = new Struct.Signed16((Struct)this);
    }

    public static class HEART_BEAT_FREQ
    extends Body {
        public final Struct.Signed16 period = new Struct.Signed16((Struct)this);
    }

    public static class HI_FILTER
    extends Body {
        public final Struct.Signed16 lowcut = new Struct.Signed16((Struct)this);
    }

    public static class Header
    extends Struct {
        public static final int SYNC = 1956058047;
        public static final int TYPE_BASE_SET = 4096;
        public static final int TYPE_BASE_GET = 8192;
        public static final int TYPE_BASE_REQUEST = 16384;
        public static final int STATION_INFO = 0;
        public static final int HI_FILTER = 3;
        public static final int SAMPLE_RATE = 5;
        public static final int INPUT_CONTROL = 7;
        public static final int PULSE_PARAM = 32;
        public static final int SINE_PARAM = 33;
        public static final int RANDOM_PARAM = 34;
        public static final int STRONG_PARAM = 35;
        public static final int START_PULSE = 36;
        public static final int START_SINE = 37;
        public static final int START_RANDOM = 38;
        public static final int START_STRONG = 39;
        public static final int STOP_CALI = 40;
        public static final int BAUD_RATE = 50;
        public static final int GPS_INFO = 129;
        public static final int VOLTAGE = 130;
        public static final int TEMPERATURE = 131;
        public static final int CLOCK_ERR = 132;
        public static final int REQUEST_INFO = 128;
        public static final int DAS_INFO = 134;
        public static final int SENSOR_INFO = 135;
        public static final int TRANS_FUNCTION = 136;
        public static final int TRIGGER_CLOCK = 145;
        public static final int TRIGGER_EXTERNAL = 146;
        public static final int START_EXTERNAL = 150;
        public static final int TRIGGER_AUTO = 148;
        public static final int CLEAR_BUFFER = 198;
        public static final int DATA_SERIVCE = 177;
        public static final int EVENT_INFO = 178;
        public static final int EVENT_WAVEFORM = 179;
        public static final int HEART_BEAT_FREQ = 193;
        public static final int EVENT_TRIGGER_START = 240;
        public static final int EVENT_TRIGGER_END = 241;
        public static final int ACCEL_INFO = 242;
        public static final int ACTIVE_SERVICE = 200;
        public static final int IP = 208;
        public static final int FLUSH_BUFFER = 3826;
        public static final int STOP = 3827;
        public static final int RESET = 3828;
        public static final int RESET_FACTORY = 3829;
        public static final int FAILT = 4095;
        public static final int ERROR_BROADCAST = 20480;
        public static final int EDAS_55AA = 21930;
        public static final int DATA_ZIP = 21964;
        public static final int EDAS_STEIM2 = 21981;
        public static final int ACK = 30583;
        public static final int DATA_REQUEST = 4112;
        public final Struct.Signed32 sync = new Struct.Signed32((Struct)this);
        public final Struct.Unsigned16 no = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 type = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 length = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 REV = new Struct.Unsigned16((Struct)this);

        public Header() {
            this.sync.set(1956058047);
        }

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public boolean isPacked() {
            return true;
        }

        public static int typeGet(int type) {
            return type + 8192;
        }

        public static int typeSet(int type) {
            return type + 4096;
        }

        public static int typeRequest(int type) {
            return type + 16384;
        }

        public String toString() {
            return "SYNC=" + Integer.toHexString(this.sync.get()) + "/no=" + Integer.toHexString(this.no.get()) + "/type=" + Integer.toHexString(this.type.get()) + "/length=" + Integer.toHexString(this.length.get());
        }
    }

    public static class INPUT_CONTROL
    extends Body {
        public final Struct.Signed16 range = new Struct.Signed16((Struct)this);
    }

    public static class IP
    extends Body {
        public final Struct.Utf8String ip = new Struct.Utf8String((Struct)this, 44);
        public final Struct.Utf8String mask = new Struct.Utf8String((Struct)this, 44);
        public final Struct.Utf8String gw = new Struct.Utf8String((Struct)this, 44);
    }

    public static class PULSE_PARAM
    extends Body {
        public final Struct.Signed16 timeSwitch = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 calMode = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeOne = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeTwo = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeThree = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeFour = new Struct.Signed16((Struct)this);
        public final Struct.Signed32 calTime = new Struct.Signed32((Struct)this);
        public final Struct.Signed16 amplitude = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 width = new Struct.Signed16((Struct)this);
    }

    public static class RANDOM_PARAM
    extends Body {
        public final Struct.Signed16 timeSwitch = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 calMode = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeOne = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeTwo = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeThree = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeFour = new Struct.Signed16((Struct)this);
        public final Struct.Signed32 calTime = new Struct.Signed32((Struct)this);
        public final Struct.Signed16 amplitude = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 width = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 signalFlag = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 iteration = new Struct.Signed16((Struct)this);
    }

    public static class RESET
    extends Body {
        public final Struct.Signed16 rev = new Struct.Signed16((Struct)this);
    }

    public static class RESET_FACTORY
    extends Body {
        public final Struct.Signed16 rev = new Struct.Signed16((Struct)this);
    }

    public static class SAMPLE_RATE
    extends Body {
        public final Struct.Signed8 phase = new Struct.Signed8((Struct)this);
        public final Struct.Signed8 samrate = new Struct.Signed8((Struct)this);
    }

    public static class SENSOR
    extends Body {
        public final Struct.Signed32 sum = new Struct.Signed32((Struct)this);
        public SENSOR_INFO[] info = null;

        public byte[] toByteArray() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(super.toByteArray(), 0, this.size());
            int i = 0;
            while (i < this.sum.get()) {
                this.info[i].write(baos);
                ++i;
            }
            return baos.toByteArray();
        }
    }

    public static class SENSOR_INFO
    extends Body {
        public final Struct.Utf8String version = new Struct.Utf8String((Struct)this, 16);
        public final Struct.Utf8String company = new Struct.Utf8String((Struct)this, 32);
        public final Struct.Utf8String sequence = new Struct.Utf8String((Struct)this, 16);
        public final Struct.Utf8String type = new Struct.Utf8String((Struct)this, 4);
        public final Struct.Utf8String standType = new Struct.Utf8String((Struct)this, 4);
        public final Struct.Utf8String bandwidth = new Struct.Utf8String((Struct)this, 16);
        public final Struct.Signed32 deep = new Struct.Signed32((Struct)this);
        public final Struct.Utf8String base = new Struct.Utf8String((Struct)this, 32);
        public final Struct.Utf8String state = new Struct.Utf8String((Struct)this, 4);
        public final Struct.Utf8String file = new Struct.Utf8String((Struct)this, 32);
    }

    public static class SET_BEAT
    extends Body {
        public final Struct.Signed16 interval = new Struct.Signed16((Struct)this);
    }

    public static class SINE_FREQ
    extends Body {
        public final Struct.Signed16 periods = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 freq = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 factor = new Struct.Signed16((Struct)this);
    }

    public static class SINE_PARAM
    extends Body {
        public final Struct.Signed16 timeSwitch = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 calMode = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeOne = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeTwo = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeThree = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeFour = new Struct.Signed16((Struct)this);
        public final Struct.Signed32 calTime = new Struct.Signed32((Struct)this);
        public final Struct.Signed16 pointNum = new Struct.Signed16((Struct)this);
        public SINE_FREQ[] freqs = null;

        public byte[] toByteArray() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(super.toByteArray(), 0, this.size());
            int i = 0;
            while (i < this.pointNum.get()) {
                this.freqs[i].write(baos);
                ++i;
            }
            return baos.toByteArray();
        }
    }

    public static class START_CALI
    extends Body {
        public final Struct.Signed32 starttime = new Struct.Signed32((Struct)this);
    }

    public static class STAR_DETAIL
    extends Body {
        public final Struct.Signed8 i = new Struct.Signed8((Struct)this);
        public final Struct.Signed8 h = new Struct.Signed8((Struct)this);
        public final Struct.Signed8 s = new Struct.Signed8((Struct)this);
        public final Struct.Signed8 d = new Struct.Signed8((Struct)this);
    }

    public static class STATION_INFO
    extends Body {
        public final Struct.Signed16 stanum = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 REV = new Struct.Signed16((Struct)this);
        public final Struct.Utf8String name = new Struct.Utf8String((Struct)this, 32);
        public final Struct.Utf8String abb = new Struct.Utf8String((Struct)this, 8);
        public final Struct.Signed16 seinum = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 chnum = new Struct.Signed16((Struct)this);
        public final Struct.Signed32 lat = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 lon = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 alt = new Struct.Signed32((Struct)this);
        public final Struct.Utf8String useDate = new Struct.Utf8String((Struct)this, 32);
        public final Struct.Utf8String netmark = new Struct.Utf8String((Struct)this, 4);
        public final Struct.Utf8String version = new Struct.Utf8String((Struct)this, 32);
    }

    public static class STOP
    extends Body {
        public final Struct.Signed16 rev = new Struct.Signed16((Struct)this);
    }

    public static class STOP_CALI
    extends Body {
    }

    public static class STRONG_PARAM
    extends Body {
        public final Struct.Signed16 timswitch = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 calMode = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeOne = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeTwo = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeThree = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeFour = new Struct.Signed16((Struct)this);
        public final Struct.Signed32 caltime = new Struct.Signed32((Struct)this);
    }

    public static class TEMPERATURE
    extends Body {
        public final Struct.Signed16 temp = new Struct.Signed16((Struct)this);
    }

    public static class TRIGGER_AUTO
    extends Body {
        public TRIGGER_INFO[] trig = null;

        public byte[] toByteArray() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(super.toByteArray(), 0, this.size());
            Frame frm = new Frame();
            int i = 0;
            while (i < (frm.header.length.get() - 4) / 36) {
                this.trig[i].write(baos);
                ++i;
            }
            return baos.toByteArray();
        }
    }

    public static class TRIGGER_CLOCK
    extends Body {
        public final Struct.Signed16 repeat = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 timeInterval = new Struct.Signed16((Struct)this);
        public final Struct.Signed32 triggerTime = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 eventLen = new Struct.Signed32((Struct)this);
    }

    public static class TRIGGER_EXTERNAL
    extends Body {
        public final Struct.Signed16 allow = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 eventLen = new Struct.Signed16((Struct)this);
    }

    public static class TRIGGER_INFO
    extends Body {
        public final Struct.Signed16 trigflag = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 trigsequence = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 trigstyle = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 filter = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 lonwinvalue = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 showinvalue = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 valwinvalue = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 endwinvalue = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 STAtrigvalue = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 STAvalivalue = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 STAendvalue = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 VOLtrigvalue = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 VOLendvalue = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 UDWeight = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 EWWeight = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 NSWeight = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 allWeight = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 maxlen = new Struct.Signed16((Struct)this);
    }

    public static class Tailer
    extends Struct {
        public final Struct.Unsigned16 checksum = new Struct.Unsigned16((Struct)this);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public boolean isPacked() {
            return true;
        }

        public String toString() {
            return "checksum=" + Integer.toHexString(this.checksum.get());
        }
    }

    public static class VOLTAGE
    extends Body {
        public final Struct.Signed16 extVol = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 intVol = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 battVol = new Struct.Signed16((Struct)this);
    }

    public static class ZERO_INFO
    extends Body {
        public final Struct.Signed16 ch1 = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 ch2 = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 ch3 = new Struct.Signed16((Struct)this);
    }
}

