/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.edas;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.liss.port.edas.FrameParseException;
import cn.org.gddsn.liss.port.edas.GenericFrame;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class Rsp_2015_Frame
extends GenericFrame {
    int total_kb;
    int free_kb;
    int num;
    int[] tm_sec;
    int[] len_sec;
    int[] len_kb;

    public Rsp_2015_Frame(GenericFrame gframe) throws FrameParseException {
        super(gframe);
        this.parse();
    }

    private void parse() throws FrameParseException {
        LittleEndianInputStream di = null;
        if (this.cmd != 8213) {
            throw new FrameParseException("parse Error in Rsp_2015_Frame");
        }
        try {
            di = new LittleEndianInputStream(new ByteArrayInputStream(this.getData()));
            this.total_kb = di.readShort();
            this.free_kb = di.readShort();
            this.num = di.readShort();
            this.tm_sec = new int[this.num];
            this.len_sec = new int[this.num];
            this.len_kb = new int[this.num];
            int i = 0;
            while (i < this.num) {
                this.tm_sec[i] = di.readInt();
                this.len_sec[i] = di.readShort();
                this.len_kb[i] = di.readShort();
                ++i;
            }
        }
        catch (IOException ioEx) {
            throw new FrameParseException("parse Error in Rsp_2015_Frame, throw IOException");
        }
    }

    public int getTotal_kb() {
        return this.total_kb;
    }

    public int getFree_kb() {
        return this.free_kb;
    }

    public int getNum() {
        return this.num;
    }

    public int[] getTm_sec() {
        return this.tm_sec;
    }

    public int[] getLen_sec() {
        return this.len_sec;
    }

    public int[] getLen_kb() {
        return this.len_kb;
    }

    public int getTm_sec(int idx) {
        return this.tm_sec[idx];
    }

    public int getLen_sec(int idx) {
        return this.len_sec[idx];
    }

    public int getLen_kb(int idx) {
        return this.len_kb[idx];
    }
}

