/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.edsp;

import cn.org.gddsn.liss.port.CmdResponseManager;
import cn.org.gddsn.liss.port.ComServPortInf;
import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.LogLostManager;
import cn.org.gddsn.liss.port.MiniSeedStreamEncoder;
import cn.org.gddsn.liss.port.edsp.EdspClient;
import cn.org.gddsn.liss.port.edsp.EdspException;
import cn.org.gddsn.liss.port.edsp.EdspIO;
import cn.org.gddsn.liss.port.edsp.SiteInfo;
import cn.org.gddsn.util.Log4jConfig;
import cn.org.gddsn.util.QueueAddElementEvent;
import cn.org.gddsn.util.QueueAddElementEventListener;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.IOException;
import java.util.Date;
import org.apache.log4j.Logger;

public class EdspServPort
implements ComServPortInf,
DataFrameInput,
QueueAddElementEventListener {
    static Logger logger;
    String host;
    int port;
    String user;
    String passwd;
    EdspClient client = null;
    private static final String[] compCode;
    private SiteInfo siteInfo = null;
    private String[] chanDis;
    private int data_type = 10;
    private MiniSeedStreamEncoder msis;
    private LogLostManager logLostManager = new LogLostManager();
    private boolean retransmit = false;
    private long lastSecond = -1L;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.edsp.EdspServPort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        compCode = new String[]{"Z", "E", "N"};
    }

    public EdspServPort(String edasServName, int edasServPort, String user, String passwd) {
        this.host = edasServName;
        this.port = edasServPort;
        this.user = user;
        this.passwd = passwd;
        CmdResponseManager.addQueueAddElementEventListener(this);
    }

    public void QueueAddElementHandler(QueueAddElementEvent e) {
        CmdResponseManager.Node node = (CmdResponseManager.Node)e.getValue();
    }

    public boolean prepareProcess() throws IOException {
        return true;
    }

    public boolean connect() throws IOException {
        boolean bvalue = false;
        logger.info("Opening EdspServPort.");
        try {
            if (this.client != null) {
                this.client.logout();
            }
        }
        catch (EdspException ex) {
            logger.error("Edas24Exception: " + ex.getMessage());
        }
        catch (IOException ioEx) {
            logger.error("IOException: " + ioEx.getMessage());
        }
        try {
            this.client = null;
            this.msis = null;
            this.client = new EdspClient(this.host, this.port);
            this.client.login(this.user, this.passwd);
            this.client.requestData("*.*.*");
        }
        catch (EdspException ex) {
            logger.error("Exception: " + ex.getMessage());
            throw new IOException(ex.getMessage());
        }
        this.msis = new MiniSeedStreamEncoder(this);
        logger.info("Opened EdspServPort.");
        bvalue = true;
        return bvalue;
    }

    public void openComServPort() throws IOException {
        block10: {
            logger.info("Opening EdspServPort.");
            try {
                if (this.client != null) {
                    this.client.logout();
                }
            }
            catch (EdspException ex) {
                logger.error("Edas24Exception: " + ex.getMessage());
            }
            catch (IOException ioEx) {
                logger.error("IOException: " + ioEx.getMessage());
            }
            try {
                this.client = null;
                this.msis = null;
                this.client = new EdspClient(this.host, this.port);
                this.client.login(this.user, this.passwd);
                this.client.requestData("*.*.*");
                if (!this.retransmit || this.lastSecond == -1L) break block10;
                logger.info("Try to retransmit data from: " + Long.toHexString(this.lastSecond) + ", " + new Date(this.lastSecond * 1000L));
                EdspIO.Frame frame = null;
                DataFrame[] dfs = null;
                try {
                    do {
                        frame = this.client.getRtsFrame();
                    } while (frame.header.type.get() != 21966);
                    if (frame.header.type.get() == 21966) {
                        EdspIO.EDAS_STEIM2 steim2 = (EdspIO.EDAS_STEIM2)frame.body;
                        dfs = steim2.decode();
                    }
                }
                catch (EdspIO.Edas24IPIOException ex) {
                    logger.warn(ex.getMessage(), ex);
                }
            }
            catch (EdspException ex) {
                logger.error("Exception: " + ex.getMessage());
                throw new IOException(ex.getMessage());
            }
        }
        this.msis = new MiniSeedStreamEncoder(this);
        logger.info("Opened EdspServPort.");
    }

    public void closeComServPort() throws IOException {
        try {
            if (this.client != null) {
                this.client.logout();
            }
        }
        catch (EdspException ex) {
            logger.error("Edas24Exception: " + ex.getMessage());
        }
        catch (IOException ioEx) {
            logger.error("IOException: " + ioEx.getMessage());
        }
    }

    public byte[] readMiniSeedFrame() throws IOException {
        byte[] buf = this.msis.readMiniSeedRecord();
        return buf;
    }

    public void setDataType(int data_type) {
        this.data_type = data_type;
    }

    public void setChannelDiscription(String[] chanDis) {
        this.chanDis = chanDis;
        this.siteInfo = new SiteInfo(chanDis, compCode);
    }

    public void setMaxCompressSamples(int maxSamples) {
        this.msis.setMaxSamplesInMiniSeed(maxSamples);
    }

    public void setSteimLevel(int level) {
        this.msis.setSteimInfo((short)level, (short)7);
    }

    public void close() {
        try {
            this.closeComServPort();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataFrame[] readDataFrame() throws IOException {
        DataFrame[] dfs = null;
        try {
            EdspIO.Frame frame = null;
            do {
                frame = this.client.getRtsFrame();
            } while (frame.header.type.get() != 21966);
            if (frame.header.type.get() == 21966) {
                EdspIO.EDAS_STEIM2 steim2 = (EdspIO.EDAS_STEIM2)frame.body;
                dfs = steim2.decode();
            }
            this.lastSecond = dfs[0].time;
            int i = 0;
            while (true) {
                if (i >= dfs.length) {
                    if (dfs != null) break;
                    logger.warn("From " + this.host + ":" + this.port + " Get It NULL");
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    // empty if block
                }
                dfs[i].siteID = frame.header.sensId.get();
                dfs[i].setChannelLocator(this.siteInfo.getChannelLocator(frame.header.nodeId.get(), frame.header.siteId.get(), frame.header.sensId.get(), compCode[i]));
                if (dfs[i].getChannelLocator().getStationCode().equals("")) {
                    String key = String.valueOf(frame.header.nodeId.get()) + "." + frame.header.siteId.get() + "." + frame.header.sensId.get();
                    logger.warn(String.valueOf(this.host) + ":" + this.port + " got unknown ChannelLocator: " + key + ", ingore this packet.");
                    return null;
                }
                ++i;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("From " + this.host + ":" + this.port + " Get It: " + dfs.length + " : " + dfs[0]);
            }
        }
        catch (EdspIO.Edas24IPIOException ex) {
            logger.error("Exception: " + ex.getMessage());
            logger.warn(ex.getMessage(), ex);
            throw new IOException(ex.getMessage());
        }
        if (this.logLostManager != null && dfs != null) {
            int i = 0;
            while (i < dfs.length) {
                LogLostManager.TimeInfo timeInfo = new LogLostManager.TimeInfo();
                timeInfo.date = dfs[i].time * 1000L + dfs[i].ns / 1000000L;
                timeInfo.length = dfs[i].data.length * 1000 / dfs[i].sampRate;
                this.logLostManager.log(dfs[i].getChannelLocator(), timeInfo);
                ++i;
            }
        }
        return dfs;
    }

    public void setLogLostManager(LogLostManager logLostManager) {
        this.logLostManager = logLostManager;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getDataTpe() {
        return this.data_type;
    }

    public String[] getChannelDiscription() {
        return this.chanDis;
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain("EdspServPort.properties");
        EdspServPort csPort = null;
        String[] cDis = new String[]{"GD/TST/00/BHZ:BHE:BHN"};
        if (args.length < 5) {
            logger.debug("Usage:\n java cn.org.gddsn.liss.port.EdspServPort edspServ port user password data_type");
            System.exit(-1);
        } else {
            csPort = new EdspServPort(args[0], Integer.parseInt(args[1]), args[2], args[3]);
            if (args[4].equalsIgnoreCase("EDAS_EDSP")) {
                csPort.setDataType(10);
                logger.info(String.valueOf(args[0]) + " data type is: EDAS_EDSP");
            }
            cDis = new String[args.length - 5];
            int i = 5;
            while (i < args.length) {
                cDis[i - 5] = args[i];
                ++i;
            }
            csPort.setChannelDiscription(cDis);
        }
        try {
            csPort.openComServPort();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        byte[] buf = null;
        while (true) {
            if ((buf = csPort.readMiniSeedFrame()) != null) {
                GenericMiniSeedRecord gmsr = GenericMiniSeedRecord.buildMiniSeedRecord(buf);
                logger.info(gmsr);
                continue;
            }
            logger.error("Could not read one miniseed packet");
        }
    }

    public String getPasswd() {
        return this.passwd;
    }

    public String getUser() {
        return this.user;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isRetransmit() {
        return this.retransmit;
    }

    public void setRetransmit(boolean retransmit) {
        this.retransmit = retransmit;
    }
}

