/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.geotech;

import cn.org.gddsn.liss.port.geotech.GeoTechPacket;
import cn.org.gddsn.liss.port.geotech.MessagePacket;
import java.util.Date;
import org.apache.log4j.Logger;

public class DataFramePacket
extends MessagePacket {
    static Logger logger;
    private static final int[] SRI;
    private static final int[] RATE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.geotech.DataFramePacket");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        SRI = new int[]{20, 21, 22, 23, 24, 25, 30, 31, 32, 33, 34, 35, 40};
        RATE = new int[]{10, 20, 40, 50, 60, 80, 100, 120, 125, 200, 250, 500, 1000};
    }

    public DataFramePacket(byte[] frame) {
        super(frame);
    }

    public DataFramePacket(GeoTechPacket gPacket) {
        super(gPacket);
    }

    public boolean isGpsPowerOn() {
        return (this.frame[3] & 0x40) == 64;
    }

    public boolean isGpsEnable() {
        return (this.frame[3] & 0x20) == 32;
    }

    public boolean isGpsTimeLock() {
        return (this.frame[3] & 0x10) == 16;
    }

    public int getChan() {
        return this.frame[3] & 0xF;
    }

    private int getSampleRate() {
        int sri = this.frame[4] & 0xFF;
        int idx = -1;
        int i = 0;
        while (i < SRI.length) {
            if (SRI[i] == sri) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx != -1) {
            return RATE[idx];
        }
        logger.warn("could not found valid sample rate, sri: " + sri);
        return -1;
    }

    public Date getDataTimeTag() {
        long sec = ((this.frame[8] & 0xFF) << 24) + ((this.frame[7] & 0xFF) << 16) + ((this.frame[6] & 0xFF) << 8) + (this.frame[5] & 0xFF);
        return new Date(sec * 1000L);
    }

    public SOH getSOH() {
        return new SOH(this.frame[9], this.frame[10]);
    }

    public int[] getSamples() {
        int sampRate = this.getSampleRate();
        if (sampRate == -1) {
            return null;
        }
        int[] samps = new int[sampRate];
        int type = this.getType();
        if (type >= 8 && type <= 13) {
            int idx = 12;
            int i = 0;
            while (i < samps.length) {
                samps[i] = ((this.frame[idx + 2] & 0xFF) << 16) + ((this.frame[idx + 1] & 0xFF) << 8) + (this.frame[idx] & 0xFF);
                if ((samps[i] & 0x800000) == 0x800000) {
                    samps[i] = -((~samps[i] & 0xFFFFFF) + 1);
                }
                idx += 3;
                ++i;
            }
        }
        return samps;
    }

    public static class SOH {
        public static final int TYPE_SPARE_SOH_INPUT = 0;
        public static final int TYPE_INTERNAL_TEMPERATURE = 1;
        public static final int TYPE_VPP_FLASH_SUPPLY = 2;
        public static final int TYPE_N_15V_SUPPLY = 3;
        public static final int TYPE_P_15V_SUPPLY = 4;
        public static final int TYPE_N_5V_SUPPLY = 5;
        public static final int TYPE_P_5V_SUPPLY = 6;
        public static final int TYPE_DC_INPUT_VOLTAGE = 7;
        public static final int TYPE_DIGITAL_INPUT = 8;
        public static final int TYPE_EXPANSION_TEMPERATURE = 9;
        public int type;
        public double value;

        public SOH(byte lo, byte hi) {
            this.type = (hi & 0xFF) >> 4;
            int v = ((hi & 0xFF) << 4) + (lo & 0xFF);
            switch (this.type) {
                case 0: {
                    this.value = -4.884 * (double)v + 10.0;
                    break;
                }
                case 1: {
                    this.value = 0.030525 * (double)v + -50.0;
                    break;
                }
                case 2: {
                    this.value = 6.166 * (double)v;
                    break;
                }
                case 3: {
                    this.value = -6.105 * (double)v;
                    break;
                }
                case 4: {
                    this.value = 6.166 * (double)v;
                    break;
                }
                case 5: {
                    this.value = -1.832 * (double)v;
                    break;
                }
                case 6: {
                    this.value = 1.832 * (double)v;
                    break;
                }
                case 7: {
                    this.value = 6.166 * (double)v;
                    break;
                }
                case 8: {
                    this.value = v;
                    break;
                }
                case 9: {
                    v = ((hi & 0xFF) << 4) + (lo & 0xFF);
                    if ((v & 0x800) == 2048) {
                        v = -((~v & 0xFFF) + 1);
                    }
                    this.value = (double)v / 2.0;
                    break;
                }
                default: {
                    this.value = 0.0;
                }
            }
        }
    }
}

