/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.geotech;

import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.LogLostManager;
import cn.org.gddsn.liss.port.SiteInfo;
import cn.org.gddsn.liss.port.geotech.DataFramePacket;
import cn.org.gddsn.liss.port.geotech.GeoTechPacket;
import cn.org.gddsn.liss.port.geotech.MessagePacket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class GeoTechInputStream
implements DataFrameInput {
    private static final String[] compCode = new String[]{"Z", "N", "E"};
    private static final int[] frameHead = new int[]{227};
    private int headLen = frameHead.length;
    private int[] head = new int[this.headLen];
    private int siteID;
    InputStream in;
    OutputStream out;
    String comPort;
    private byte[] buffer;
    private SiteInfo siteInfo = null;
    private LogLostManager logLostManager = new LogLostManager();

    public GeoTechInputStream(InputStream in, OutputStream out, String comPort, String[] chanDiscription) {
        this.in = in;
        this.out = out;
        this.comPort = comPort;
        this.buffer = new byte[4096];
        this.siteInfo = new SiteInfo(chanDiscription, compCode);
    }

    public int getTotalChannels() {
        return this.siteInfo.getChannalSize();
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setLogLostManager(LogLostManager logLostManager) {
        this.logLostManager = logLostManager;
    }

    public final DataFrame[] readDataFrame() throws IOException {
        if (!this.hasEnoughData()) {
            System.err.println(new Date() + ":\t" + this.siteInfo.getChannelLocator(this.siteID, "Z").getStationCode() + " could not read enough data!");
            return null;
        }
        if (!this.findFrameHead()) {
            System.err.println(new Date() + ":\t" + this.siteInfo.getChannelLocator(this.siteID, "Z").getStationCode() + " could not find Frame Head!");
            return null;
        }
        int n = this.readOnePacket();
        if (n == -1) {
            System.err.println(new Date() + ":\t" + this.siteInfo.getChannelLocator(this.siteID, "Z").getStationCode() + " read One Packet return -1");
            return null;
        }
        GeoTechPacket gpacket = new GeoTechPacket(this.buffer, 0, n);
        if (gpacket.isControlPacket()) {
            System.err.println(new Date() + ":\t" + this.siteInfo.getChannelLocator(this.siteID, "Z").getStationCode() + " the data is ControlPacket");
            return null;
        }
        MessagePacket msgPacket = new MessagePacket(gpacket);
        if (!msgPacket.isDataFramePacket()) {
            System.err.println(new Date() + ":\t" + this.siteInfo.getChannelLocator(this.siteID, "Z").getStationCode() + " the data is not DataFramePacket");
            return null;
        }
        if (!msgPacket.isValid()) {
            System.err.println(new Date() + ":\t" + this.siteInfo.getChannelLocator(this.siteID, "Z").getStationCode() + " the DataFramePacket is not valid");
            return null;
        }
        DataFramePacket dfPacket = new DataFramePacket(gpacket);
        int[] data = dfPacket.getSamples();
        if (data == null) {
            System.err.println(new Date() + ":\t" + this.siteInfo.getChannelLocator(this.siteID, "Z").getStationCode() + " the DataFramePacket is not valid");
            return null;
        }
        DataFrame[] dfs = new DataFrame[]{new DataFrame()};
        dfs[0].data = data;
        dfs[0].flag = 0;
        if (dfPacket.getType() == 9 || dfPacket.getType() == 10) {
            dfs[0].flag = 1;
        }
        dfs[0].siteID = dfPacket.getSER();
        dfs[0].time = dfPacket.getDataTimeTag().getTime() / 1000L;
        dfs[0].ns = 0L;
        dfs[0].sampRate = dfs[0].data.length;
        dfs[0].setChannelLocator(this.siteInfo.getChannelLocator(this.siteID, compCode[dfPacket.getChan()]));
        if (this.logLostManager != null && dfs != null) {
            int i = 0;
            while (i < dfs.length) {
                LogLostManager.TimeInfo timeInfo = new LogLostManager.TimeInfo();
                timeInfo.date = dfs[i].time * 1000L + dfs[i].ns / 1000L;
                timeInfo.length = dfs[i].data.length * 1000 / dfs[i].sampRate;
                this.logLostManager.log(dfs[i].getChannelLocator(), timeInfo);
                ++i;
            }
        }
        return dfs;
    }

    private boolean findFrameHead() throws IOException {
        int ret;
        int i = 0;
        while (i < this.headLen) {
            this.head[i] = 0;
            ++i;
        }
        int firstIdx = 0;
        boolean found = false;
        while ((ret = this.forceRead(this.in)) != -1) {
            this.head[firstIdx % this.headLen] = ret;
            int i2 = firstIdx;
            while (i2 < firstIdx + this.headLen) {
                if (this.head[(i2 + 1) % this.headLen] != frameHead[i2 - firstIdx]) {
                    found = false;
                    break;
                }
                found = true;
                ++i2;
            }
            if (found) break;
            ++firstIdx;
            firstIdx %= this.headLen;
        }
        if (!found) {
            System.err.println(new Date() + ":\t" + this.siteInfo.getChannelLocator(this.siteID, "Z").getStationCode() + " has enough data to read, but I can't found Frame Header \"0xC0\".");
        }
        return found;
    }

    private boolean hasEnoughData() throws IOException {
        int delay = 3000;
        int count = 0;
        while (delay != 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.in.available() >= 512) break;
            if (count++ > 998 && this.in.available() == 0) {
                return false;
            }
            --delay;
        }
        delay = 3000 - delay;
        return true;
    }

    private int readOnePacket() throws IOException {
        int i = 0;
        while ((this.buffer[i++] = (byte)this.forceRead(this.in)) != -27 && i < this.buffer.length) {
        }
        if (i >= this.buffer.length) {
            return -1;
        }
        return i - 1;
    }

    private int forceRead(InputStream IN) throws IOException {
        while (IN.available() < 1) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return IN.read();
    }
}

