/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.geotech;

public class GeoTechPacket {
    public static final int FLAG = 224;
    public static final int ACK = 225;
    public static final int NAK = 226;
    public static final int SYNC = 227;
    public static final int CAN = 228;
    public static final int EOF = 229;
    static int syncByte = 227;
    byte[] frame;
    static int eofByte = 229;

    public GeoTechPacket(byte[] frame) {
        this.frame = this.removeEsc(frame, 0, frame.length);
    }

    public GeoTechPacket(byte[] frame, int off, int len) {
        this.frame = this.removeEsc(frame, off, len);
    }

    public GeoTechPacket(GeoTechPacket gPacket) {
        this.frame = gPacket.frame;
    }

    public byte[] getFrame() {
        return this.frame;
    }

    public boolean isControlPacket() {
        return this.frame.length == 1;
    }

    byte[] removeEsc(byte[] buffer, int off, int len) {
        int n = len;
        int i = off;
        while (i < off + n - 1) {
            if (buffer[i] == -32 && buffer[i + 1] >= 64 && buffer[i + 1] <= 69) {
                buffer[i] = (byte)(buffer[i] | buffer[i + 1]);
                int j = i + 2;
                while (j < n) {
                    buffer[j - 1] = buffer[j];
                    ++j;
                }
                --n;
            }
            ++i;
        }
        byte[] ret = new byte[n];
        System.arraycopy(buffer, off, ret, 0, n);
        return ret;
    }

    public byte[] toEscPacket() {
        byte[] buf = new byte[this.frame.length * 2];
        int n = this.frame.length;
        int i = 0;
        while (i < this.frame.length) {
            if ((this.frame[i] & 0xFF) >= 224 && (this.frame[i] & 0xFF) <= 229) {
                buf[n++] = -32;
                buf[n++] = (byte)(this.frame[i] ^ 0xA0);
            } else {
                buf[n++] = this.frame[i];
            }
            ++i;
        }
        byte[] ret = new byte[n + 2];
        ret[0] = -29;
        System.arraycopy(buf, 0, ret, 1, n);
        ret[n + 1] = -27;
        return ret;
    }

    public static byte[] buildAck() {
        byte[] r = new byte[]{-29, -31, -27};
        return r;
    }
}

