/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.geotech;

import cn.org.gddsn.liss.port.geotech.GeoTechPacket;

public class MessagePacket
extends GeoTechPacket {
    static final int[] crc16tab = new int[256];

    static {
        int i = 0;
        while (i < crc16tab.length) {
            int crc = i << 8;
            int j = 0;
            while (j < 8) {
                crc = crc << 1 ^ ((crc & 0x8000) != 0 ? 4129 : 0);
                ++j;
            }
            MessagePacket.crc16tab[i] = crc & 0xFFFF;
            ++i;
        }
    }

    public MessagePacket(byte[] frame) {
        super(frame);
    }

    public int getType() {
        return this.frame[0] & 0xFF;
    }

    public MessagePacket(GeoTechPacket gPacket) {
        super(gPacket);
    }

    public int getSER() {
        return ((this.frame[2] & 0xFF) << 8) + (this.frame[1] & 0xFF);
    }

    public int getFCS() {
        int ch1 = this.frame[this.frame.length - 2] & 0xFF;
        int ch2 = this.frame[this.frame.length - 1] & 0xFF;
        return (ch1 << 8) + ch2;
    }

    public boolean isDataFramePacket() {
        return this.getType() < 32;
    }

    public boolean isResponsePacket() {
        return this.getType() >= 32 && this.getType() < 96;
    }

    public boolean isUnsolicitedPacket() {
        return this.getType() >= 96 && this.getType() < 128;
    }

    public boolean isCommandPacket() {
        return this.getType() > 128;
    }

    public int calMessageBlockFCS0() {
        int value = 0;
        int n = 0;
        while (n < this.frame.length - 2) {
            int aByte;
            int a = aByte = this.frame[n];
            int count = 7;
            while (count >= 0) {
                int b = (a <<= 1) >>> 8 & 1;
                value = (value & 0x8000) != 0 ? (value << 1) + b ^ 0x1021 : (value << 1) + b;
                --count;
            }
            value &= 0xFFFF;
            ++n;
        }
        return value;
    }

    public int calMessageBlockFCS() {
        int val = 0;
        int n = 0;
        while (n < this.frame.length - 2) {
            int b = crc16tab[(val >>> 8 ^ this.frame[n]) & 0xFF];
            val = ((b >>> 8 ^ val & 0xFF) << 8) + (b & 0xFF);
            val &= 0xFFFF;
            ++n;
        }
        return val;
    }

    public boolean isValid() {
        return this.calMessageBlockFCS() == this.getFCS();
    }
}

