/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.geotech;

import cn.org.gddsn.liss.port.ComServPortInf;
import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.LogLostManager;
import cn.org.gddsn.liss.port.MiniSeedStreamEncoder;
import cn.org.gddsn.liss.port.SiteInfo;
import cn.org.gddsn.liss.port.geotech.ServerPI;
import cn.org.gddsn.liss.port.geotech.Smart24IO;
import cn.org.gddsn.liss.port.geotech.ToServerInf;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.util.Canadian;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class ServerDTP
implements ComServPortInf,
DataFrameInput {
    static Logger logger;
    private static DecimalFormat fmt;
    private static SimpleDateFormat sdf;
    private ServerPI serverPI;
    private String dataHost;
    private int dataPort = 4010;
    private ServerSocket dataServerSocket = null;
    private DataInputStream reader;
    private DataOutputStream writer;
    private Smart24IO smart24IO = new Smart24IO();
    private ToServerInf toServerInf = null;
    private static final String[] compCode;
    private SiteInfo siteInfo = null;
    private String[] chanDis;
    private int data_type = 7;
    private MiniSeedStreamEncoder miniSeedInputStream;
    int seq = 0;
    private LogLostManager logLostManager = new LogLostManager();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.geotech.ServerDTP");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        fmt = new DecimalFormat("000000");
        sdf = new SimpleDateFormat("yyyyDDD HH:mm:ss.SSS");
        compCode = new String[]{"Z", "E", "N"};
    }

    public ServerDTP() {
    }

    public ServerDTP(ServerPI serverPI) {
        this.setServerPI(serverPI);
    }

    public void setServerPI(ServerPI serverPI) {
        this.serverPI = serverPI;
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public MiniSeedStreamEncoder createMiniSeedInputStream() {
        logger.warn("Create MiniSeedInputStream");
        return new MiniSeedStreamEncoder(this);
    }

    public void setLogLostManager(LogLostManager logLostManager) {
        this.logLostManager = logLostManager;
    }

    public void setToServerInf(ToServerInf toServerInf) {
        this.toServerInf = toServerInf;
    }

    public void setSmart24IO(Smart24IO smart24IO) {
        this.smart24IO = smart24IO;
    }

    public void setDataPort(String host, int port) {
        this.dataHost = host;
        this.dataPort = port;
    }

    public int getDataPort() {
        return this.dataPort;
    }

    public int enterPassiveMode() throws IOException {
        if (this.dataServerSocket != null) {
            this.dataServerSocket.close();
        }
        this.dataServerSocket = new ServerSocket(0, 1);
        this.dataServerSocket.setSoTimeout(60000);
        this.dataPort = this.dataServerSocket.getLocalPort();
        this.dataHost = this.serverPI.getLocalHostAddress();
        logger.info("DataPort Listening on : " + this.dataPort);
        return this.dataPort;
    }

    public void dtp() throws IOException {
        Socket dataSocket = null;
        try {
            try {
                dataSocket = this.dataServerSocket.accept();
                this.dataServerSocket.close();
                logger.info("DataPort accept client: " + dataSocket.getInetAddress().getHostAddress() + ":" + dataSocket.getPort());
                dataSocket.setSoLinger(true, 5);
                this.reader = new DataInputStream(dataSocket.getInputStream());
                this.writer = new DataOutputStream(dataSocket.getOutputStream());
                this.miniSeedInputStream = this.createMiniSeedInputStream();
                this.miniSeedInputStream.setDataFrameInput(this);
                while (true) {
                    byte[] buf = this.miniSeedInputStream.readMiniSeedRecord();
                    if (this.toServerInf == null || buf == null) continue;
                    int indx = 0;
                    while (indx < buf.length) {
                        try {
                            System.arraycopy(fmt.format(this.seq).getBytes(), 0, buf, indx, 6);
                            this.incSEQ();
                        }
                        catch (NullPointerException npEx) {
                            logger.warn(fmt.format(this.seq));
                            try {
                                FileOutputStream fos = new FileOutputStream("errorInServerDTP.bin");
                                fos.write(buf);
                                fos.flush();
                                fos.close();
                            }
                            catch (IOException ioEx) {
                                logger.warn(ioEx.getMessage(), ioEx);
                            }
                        }
                        indx += 512;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug(GenericMiniSeedRecord.buildMiniSeedRecord(buf));
                    }
                    this.toServerInf.write(buf);
                }
            }
            catch (ConnectException ce) {
                logger.error(ce.getMessage(), ce);
                throw ce;
            }
            catch (IOException e) {
                logger.error(e.getMessage(), e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
                if (this.reader != null) {
                    this.reader.close();
                }
                if (dataSocket != null) {
                    dataSocket.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
    }

    public void incSEQ() {
        this.seq = (this.seq + 1) % 1000000;
    }

    private String getNetworkID(String stn) {
        String net = "XX";
        int i = 0;
        while (i < this.toServerInf.getStationCode().length) {
            if (this.toServerInf.getStationCode()[i].endsWith(stn)) {
                net = this.toServerInf.getStationCode()[i].substring(0, 2);
            }
            ++i;
        }
        return net;
    }

    public DataFrame[] readDataFrame() throws IOException {
        if (this.smart24IO == null) {
            this.smart24IO = new Smart24IO();
        }
        Smart24IO.CDFrame cdFrame = this.smart24IO.readCDFrame(this.reader);
        if (logger.isDebugEnabled()) {
            logger.debug("Received CD Frame: \r\n" + cdFrame);
        }
        if (cdFrame.getCDFrameHeader().type == 5) {
            Smart24IO.CDFrameData cdframeData = (Smart24IO.CDFrameData)cdFrame.getCDFrameBody();
            int numChan = cdframeData.numChannel;
            DataFrame[] dfs = new DataFrame[numChan];
            int i = 0;
            while (i < numChan) {
                dfs[i] = new DataFrame();
                byte auth = cdframeData.subframe[i].channelDiscription[0];
                if (auth == 1) {
                    logger.warn("decompress authentication data is not implemented.");
                    return null;
                }
                byte compress = cdframeData.subframe[i].channelDiscription[1];
                byte sensorType = cdframeData.subframe[i].channelDiscription[2];
                byte calibdata = cdframeData.subframe[i].channelDiscription[3];
                int calibFlag = (cdframeData.subframe[i].channelStatus[1] & 0xF) >>> 3 & 1;
                String chanDes = new String(cdframeData.subframe[i].channelDiscription, 4, 10);
                if (logger.isDebugEnabled()) {
                    logger.info("Channel Desc: " + chanDes);
                }
                String stn = chanDes.substring(0, 5).trim();
                String net = "XX";
                if (this.toServerInf != null) {
                    net = this.getNetworkID(stn);
                }
                String chan = chanDes.substring(5, 8).trim();
                String loc = chanDes.substring(8, 10).trim();
                dfs[i].setChannelLocator(new ChannelLocator(net, stn, loc, chan));
                int n = dfs[i].flag = calibFlag == 1 ? 3 : 0;
                if (dfs[i].flag > 0) {
                    logger.info(dfs[i].getChannelLocator() + " got calibration");
                }
                try {
                    Date datTime = sdf.parse(new String(cdframeData.subframe[i].timestamp));
                    dfs[i].time = datTime.getTime() / 1000L;
                    dfs[i].ns = datTime.getTime() % 1000L * 1000000L;
                    if (dfs[i].ns == 1000000000L) {
                        ++dfs[i].time;
                        dfs[i].ns = 0L;
                    }
                }
                catch (Exception pEx) {
                    logger.warn("Subframe time is invalid: " + new String(cdframeData.subframe[i].timestamp));
                    logger.info(cdframeData);
                }
                dfs[i].sampRate = cdframeData.subframe[i].samples * 1000 / cdframeData.subframe[i].frameTimeLength;
                switch (compress) {
                    case 0: {
                        try {
                            dfs[i].data = this.decompress(cdframeData.subframe[i].data);
                        }
                        catch (Exception pEx) {}
                        break;
                    }
                    case 1: {
                        try {
                            dfs[i].data = Canadian.decompress(cdframeData.subframe[i].data, cdframeData.subframe[i].samples);
                            break;
                        }
                        catch (Canadian.DecompressionException dEx) {
                            logger.warn("Decompress error.");
                            return null;
                        }
                    }
                    default: {
                        logger.warn("Counld not decompress this type data.");
                        return null;
                    }
                }
                ++i;
            }
            if (this.logLostManager != null && dfs != null) {
                i = 0;
                while (i < dfs.length) {
                    LogLostManager.TimeInfo timeInfo = new LogLostManager.TimeInfo();
                    timeInfo.date = dfs[i].time * 1000L + dfs[i].ns / 1000000L;
                    timeInfo.length = dfs[i].data.length * 1000 / dfs[i].sampRate;
                    this.logLostManager.log(dfs[i].getChannelLocator(), timeInfo);
                    ++i;
                }
            }
            return dfs;
        }
        logger.warn("DATA is not Smart24IO.FRAME_TYPE_DATA, type=" + cdFrame.getCDFrameHeader());
        return null;
    }

    private int[] decompress(byte[] buf) throws IOException {
        int n = buf.length / 4;
        DataInputStream di = new DataInputStream(new ByteArrayInputStream(buf));
        int[] data = new int[n];
        int i = 0;
        while (i < data.length) {
            data[i] = di.readInt();
            ++i;
        }
        return data;
    }

    public void close() {
    }

    public void openComServPort() throws IOException {
        this.dtp();
    }

    public byte[] readMiniSeedFrame() throws IOException {
        byte[] buf = this.miniSeedInputStream.readMiniSeedRecord();
        return buf;
    }

    public void setDataType(int data_type) {
        this.data_type = data_type;
    }

    public void setChannelDiscription(String[] chanDis) {
        this.chanDis = chanDis;
        this.siteInfo = new SiteInfo(chanDis, compCode);
    }

    public void setMaxCompressSamples(int maxSamples) {
        this.miniSeedInputStream.setMaxSamplesInMiniSeed(maxSamples);
    }
}

