/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.geotech;

import cn.org.gddsn.liss.port.geotech.ServerDTP;
import cn.org.gddsn.liss.port.geotech.Smart24IO;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import org.apache.log4j.Logger;

public class ServerPI
implements Runnable {
    static Logger logger;
    private Socket clientSocket;
    private DataInputStream reader;
    private DataOutputStream writer;
    private ServerDTP serverDTP;
    private String remoteHostAddress = null;
    private int remotePort = -1;
    private String localHostAddress = null;
    private int localPort = -1;
    private int timeout = 120;
    private Smart24IO smart24IO;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.geotech.ServerPI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public ServerPI(Socket clientSocket) throws IOException {
        this.setClientSocket(clientSocket);
    }

    public void setClientSocket(Socket clientSocket) throws IOException {
        this.clientSocket = clientSocket;
        this.reader = new DataInputStream(clientSocket.getInputStream());
        this.writer = new DataOutputStream(clientSocket.getOutputStream());
    }

    public ServerPI() {
    }

    public void setServerDTP(ServerDTP serverDTP) {
        this.serverDTP = serverDTP;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setSmart24IO(Smart24IO smart24IO) {
        this.smart24IO = smart24IO;
    }

    public ServerDTP createServerDTP() {
        logger.warn("Create ServerDTP");
        return new ServerDTP();
    }

    public void run() {
        block13: {
            logger.info("SmartServer has be connected.");
            try {
                this.clientSocket.setSoTimeout(this.timeout * 1000);
                this.clientSocket.setKeepAlive(true);
                if (this.localHostAddress == null) {
                    this.localHostAddress = this.clientSocket.getLocalAddress().getHostAddress();
                }
                if (this.localPort == -1) {
                    this.localPort = this.clientSocket.getLocalPort();
                }
                if (this.remoteHostAddress == null) {
                    this.remoteHostAddress = this.clientSocket.getInetAddress().getHostAddress();
                }
                if (this.remotePort == -1) {
                    this.remotePort = this.clientSocket.getPort();
                }
                if (this.smart24IO == null) {
                    this.smart24IO = new Smart24IO();
                }
                Smart24IO.CDFrame cdFrame = this.smart24IO.readCDFrame(this.reader);
                logger.debug("Received CD Frame: \r\n" + cdFrame);
                cdFrame.getCDFrameBody();
                if (cdFrame.getCDFrameHeader().type == 1) {
                    this.serverDTP = this.createServerDTP();
                    this.serverDTP.setServerPI(this);
                    int dataPort = this.serverDTP.enterPassiveMode();
                    cdFrame.getCDFrameHeader().type = 2;
                    byte[] tmp = cdFrame.getCDFrameHeader().destination;
                    cdFrame.getCDFrameHeader().destination = cdFrame.getCDFrameHeader().creator;
                    cdFrame.getCDFrameHeader().creator = tmp;
                    Smart24IO.CDFrameConnection body = (Smart24IO.CDFrameConnection)cdFrame.getCDFrameBody();
                    body.frameType = 2;
                    byte[] ip = this.clientSocket.getLocalAddress().getAddress();
                    body.ipAddress = ((ip[0] & 0xFF) << 24) + ((ip[1] & 0xFF) << 16) + ((ip[2] & 0xFF) << 8) + ((ip[3] & 0xFF) << 0);
                    body.port = (short)dataPort;
                    body.stationName = "SmartSta".getBytes();
                    this.smart24IO.writeCDFrame(this.writer, cdFrame);
                    logger.debug("Sent CD connection response Frame: \r\n" + cdFrame);
                    logger.info("Control socket closing, data socket starting");
                    try {
                        this.reader.close();
                        this.writer.close();
                        this.clientSocket.close();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                    this.serverDTP.dtp();
                    break block13;
                }
                logger.warn("Got wrong frame type, force close socket");
                logger.info("Control socket closing, data socket starting");
                try {
                    this.reader.close();
                    this.writer.close();
                    this.clientSocket.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }
            catch (SocketException sEx) {
                logger.error(sEx.getMessage(), sEx);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), e);
            }
        }
    }

    String getLocalHostAddress() {
        return this.localHostAddress;
    }

    int getLocalHostPort() {
        return this.localPort;
    }

    String getRemoteHostAddress() {
        return this.remoteHostAddress;
    }

    int getRemoteHostPort() {
        return this.remotePort;
    }

    String getLoggerHeader() {
        return new Date() + ":\tClientPI-" + this.getRemoteHostAddress() + ":" + this.getRemoteHostPort() + "\t";
    }

    String getPILoggerHeader() {
        return String.valueOf(this.getRemoteHostAddress()) + ":" + this.getRemoteHostPort() + "\t";
    }

    String getDetailHeader() {
        return String.valueOf(this.getLocalHostAddress()) + ":" + this.getLocalHostPort() + "/" + this.getRemoteHostAddress() + ":" + this.getRemoteHostPort();
    }
}

