/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.geotech;

import cn.org.gddsn.liss.port.geotech.ServerPI;
import cn.org.gddsn.util.Log4jConfig;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class SmartServer {
    static Logger logger;
    public static final int SERVER_PORT = 9000;
    private boolean bQuit = false;
    private int port = 9000;
    private static ThreadGroup clientGroup;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.geotech.SmartServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        clientGroup = new ThreadGroup("Client Group");
    }

    public SmartServer(int port) {
        this.port = port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public SmartServer() {
        this.setPort(9000);
    }

    public ServerPI createServerPI() {
        logger.warn("Create ServerPI");
        return new ServerPI();
    }

    public void service() throws Exception {
        ServerSocket serverSocket = new ServerSocket(this.port);
        serverSocket.setSoTimeout(30000);
        logger.info("Start SmartServer, ready to accept Client.");
        Socket clientSocket = null;
        while (!this.bQuit) {
            try {
                clientSocket = serverSocket.accept();
                ServerPI pi = this.createServerPI();
                pi.setClientSocket(clientSocket);
                String rHostName = clientSocket.getInetAddress().getHostAddress();
                int rHostPort = clientSocket.getPort();
                String thrdName = "ClientPI-" + rHostName + ":" + rHostPort;
                logger.info("Accept a client: " + thrdName);
                new Thread(clientGroup, pi, thrdName).start();
            }
            catch (InterruptedIOException iioEx) {
            }
            catch (SocketException sEx) {
                logger.warn(String.valueOf(sEx.getMessage()) + "\tSUN(?)", sEx);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (OutOfMemoryError oom) {
                logger.error(oom.getMessage(), oom);
                clientSocket.close();
                System.gc();
            }
        }
        serverSocket.close();
        logger.info("Stop SmartServer to accept more client login.");
    }

    void stopServer() {
        this.bQuit = true;
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain("SmartServer.properties");
        SmartServer smartserver = new SmartServer();
        smartserver.service();
    }
}

