/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.guralp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.log4j.Logger;

public class GuralpCalibration {
    static Logger logger;
    private String respond;
    public static final int SINEWAVE = 0;
    public static final int SQUAREWAVE = 1;
    public static final int RANDOMCAL = 2;
    public static final int HZ = 0;
    public static final int SECOND = 1;
    private final byte CMD_FLAGE1 = (byte)7;
    private final byte CMD_FLAGE2 = (byte)13;
    private StringBuffer CMD = new StringBuffer("");
    private StringBuffer caliPar = new StringBuffer("");
    private int CALI_TYPE = 0;
    private int Unit_TYPE = 0;
    private short minute = (short)2;
    private short amplitude = (short)100;
    private short unitValue = 1;
    private static final String ok = "ok_";
    private static final String cmdmod = "Command Mode";
    private static final String calinpro = "Calibration in progress";
    private static final String undefined = "undefined";
    BufferedReader bfr;
    BufferedWriter bfw;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.guralp.GuralpCalibration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public GuralpCalibration(InputStream in, OutputStream out) {
        this.bfr = new BufferedReader(new InputStreamReader(in));
        this.bfw = new BufferedWriter(new OutputStreamWriter(out));
    }

    public void setCaliType(int caliType) {
        this.CALI_TYPE = caliType;
    }

    public void setUnitType(int unitType) {
        this.Unit_TYPE = unitType;
    }

    public void setMinute(short minute) {
        this.minute = minute;
    }

    public void setAmplitude(short amplitude) {
        this.amplitude = amplitude;
    }

    public void setHz(short unitValue) {
        this.unitValue = unitValue;
    }

    public String getParString() {
        return this.caliPar.toString();
    }

    public short calibration() throws IOException {
        block14: {
            try {
                this.bfw.write(7);
                this.bfw.write(13);
                this.bfw.flush();
            }
            catch (IOException ex) {
                logger.warn("send CMD_FLAGE exception" + ex.toString());
            }
            logger.info("Send CMD_FLAGE completed");
            this.respond = this.getRespond(5);
            logger.info("Respond:" + this.respond);
            if (!this.respond.contains(cmdmod)) {
                logger.warn("Unknow respond: " + this.respond);
                return -1;
            }
            this.CMD.delete(0, this.CMD.length());
            switch (this.CALI_TYPE) {
                case 0: {
                    if (this.Unit_TYPE == 0) {
                        this.CMD.append(String.valueOf(this.amplitude) + " %AMPLITUDE " + this.minute + " MINUTE ALL " + this.unitValue + " HZ SINEWAVE\r");
                        this.caliPar.append(String.valueOf(this.unitValue) + " Hz " + this.minute + " minute " + this.amplitude + " %amplitude sinewave calibration ");
                        break;
                    }
                    if (this.Unit_TYPE != 1) break;
                    this.CMD.append(String.valueOf(this.amplitude) + " %AMPLITUDE " + this.minute + " MINUTE ALL " + this.unitValue + " SECOND SINEWAVE\r");
                    this.caliPar.append(String.valueOf(this.unitValue) + " Second " + this.minute + " minute " + this.amplitude + " %amplitude sinewave calibration ");
                    break;
                }
                case 1: {
                    this.CMD.append(String.valueOf(this.amplitude) + " %AMPLITUDE " + this.minute + " MINUTE ALL SQUAREWAVE\r");
                    this.caliPar.append(String.valueOf(this.minute) + " minute " + this.amplitude + " %amplitude pulse calibration ");
                    break;
                }
                case 2: {
                    this.CMD.append(String.valueOf(this.amplitude) + " %AMPLITUDE " + this.minute + " MINUTE ALL RANDOMCAL\r");
                    this.caliPar.append(String.valueOf(this.minute) + " minute " + this.amplitude + " %amplitude randomcal calibration ");
                }
            }
            this.bfw.write(this.CMD.toString(), 0, this.CMD.length());
            this.bfw.flush();
            logger.info("Send calibration command completed");
            this.respond = this.getRespond(1);
            logger.info("Respond:" + this.respond);
            if (!this.respond.contains(undefined)) break block14;
            logger.info("Command error: " + this.CMD);
            return -2;
        }
        try {
            if (!this.respond.contains(ok)) {
                this.respond = this.getRespond(1);
                logger.info("Respond:" + this.respond);
            }
            if (this.respond.contains(calinpro)) {
                logger.info(this.respond);
                return 2;
            }
        }
        catch (IOException ex) {
            logger.warn("send command exception" + ex.toString(), ex);
        }
        return 1;
    }

    public String getRespond(int line) {
        StringBuffer respond = new StringBuffer("");
        try {
            int i = 0;
            while (i < line) {
                respond.append(this.bfr.readLine());
                ++i;
            }
        }
        catch (IOException ex) {
            logger.warn("get respond" + ex.toString(), ex);
            return null;
        }
        return respond.toString();
    }
}

