/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.guralp;

import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.LogLostManager;
import cn.org.gddsn.liss.port.SiteInfo;
import cn.org.gddsn.liss.port.guralp.GuralpComPacket;
import cn.org.gddsn.security.Bytes;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class GuralpInputStream
implements DataFrameInput {
    static Logger logger;
    private static final String[] compCode;
    InputStream in;
    OutputStream out;
    String comPort;
    private static final int[] frameHead;
    private int headLen = frameHead.length;
    private int[] head = new int[this.headLen];
    private byte blockSequByte;
    private int blockSequence;
    private short blockSize;
    private byte[] dataBuf = new byte[1024];
    private int checkSum;
    private byte[] ack = new byte[6];
    private byte[] nack = new byte[6];
    private byte[] streamIdBuf = new byte[4];
    private SiteInfo siteInfo = null;
    private LogLostManager logLostManager = new LogLostManager();
    private long caliTime = -1L;
    private int caliFlag = 0;
    GuralpComPacket gp = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.guralp.GuralpInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        compCode = new String[]{"Z", "E", "N", "X", "C"};
        frameHead = new int[]{71};
    }

    public GuralpInputStream(InputStream in, OutputStream out, String comPort, String[] chanDiscription) {
        this.in = in;
        this.out = out;
        this.comPort = comPort;
        this.siteInfo = new SiteInfo(chanDiscription, compCode);
    }

    public int getTotalChannels() {
        return this.siteInfo.getChannalSize();
    }

    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DataFrame[] readDataFrame() throws IOException {
        DataInputStream dIn = new DataInputStream(this.in);
        DataOutputStream dOut = new DataOutputStream(this.out);
        if (!this.hasEnoughData()) {
            return null;
        }
        if (!this.findFrameHead()) {
            return null;
        }
        this.blockSequByte = dIn.readByte();
        this.blockSequence = this.blockSequByte & 0xFF;
        if (logger.isDebugEnabled()) {
            logger.debug("block sequence: " + this.blockSequence);
        }
        this.blockSize = dIn.readShort();
        if (logger.isDebugEnabled()) {
            logger.debug("block size: " + this.blockSize);
        }
        if (this.blockSize < 0 || this.blockSize > 1024) {
            logger.warn("wrong block size value");
            return null;
        }
        dIn.readFully(this.dataBuf, 0, this.blockSize);
        int i = 0;
        while (i < 4) {
            this.streamIdBuf[i] = this.dataBuf[i + 4];
            ++i;
        }
        this.checkSum = dIn.readShort() & 0xFFFF;
        if (logger.isDebugEnabled()) {
            logger.debug("read check sum: " + this.checkSum);
        }
        if (this.calculateCheck(this.dataBuf, this.blockSize) == this.checkSum) {
            this.ack = this.ACK(this.streamIdBuf);
            dOut.write(this.ack, 0, this.ack.length);
            dOut.flush();
            if (logger.isDebugEnabled()) {
                logger.debug("send ACK signal:" + Bytes.toString(this.ack, 0, this.ack.length));
            }
        } else {
            this.nack = this.NACK(this.streamIdBuf);
            dOut.write(this.nack, 0, this.nack.length);
            dOut.flush();
            logger.warn("calculate checkSum not equal read checkSum,send NACK singal and retrun");
            if (logger.isDebugEnabled()) {
                logger.debug("send NACK signal:" + Bytes.toString(this.nack, 0, this.nack.length));
            }
            return null;
        }
        this.gp = new GuralpComPacket(this.dataBuf, this.blockSize);
        if (logger.isDebugEnabled()) {
            logger.debug(this.gp.toString());
        }
        if (this.gp == null) {
            return null;
        }
        if (this.gp.getSampleRate() < 10) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.gp);
        }
        String streamId = this.gp.getStreamId();
        String comp = streamId.substring(4, 5).toUpperCase();
        int tap = Integer.parseInt(streamId.substring(5));
        DataFrame[] dfs = new DataFrame[]{new DataFrame()};
        dfs[0].time = this.gp.getStartTime().getTime() / 1000L;
        dfs[0].ns = 0L;
        dfs[0].siteID = tap % 2;
        dfs[0].setChannelLocator(this.siteInfo.getChannelLocator(dfs[0].siteID, comp));
        if (comp.equals(compCode[4])) {
            this.caliFlag = 3;
            this.caliTime = dfs[0].time;
            logger.info("Station " + dfs[0].getChannelLocator() + " detect calibration.");
        } else if (Math.abs(this.caliTime - dfs[0].time) > 60L) {
            this.caliFlag = 0;
            this.caliTime = -1L;
        }
        dfs[0].flag = this.caliFlag;
        dfs[0].sampRate = this.gp.getSampleRate();
        dfs[0].data = this.gp.getData();
        if (logger.isDebugEnabled()) {
            logger.debug(dfs[0]);
        }
        if (this.logLostManager != null && dfs != null) {
            int i2 = 0;
            while (i2 < dfs.length) {
                LogLostManager.TimeInfo timeInfo = new LogLostManager.TimeInfo();
                timeInfo.date = dfs[i2].time * 1000L + dfs[i2].ns / 1000000L;
                timeInfo.length = dfs[i2].data.length * 1000 / dfs[i2].sampRate;
                this.logLostManager.log(dfs[i2].getChannelLocator(), timeInfo);
                ++i2;
            }
        }
        if (comp.equals(compCode[4]) || comp.equals(compCode[3])) {
            return null;
        }
        return dfs;
    }

    private int calculateCheck(byte[] buf, int length) {
        int sum = 0;
        int checkSum = 0;
        DataInputStream bins = new DataInputStream(new ByteArrayInputStream(buf, 0, length));
        try {
            int i = 0;
            while (i < length) {
                sum += bins.read();
                ++i;
            }
            bins.close();
        }
        catch (IOException io) {
            logger.warn(io);
        }
        checkSum = (sum += frameHead[0] + this.blockSequence + (this.blockSize & 0xFF) + (this.blockSize >>> 8 & 0xFF)) % 65536;
        if (logger.isDebugEnabled()) {
            logger.debug("calculate check sum:" + checkSum);
        }
        return checkSum;
    }

    private byte[] ACK(byte[] streamId) {
        this.ack[0] = 1;
        this.ack[1] = streamId[3];
        this.ack[2] = 0;
        this.ack[3] = streamId[2];
        this.ack[4] = streamId[1];
        this.ack[5] = streamId[0];
        return this.ack;
    }

    private byte[] NACK(byte[] streamId) {
        this.nack[0] = 2;
        this.nack[1] = streamId[3];
        this.nack[2] = this.blockSequByte;
        this.nack[3] = streamId[2];
        this.nack[4] = streamId[1];
        this.nack[5] = streamId[0];
        return this.nack;
    }

    public void setLogLostManager(LogLostManager logLostManager) {
        this.logLostManager = logLostManager;
    }

    private boolean findFrameHead() throws IOException {
        int ret;
        int i = 0;
        while (i < this.headLen) {
            this.head[i] = 0;
            ++i;
        }
        int firstIdx = 0;
        boolean found = false;
        while ((ret = this.forceRead(this.in)) != -1) {
            this.head[firstIdx % this.headLen] = ret;
            int i2 = firstIdx;
            while (i2 < firstIdx + this.headLen) {
                if (this.head[(i2 + 1) % this.headLen] != frameHead[i2 - firstIdx]) {
                    found = false;
                    break;
                }
                found = true;
                ++i2;
            }
            if (found) break;
            ++firstIdx;
            firstIdx %= this.headLen;
        }
        if (!found) {
            logger.warn(" has enough data to read, but I can't found Frame Header \"0x47\".");
        }
        return found;
    }

    private boolean hasEnoughData() throws IOException {
        int delay = 13000;
        int count = 0;
        while (delay != 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.in.available() >= 1) break;
            if (count++ > 12998 && this.in.available() == 0) {
                logger.warn("waite 13 seconds had not enough Data");
                return false;
            }
            --delay;
        }
        delay = 13000 - delay;
        return true;
    }

    private int forceRead(InputStream in) throws IOException {
        while (in.available() < 1) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return in.read();
    }
}

