/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.guralp;

import cn.org.gddsn.liss.port.guralp.GuralpTCPClient;
import cn.org.gddsn.util.Log4jConfig;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class GuralpPulseCalibrationClient
implements Runnable {
    static Logger logger;
    public static ApplicationContext ctx;
    private String[] hostPort;
    private int dayOfMonth = 1;
    private int hourOfDay = 8;
    private int moh = 0;
    private short minute = (short)3;
    private short amplitude = (short)80;
    private int unitType;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.guralp.GuralpPulseCalibrationClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public void calibration(GuralpTCPClient client) throws IOException {
        client.Caliration(1, 0, new short[]{this.minute}, new short[]{this.amplitude}, new short[]{1});
    }

    public void run() {
        while (true) {
            Date now = new Date();
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(now);
            int dom = c.get(5);
            int hod = c.get(11);
            if (dom != this.dayOfMonth || hod != this.hourOfDay || this.moh != 0) continue;
            this.doCali();
        }
    }

    private void doCali() {
        int i = 0;
        while (i < this.hostPort.length) {
            StringTokenizer st = new StringTokenizer(this.hostPort[i], ":");
            String host = st.nextToken();
            int port = Integer.parseInt(st.nextToken());
            try {
                GuralpTCPClient client = new GuralpTCPClient(host, port);
                this.calibration(client);
                logger.info("success calibration for " + this.hostPort[i]);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException ex) {
                logger.warn("Could not calibration for " + this.hostPort[i]);
                logger.warn(ex.getMessage(), ex);
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain("GuralpCalibrationClient.properties");
        ctx = new FileSystemXmlApplicationContext(new String[]{"GuralpCalibrationClient.xml"});
        GuralpPulseCalibrationClient cali = (GuralpPulseCalibrationClient)ctx.getBean("guralpPulseCalibrationClient");
        Thread thr = new Thread(cali);
        thr.start();
    }

    public short getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(short amplitude) {
        this.amplitude = amplitude;
    }

    public short getMinute() {
        return this.minute;
    }

    public void setMinute(short minute) {
        this.minute = minute;
    }

    public int getUnitType() {
        return this.unitType;
    }

    public void setUnitType(int unitType) {
        this.unitType = unitType;
    }

    public String[] getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(String[] hostPort) {
        this.hostPort = hostPort;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(int dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public int getHourOfDay() {
        return this.hourOfDay;
    }

    public void setHourOfDay(int hourOfDay) {
        this.hourOfDay = hourOfDay;
    }
}

