/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.guralp;

import cn.org.gddsn.liss.port.guralp.GuralpPacket;
import cn.org.gddsn.util.Log4jConfig;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class GuralpUDPClient {
    static Logger logger;
    private String host;
    private int port;
    private long count = 0L;
    private DatagramSocket socket;
    private static String GCFPING;
    private static String GCFSEND;
    private static String GCFSENDB;
    private static String GCFSENDL;
    private static String GCFACKN;
    private static String GCFNOSV;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.guralp.GuralpUDPClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        GCFPING = "GCFPING\u0000";
        GCFSEND = "GCFSEND\u0000";
        GCFSENDB = "GCFSEND:B\u0000";
        GCFSENDL = "GCFSEND:L\u0000";
        GCFACKN = "GCFACKN\u0000";
        GCFNOSV = "GCFNOSV\u0000";
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
        try {
            this.socket = new DatagramSocket(port);
            this.socket.setSoTimeout(120000);
        }
        catch (SocketException ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public void connect() throws IOException {
        this.socket = new DatagramSocket(this.port);
        this.socket.setSoTimeout(120000);
        this.count = 0L;
    }

    public boolean ping() {
        boolean bret = false;
        try {
            DatagramPacket sdp = new DatagramPacket(GCFPING.getBytes(), GCFPING.getBytes().length, InetAddress.getByName(this.host), this.port);
            this.socket.send(sdp);
            byte[] buf = new byte[GCFACKN.length()];
            DatagramPacket rdp = new DatagramPacket(buf, buf.length);
            this.socket.receive(rdp);
            return GCFACKN.equals(new String(buf, 0, rdp.getLength()));
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
            return bret;
        }
    }

    public GuralpPacket getGuralpPacket() throws IOException {
        try {
            if (this.count++ % 50L == 0L) {
                DatagramPacket sdp = new DatagramPacket(GCFSEND.getBytes(), GCFSEND.getBytes().length, InetAddress.getByName(this.host), this.port);
                this.socket.send(sdp);
            }
            byte[] buf = new byte[2048];
            DatagramPacket rdp = null;
            GuralpPacket gp = null;
            do {
                rdp = new DatagramPacket(buf, buf.length);
                this.socket.receive(rdp);
                if (rdp.getLength() >= 1024) continue;
                logger.debug("Received: length=" + rdp.getLength() + ", " + new String(buf, 0, rdp.getLength()));
            } while (rdp.getLength() < 1024 || buf[14] == 0);
            gp = new GuralpPacket(buf, rdp.getLength());
            rdp = null;
            return gp;
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
            throw ex;
        }
    }

    public void close() {
        this.socket.disconnect();
        this.socket.close();
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain("GuarlpUDPClient.properties");
        GuralpUDPClient client = new GuralpUDPClient();
        client.setHost("10.13.24.100");
        client.setPort(5001);
        FileOutputStream fos = new FileOutputStream("/tmp/gcf.hex");
        int n = Integer.MAX_VALUE;
        GuralpPacket gp = null;
        while (n-- != 0) {
            try {
                gp = client.getGuralpPacket();
                if (gp == null) continue;
                System.out.println(gp);
                fos.write(gp.getBuf(), 0, gp.getLength());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        fos.close();
        client.close();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

