/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.liss;

import cn.org.gddsn.liss.port.MiniSeedPort;
import cn.org.gddsn.liss.port.MiniSeedStreamInf;
import cn.org.gddsn.util.Log4jConfig;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class Liss1Port
extends MiniSeedPort
implements MiniSeedStreamInf {
    static Logger logger;
    protected Socket socket = null;
    private String stationCode;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.liss.Liss1Port");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public Liss1Port() {
        this.thisPort = this;
    }

    public Liss1Port(String newServerName, int newSeedPort, String stationCode) {
        super(newServerName, newSeedPort);
        this.stationCode = stationCode;
        this.thisPort = this;
        super.sendMiniSeedData();
    }

    public boolean connectServer() {
        logger.info("Connecting " + this.host + ":" + this.port + " LISS1... In Liss1Port");
        try {
            this.socket = new Socket(this.host, this.port);
            this.socket.setSoTimeout(120000);
            this.receiveFromLISS = this.socket.getInputStream();
        }
        catch (UnknownHostException uhEx) {
            logger.warn("Unknown host " + this.host + " : " + uhEx);
            try {
                Thread.sleep(240000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        catch (InterruptedIOException iEx) {
            logger.warn(String.valueOf(this.host) + ":" + this.port + ": Socket Timeout");
            try {
                Thread.sleep(240000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        catch (IOException ioEx) {
            logger.warn("Failed I/O to " + this.host + ":" + this.port + " : " + ioEx);
            try {
                Thread.sleep(240000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        logger.info("Connected " + this.host + ":" + this.port);
        return true;
    }

    public String[] getStationCode() {
        String[] stns = new String[]{this.stationCode};
        return stns;
    }

    public void closePort() {
        super.closePort();
        this.clean();
    }

    private void clean() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = null;
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            logger.warn("Failed I/O to " + this.host + " : " + ioEx + " in this.close()");
        }
    }

    public static void main(String[] args) {
        Log4jConfig.loadForMain("Liss1Port.properties");
        Liss1Port liss1Port1 = new Liss1Port("127.0.0.1", 4000, "SHT");
    }

    public void setStationCode(String[] stationCode) {
        this.stationCode = stationCode[0];
    }
}

