/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.mr2002;

import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.LogLostManager;
import cn.org.gddsn.liss.port.SiteInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class MR2002InputStream
implements DataFrameInput {
    static Logger logger;
    private static final String[] compCode;
    private DataInputStream dIn = null;
    private DataOutputStream dOut = null;
    private String comPort;
    private static final int[] frameHead;
    private int headLen = frameHead.length;
    private int[] head = new int[this.headLen];
    private final byte[] PWD;
    private final String START = "(Sd0Y++)";
    private final String RATE = "(Sd11++)";
    private int tempByte;
    private SiteInfo siteInfo;
    private boolean newFrameFlag;
    private boolean reFindHead;
    private boolean sendCommand;
    public int sampRate;
    public short startSample;
    private LogLostManager logLostManager;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.mr2002.MR2002InputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        compCode = new String[]{"E", "N", "Z"};
        frameHead = new int[]{44, 13};
    }

    public MR2002InputStream(InputStream in, OutputStream out, String comPort, String[] chanDiscription) {
        byte[] byArray = new byte[11];
        byArray[0] = 40;
        byArray[1] = 76;
        byArray[2] = 105;
        byArray[3] = 83;
        byArray[4] = 87;
        byArray[5] = 73;
        byArray[6] = 83;
        byArray[7] = 83;
        byArray[9] = -78;
        byArray[10] = 41;
        this.PWD = byArray;
        this.START = "(Sd0Y++)";
        this.RATE = "(Sd11++)";
        this.siteInfo = null;
        this.newFrameFlag = false;
        this.reFindHead = true;
        this.sendCommand = true;
        this.sampRate = 0;
        this.logLostManager = new LogLostManager();
        this.comPort = comPort;
        this.siteInfo = new SiteInfo(chanDiscription, compCode);
        this.dIn = new DataInputStream(in);
        this.dOut = new DataOutputStream(out);
    }

    public int getTotalChannels() {
        return this.siteInfo.getChannalSize();
    }

    public void close() throws IOException {
        try {
            this.dIn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DataFrame[] readDataFrame() throws IOException {
        int[] tempData = new int[3];
        int[] dataX = new int[400];
        int[] dataY = new int[400];
        int[] dataZ = new int[400];
        if (this.sendCommand) {
            this.dOut.write(this.PWD, 0, this.PWD.length);
            this.dOut.write("(Sd0Y++)".getBytes());
            logger.debug("Send (Sd0Y++)command to DS");
            this.sendCommand = false;
        }
        if (this.reFindHead) {
            logger.debug("find frame header flage!");
            if (!this.hasEnoughData()) {
                return null;
            }
            if (!this.findFrameHead()) {
                return null;
            }
            this.setReFindHead(false);
            logger.debug("find new data frame!");
        }
        long time = this.readHeaderTime(this.dIn);
        if (logger.isDebugEnabled()) {
            String theTime = this.getStringDate(time);
            logger.debug(theTime);
        }
        if (time == -1L) {
            this.setReFindHead(true);
            return null;
        }
        this.startSample = this.dIn.readShort();
        this.tempByte = this.dIn.readByte();
        logger.debug("Start Sample:" + this.startSample);
        if (this.tempByte != 44) {
            logger.warn("The byte after start sample is not 0x2C but is:" + Integer.toHexString(this.tempByte));
            this.setReFindHead(true);
            return null;
        }
        MR2002InputStream.readMessage(this.dIn);
        MR2002InputStream.readMessage(this.dIn);
        int i = 0;
        while (i < dataX.length) {
            tempData = this.readOneSampleXYZ(this.dIn);
            if (this.newFrameFlag) {
                this.sampRate = i;
                logger.debug("The sample rate is: " + i);
                break;
            }
            if (tempData != null) {
                dataX[i] = tempData[0];
                dataY[i] = tempData[1];
                dataZ[i] = tempData[2];
                if (logger.isDebugEnabled()) {
                    logger.debug(String.valueOf(dataX[i]) + " " + dataY[i] + " " + dataZ[i] + " i=" + i);
                }
            } else {
                logger.debug("read a bad Frame! find frame head again!");
                this.setReFindHead(true);
                return null;
            }
            ++i;
        }
        if (this.newFrameFlag) {
            DataFrame[] dfs = new DataFrame[3];
            this.setNewFrameFlag(false);
            int f = 0;
            while (f < 3) {
                dfs[f] = new DataFrame();
                dfs[f].data = new int[this.sampRate];
                switch (f) {
                    case 0: {
                        System.arraycopy(dataX, 0, dfs[f].data, 0, dfs[f].data.length);
                        break;
                    }
                    case 1: {
                        System.arraycopy(dataY, 0, dfs[f].data, 0, dfs[f].data.length);
                        break;
                    }
                    case 2: {
                        System.arraycopy(dataZ, 0, dfs[f].data, 0, dfs[f].data.length);
                    }
                }
                dfs[f].flag = 0;
                dfs[f].siteID = 0;
                dfs[f].time = time;
                dfs[f].sampRate = this.sampRate;
                dfs[f].setChannelLocator(this.siteInfo.getChannelLocator(dfs[f].siteID, compCode[f]));
                if (this.logLostManager != null && dfs != null) {
                    LogLostManager.TimeInfo timeInfo = new LogLostManager.TimeInfo();
                    timeInfo.date = dfs[f].time * 1000L;
                    timeInfo.length = dfs[f].data.length * 1000 / dfs[f].sampRate;
                    this.logLostManager.log(dfs[f].getChannelLocator(), timeInfo);
                }
                ++f;
            }
            return dfs;
        }
        return null;
    }

    private long readHeaderTime(DataInputStream dIn) {
        int second;
        int minute;
        int hour;
        int year;
        int month;
        int day;
        block5: {
            block4: {
                try {
                    this.tempByte = dIn.read();
                    day = this.BCD2INT(this.tempByte);
                    this.tempByte = dIn.read();
                    month = this.BCD2INT(this.tempByte) - 1;
                    this.tempByte = dIn.read();
                    year = this.BCD2INT(this.tempByte) + 2000;
                    this.tempByte = dIn.read();
                    if (this.tempByte == 44) break block4;
                    logger.warn("the byte after year is not 0x2C but is:" + Integer.toHexString(this.tempByte));
                    return -1L;
                }
                catch (IOException ioEx) {
                    logger.warn(ioEx);
                    return -1L;
                }
            }
            this.tempByte = dIn.read();
            hour = this.BCD2INT(this.tempByte);
            this.tempByte = dIn.read();
            minute = this.BCD2INT(this.tempByte);
            this.tempByte = dIn.read();
            second = this.BCD2INT(this.tempByte);
            this.tempByte = dIn.read();
            if (this.tempByte == 44) break block5;
            logger.warn("the byte after second is not 0x2C but is:" + Integer.toHexString(this.tempByte));
            return -1L;
        }
        GregorianCalendar gcTime = new GregorianCalendar(year, month, day, hour, minute, second);
        gcTime.setTimeZone(TimeZone.getTimeZone("UTC"));
        return gcTime.getTime().getTime() / 1000L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] readOneSampleXYZ(DataInputStream dIn) {
        int[] sample = new int[3];
        try {
            int i = 0;
            while (true) {
                if (i >= 3) {
                    int commaByte = dIn.read();
                    if (commaByte == 44) return sample;
                    logger.warn("the byte after three samples is not 0x2C but is:" + Integer.toHexString(this.tempByte));
                    return null;
                }
                int byte1 = dIn.read();
                if (byte1 == 13 && i == 0) {
                    this.setNewFrameFlag(true);
                    logger.debug("new frame begin!");
                    return null;
                }
                if (byte1 == 69 | byte1 == 42) {
                    byte1 = dIn.read();
                }
                if (byte1 == 40) {
                    while ((byte1 = dIn.read()) == 41) {
                    }
                    byte1 = dIn.read();
                }
                int byte2 = dIn.read();
                int byte3 = dIn.read();
                sample[i] = this.byte2Sample(byte1, byte2, byte3);
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sample;
    }

    private int byte2Sample(int byte1, int byte2, int byte3) {
        int byte0 = 0;
        int sample = (byte0 << 24) + (byte1 << 16) + (byte2 << 8) + byte3;
        if (sample > 524287) {
            return sample | 0xFFF00000;
        }
        return sample;
    }

    private void setNewFrameFlag(boolean flag) {
        this.newFrameFlag = flag;
    }

    private void setReFindHead(boolean flag) {
        this.reFindHead = flag;
    }

    private int BCD2INT(int sourceByte) {
        int[] temp = new int[]{sourceByte & 0xF, sourceByte >> 4 & 0xF};
        int result = temp[1] * 10 + temp[0];
        return result;
    }

    private static String readMessage(DataInputStream dIs) throws IOException {
        byte[] buf = new byte[1024];
        int i = 0;
        i = 0;
        while (i < 2048) {
            buf[i] = dIs.readByte();
            if (buf[i] == 44) break;
            ++i;
        }
        String recStr = new String(buf, 0, i);
        return recStr;
    }

    public String getStringDate(long theTime) {
        Date date = new Date(theTime * 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(date);
    }

    public void setLogLostManager(LogLostManager logLostManager) {
        this.logLostManager = logLostManager;
    }

    private boolean findFrameHead() throws IOException {
        int ret;
        int i = 0;
        while (i < this.headLen) {
            this.head[i] = 0;
            ++i;
        }
        int firstIdx = 0;
        boolean found = false;
        while ((ret = this.forceRead(this.dIn)) != -1) {
            this.head[firstIdx % this.headLen] = ret;
            int i2 = firstIdx;
            while (i2 < firstIdx + this.headLen) {
                if (this.head[(i2 + 1) % this.headLen] != frameHead[i2 - firstIdx]) {
                    found = false;
                    break;
                }
                found = true;
                ++i2;
            }
            if (found) break;
            ++firstIdx;
            firstIdx %= this.headLen;
        }
        if (!found) {
            logger.warn("Has enough data to read, but I can't found Frame Header \"0x2C 0D\".");
        }
        return found;
    }

    private boolean hasEnoughData() throws IOException {
        int delay = 13000;
        int count = 0;
        while (delay != 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.dIn.available() >= 1) break;
            if (count++ > 12998 && this.dIn.available() == 0) {
                logger.warn("waite 13 seconds had not enough Data");
                return false;
            }
            --delay;
        }
        delay = 13000 - delay;
        return true;
    }

    private int forceRead(InputStream in) throws IOException {
        while (in.available() < 1) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return in.read();
    }
}

