/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.mr2002;

import cn.org.gddsn.liss.port.ComServPortInf;
import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.LogLostManager;
import cn.org.gddsn.liss.port.MiniSeedStreamEncoder;
import cn.org.gddsn.liss.port.SiteInfo;
import cn.org.gddsn.liss.port.mr2002.MR2002Client;
import cn.org.gddsn.liss.port.mr2002.MR2002IO;
import cn.org.gddsn.util.Log4jConfig;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class MR2002ServPort
implements DataFrameInput,
ComServPortInf {
    static Logger logger;
    private static final String[] compCode;
    private SiteInfo siteInfo = null;
    private String[] chanDis;
    private int data_type = 13;
    String host;
    int port;
    String password;
    MR2002Client client;
    private MR2002IO mr2002IO;
    private MiniSeedStreamEncoder msis;
    private LogLostManager logLostManager = new LogLostManager();
    private DataInputStream dIn = null;
    private OutputStream outs = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.mr2002.MR2002ServPort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        compCode = new String[]{"E", "N", "Z"};
    }

    public MR2002ServPort(String ServName, int ServPort, String password) {
        this.host = ServName;
        this.port = ServPort;
        this.password = password;
    }

    public boolean prepareProcess() throws IOException {
        return true;
    }

    public boolean connect() throws IOException {
        boolean bvalue = false;
        logger.info("Opening MR2002ServPort...");
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException ioEx) {
            logger.error("IOException: " + ioEx.getMessage());
        }
        try {
            this.client = null;
            this.msis = null;
            this.client = new MR2002Client();
            this.client.setHost(this.host);
            this.client.setPort(this.port);
            this.client.setPassword(this.password);
            this.client.connect();
            this.dIn = this.client.getInputStream();
            this.outs = this.client.getOutputStream();
            this.mr2002IO = new MR2002IO();
        }
        catch (IOException ex) {
            logger.error("IOException: " + ex.getMessage());
            throw new IOException(ex.getMessage());
        }
        this.msis = new MiniSeedStreamEncoder(this);
        logger.info("Opened MR2002ServPort...");
        bvalue = true;
        return bvalue;
    }

    public void openComServPort() throws IOException {
        this.connect();
    }

    public void close() {
        try {
            this.closeComServPort();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    public void closeComServPort() throws IOException {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException ioEx) {
            logger.error("IOException: " + ioEx.getMessage());
        }
    }

    public byte[] readMiniSeedFrame() throws IOException {
        byte[] buf = this.msis.readMiniSeedRecord();
        return buf;
    }

    public void setDataType(int data_type) {
        this.data_type = data_type;
    }

    public void setChannelDiscription(String[] chanDis) {
        this.chanDis = chanDis;
        this.siteInfo = new SiteInfo(chanDis, compCode);
    }

    public void setMaxCompressSamples(int maxSamples) {
        this.msis.setMaxSamplesInMiniSeed(maxSamples);
    }

    public void setSteimLevel(int level) {
        this.msis.setSteimInfo((short)level, (short)7);
    }

    public final DataFrame[] readDataFrame() throws IOException {
        int[] tempData = new int[800];
        if (this.mr2002IO.readMR2002Data(this.dIn) != -1) {
            this.mr2002IO.sendACK(this.outs);
            DataFrame[] dfs = new DataFrame[3];
            int f = 0;
            while (f < 3) {
                dfs[f] = new DataFrame();
                dfs[f].data = new int[this.mr2002IO.getSampleRate()];
                switch (f) {
                    case 0: {
                        tempData = this.mr2002IO.getDataX();
                        System.arraycopy(tempData, 0, dfs[f].data, 0, dfs[f].data.length);
                        break;
                    }
                    case 1: {
                        tempData = this.mr2002IO.getDataY();
                        System.arraycopy(tempData, 0, dfs[f].data, 0, dfs[f].data.length);
                        break;
                    }
                    case 2: {
                        tempData = this.mr2002IO.getDataZ();
                        System.arraycopy(tempData, 0, dfs[f].data, 0, dfs[f].data.length);
                    }
                }
                dfs[f].flag = 0;
                dfs[f].siteID = 0;
                dfs[f].time = this.mr2002IO.getTime();
                dfs[f].sampRate = this.mr2002IO.getSampleRate();
                dfs[f].setChannelLocator(this.siteInfo.getChannelLocator(dfs[f].siteID, compCode[f]));
                if (this.logLostManager != null && dfs != null) {
                    LogLostManager.TimeInfo timeInfo = new LogLostManager.TimeInfo();
                    timeInfo.date = dfs[f].time * 1000L;
                    timeInfo.length = dfs[f].data.length * 1000 / dfs[f].sampRate;
                    this.logLostManager.log(dfs[f].getChannelLocator(), timeInfo);
                }
                ++f;
            }
            return dfs;
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain("MR2002ServPort.properties");
        MR2002ServPort csPort = null;
        String[] cDis = new String[]{"GD/TST/00/BHZ:BHE:BHN"};
        if (args.length < 3) {
            logger.debug("Usage:\n java cn.org.gddsn.liss.port.MR2002ServPort host port password chanDis");
            System.exit(-1);
        } else {
            csPort = new MR2002ServPort(args[0], Integer.parseInt(args[1]), args[2]);
            cDis = new String[args.length - 3];
            int i = 3;
            while (i < args.length) {
                cDis[i - 3] = args[i];
                ++i;
            }
            csPort.setChannelDiscription(cDis);
        }
        try {
            csPort.openComServPort();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        DataFrame[] dfs = null;
        while (true) {
            if ((dfs = csPort.readDataFrame()) != null) {
                System.err.println(dfs[0]);
                continue;
            }
            System.err.println("lost at least one second packet");
        }
    }
}

