/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.nanometrics;

import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.NetworkDataFrameInput;
import cn.org.gddsn.liss.util.StructUtil;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.util.Log4jConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.Vector;
import javolution.io.Struct;
import org.apache.log4j.Logger;
import org.apache.regexp.RE;

public class NaqsClient
implements NetworkDataFrameInput {
    static Logger logger;
    public static final int NMX_SIGNATURE = 2059197967;
    public static final int CONNECT_MSG = 100;
    public static final int CHANNEL_LIST = 150;
    public static final int ERROR_MSG = 190;
    public static final int TERMINATE_MSG = 200;
    public static final int COMPRESSED_DATA = 1;
    public static final int DECOMPRESSED_DATA = 4;
    public static final int TIMSER_TYPE = 1;
    public static final int TIMSER_ADD_REQ = 120;
    public static final int SOH_TYPE = 2;
    public static final int SOH_ADD_REQ = 121;
    public static final int SERIAL_TYPE = 6;
    public static final int SERIAL_ADD_REQ = 124;
    private ChannelList channelList = new ChannelList();
    private String host;
    private int port = 28000;
    private Socket socket = null;
    private DataInputStream in = null;
    private DataOutputStream os = null;
    private int timeout = 120000;
    private int sampRate = 0;
    private int shortTermComp = 60;
    private int sendBufferdData = 0;
    private String[] chanRegex = null;
    private String networkId = "IA";
    private String locationId = "00";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.nanometrics.NaqsClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public NaqsClient() {
    }

    public NaqsClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public boolean connect() throws IOException {
        this.socket = new Socket(this.host, this.port);
        this.socket.setKeepAlive(true);
        this.socket.setSoTimeout(this.timeout);
        this.in = new DataInputStream(this.socket.getInputStream());
        this.os = new DataOutputStream(this.socket.getOutputStream());
        return true;
    }

    public boolean prepareProcess() throws IOException {
        int[] keyList = null;
        this.sendConnectMessage();
        Header header = this.receiveHeader();
        if (header == null) {
            return false;
        }
        if (header.type.get() == 150) {
            logger.info("Got Channel List Message.");
            this.channelList = this.receiveChannelList(header.length.get());
            Vector<Integer> keyVec = new Vector<Integer>();
            int i = 0;
            while (i < this.chanRegex.length) {
                RE re = new RE(this.chanRegex[i]);
                int j = 0;
                while (j < this.channelList.length) {
                    if (re.match(this.channelList.channel[j].name.get())) {
                        keyVec.add(new Integer(this.channelList.channel[j].key.get()));
                    }
                    ++j;
                }
                ++i;
            }
            keyList = new int[keyVec.size()];
            i = 0;
            while (i < keyList.length) {
                keyList[i] = (Integer)keyVec.get(i);
                ++i;
            }
            if (keyList.length == 0) {
                logger.warn("No requested data streams are available!");
                return false;
            }
            this.requestDataChannels(keyList, keyList.length, this.sampRate, this.shortTermComp);
            return true;
        }
        return false;
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.os != null) {
                this.os.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
        this.in = null;
        this.os = null;
        this.socket = null;
    }

    public DataFrame[] readDataFrame() throws IOException {
        Header header = this.receiveHeader();
        if (header == null) {
            return null;
        }
        return this.proccessMessage(header);
    }

    private DataFrame[] proccessMessage(Header header) throws IOException {
        DataFrame[] dfs = null;
        if (header.type.get() == 150) {
            logger.info("Got Channel List Message.");
            this.channelList = this.receiveChannelList(header.length.get());
        } else if (header.type.get() == 190) {
            this.receiveError(header.length.get());
        } else if (header.type.get() == 200) {
            this.receiveTermination(header.length.get());
            logger.info("Receive Termination Message.");
        } else if (header.type.get() == 4) {
            dfs = this.receiveData(header.length.get());
        } else if (header.type.get() == 1) {
            logger.warn("Cannot process compressed data!, length = " + header.length.get());
            this.flushBytes(header.length.get());
        } else {
            logger.warn("Unrecognized message, type = " + header.type.get() + ", length = " + header.length.get());
            this.flushBytes(header.length.get());
        }
        return dfs;
    }

    public int dataType(int key) {
        return key >> 8 & 0xFF;
    }

    public void sendConnectMessage() throws IOException {
        this.sendHeader(100, 0);
    }

    public void sendHeader(int type, int length) throws IOException {
        Header msg = new Header();
        msg.signature.set(2059197967);
        msg.type.set(type);
        msg.length.set(length);
        this.os.write(msg.toByteArray());
    }

    public void requestTypeChannel(int channel, int type) throws IOException {
        AddRequest request = new AddRequest();
        this.sendHeader(type, request.size());
        request.numChannels.set(1);
        request.channel.set(channel);
        request.stcDelay.set(this.shortTermComp);
        request.sendBuffers.set(this.sendBufferdData);
        this.os.write(request.toByteArray());
    }

    public void requestSerialChannel(int channel) throws IOException {
        logger.info("Requesting serial channel " + channel);
        this.requestTypeChannel(channel, 124);
    }

    public void requestSohChannel(int channel) throws IOException {
        this.requestTypeChannel(channel, 121);
    }

    public void requestDataChannel(int channel) throws IOException {
        DataAddRequest request = new DataAddRequest();
        this.sendHeader(120, request.size());
        request.numChannels.set(1);
        request.channel.set(channel);
        request.stcDelay.set(this.shortTermComp);
        request.format.set(this.sampRate);
        request.sendBuffers.set(this.sendBufferdData);
        this.os.write(request.toByteArray());
    }

    public void requestDataChannels(int[] keyList, int found, int samprate, int shortTermComp) throws IOException {
        int contentsize = 16 + 4 * found;
        logger.info("Requesting time series channels\n");
        this.sendHeader(120, contentsize);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(128);
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(found);
        int count = 0;
        while (count < found) {
            dos.writeInt(keyList[count]);
            logger.info("Requesting channel: " + this.lookupChannelName(keyList[count]));
            ++count;
        }
        dos.writeInt(shortTermComp);
        dos.writeInt(samprate);
        dos.writeInt(this.sendBufferdData);
        bos.close();
        this.os.write(bos.toByteArray());
    }

    public void requestChannel(int channel) throws IOException {
        int type = this.dataType(channel);
        if (type == 1) {
            this.requestDataChannel(channel);
        } else if (type == 2) {
            this.requestSohChannel(channel);
        } else {
            this.requestSerialChannel(channel);
        }
    }

    public Header receiveHeader() throws IOException {
        Header header = new Header();
        header.readFully(this.in);
        if (header.signature.get() != 2059197967) {
            logger.warn("Header signature is not " + Integer.toHexString(2059197967));
            return null;
        }
        return header;
    }

    public ChannelList receiveChannelList(int length) throws IOException {
        byte[] buf = new byte[length];
        this.in.readFully(buf);
        DataInputStream in2 = new DataInputStream(new ByteArrayInputStream(buf));
        int nchan = in2.readInt();
        ChannelList list = new ChannelList();
        list.length = nchan;
        list.channel = new ChannelKey[nchan];
        int i = 0;
        while (i < nchan) {
            list.channel[i] = new ChannelKey();
            list.channel[i].readFully(in2);
            logger.info("Channel " + list.channel[i].name.get() + "  has key " + list.channel[i].key.get());
            ++i;
        }
        return list;
    }

    public DataFrame[] receiveData(int length) throws IOException {
        if (length <= 0) {
            return null;
        }
        byte[] buffer = new byte[length];
        this.in.readFully(buffer);
        return this.processData(buffer, length);
    }

    public void receiveError(int length) throws IOException {
        byte[] buffer = new byte[length];
        this.in.readFully(buffer);
        logger.debug(new String(buffer));
    }

    public void receiveTermination(int length) throws IOException {
        int reason = this.in.readInt();
        logger.info("Connection closed by server, reason = " + reason);
    }

    public void flushBytes(int length) throws IOException {
        byte[] buffer = new byte[length];
        this.in.readFully(buffer);
    }

    private DataFrame[] processData(byte[] buffer, int length) {
        int samps;
        double time;
        String chan;
        String sta;
        int key;
        DataInputStream dis;
        DataFrame[] dfs;
        block6: {
            dfs = new DataFrame[]{new DataFrame()};
            dis = new DataInputStream(new ByteArrayInputStream(buffer));
            key = dis.readInt();
            String tmp = this.lookupChannelName(key);
            int idx = tmp.indexOf(46);
            sta = tmp.substring(0, idx);
            chan = tmp.substring(idx + 1);
            dfs[0].setChannelLocator(new ChannelLocator(this.networkId, sta, this.locationId, chan));
            dfs[0].flag = 0;
            dfs[0].siteID = 0;
            time = dis.readDouble();
            samps = dis.readInt();
            dfs[0].sampRate = dis.readInt();
            dfs[0].time = (long)time;
            int wei = (int)Math.ceil(Math.log(dfs[0].sampRate) / Math.log(10.0)) + 1;
            int ex = 9 - wei;
            dfs[0].ns = (long)((double)Math.round((time - (double)dfs[0].time) * Math.pow(10.0, wei)) * Math.pow(10.0, ex));
            if (dfs[0].ns == 1000000000L) {
                ++dfs[0].time;
                dfs[0].ns = 0L;
            }
            if (dfs[0].ns >= 0L && dfs[0].ns <= 999999999L) break block6;
            logger.warn("dataframe.ns=" + dfs[0].ns + " is invalid!, force return null!");
            return null;
        }
        try {
            dfs[0].data = new int[samps];
            int i = 0;
            while (i < samps) {
                dfs[0].data[i] = dis.readInt();
                ++i;
            }
            dis.close();
            if (logger.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer("Received uncompressed data for stream");
                sb.append(" key=" + key + ",sta=" + sta + ",chan=" + chan);
                sb.append(" length=" + length + ", nsamp=" + samps + ", samprate=" + this.sampRate + ", time=" + new Date(Math.round(time * 1000.0)));
                logger.debug(sb.substring(0));
                logger.debug(dfs[0]);
            }
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return dfs;
    }

    int lookupChannelKey(String name) {
        int length = this.channelList.length;
        int i = 0;
        while (i < length) {
            if (name.equals(this.channelList.channel[i].name.get())) {
                return this.channelList.channel[i].key.get();
            }
            ++i;
        }
        return -1;
    }

    private String lookupChannelName(int key) {
        int length = this.channelList.length;
        int ich = 0;
        while (ich < length) {
            if (key == this.channelList.channel[ich].key.get()) {
                return this.channelList.channel[ich].name.get();
            }
            ++ich;
        }
        return null;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setChanRegex(String[] chanRegex) {
        this.chanRegex = chanRegex;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public void setNetworkId(String networkId) {
        this.networkId = networkId;
    }

    public void setShortTermComp(int shortTermComp) {
        this.shortTermComp = shortTermComp;
    }

    public void setSampRate(int sampRate) {
        this.sampRate = sampRate;
    }

    public void setSendBufferdData(int sendBufferdData) {
        this.sendBufferdData = sendBufferdData;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ChannelList getChannelList() {
        return this.channelList;
    }

    public String[] getChanRegex() {
        return this.chanRegex;
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain("NaqsClient.properties");
        NaqsClient client = new NaqsClient("172.19.1.169", 28000);
        String[] chanRegex = new String[]{".*BH."};
        client.setChanRegex(chanRegex);
        client.connect();
        client.prepareProcess();
        int n = 10000;
        while (n-- != 0) {
            client.readDataFrame();
        }
        client.close();
    }

    public static class AddRequest
    extends STRUCT {
        public final Struct.Signed32 numChannels = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 channel = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 stcDelay = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 sendBuffers = new Struct.Signed32((Struct)this);
    }

    public static class ChannelKey
    extends STRUCT {
        public final Struct.Signed32 key = new Struct.Signed32((Struct)this);
        public Struct.Utf8String name = new Struct.Utf8String((Struct)this, 12);
    }

    public static class ChannelList {
        public int length;
        public ChannelKey[] channel;
    }

    public static class DataAddRequest
    extends STRUCT {
        public final Struct.Signed32 numChannels = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 channel = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 stcDelay = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 format = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 sendBuffers = new Struct.Signed32((Struct)this);
    }

    public static class Header
    extends STRUCT {
        public final Struct.Signed32 signature = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 type = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 length = new Struct.Signed32((Struct)this);
    }

    public static class STRUCT
    extends Struct {
        public ByteOrder byteOrder() {
            return ByteOrder.BIG_ENDIAN;
        }

        public boolean isPacked() {
            return true;
        }

        public byte[] toByteArray() throws IOException {
            ByteBuffer bb = this.getByteBuffer();
            byte[] buf = new byte[this.size()];
            int i = 0;
            while (i < buf.length) {
                buf[i] = bb.get(i);
                ++i;
            }
            return buf;
        }

        public String toString() {
            return StructUtil.struct2String(this);
        }
    }
}

