/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.nanometrics;

import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.InternetPacketWrapper;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketFactory;
import ca.nanometrics.packet.PacketWrapper;
import ca.nanometrics.util.NmxDateFormat;
import cn.org.gddsn.util.Log4jConfig;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class NmxpClient {
    static Logger logger;
    private String host;
    private int port = 32000;
    private DatagramSocket socket;
    private PacketWrapper pw = new InternetPacketWrapper();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.nanometrics.NmxpClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
        try {
            this.socket = new DatagramSocket(port);
            this.socket.setSoTimeout(120000);
        }
        catch (SocketException ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public void connect() throws IOException {
        this.socket = new DatagramSocket(this.port);
        this.socket.setSoTimeout(120000);
    }

    public DataPacket getDataPacket() throws IOException {
        NmxPacket np = null;
        while ((np = this.getNmxPacket()) != null && np.getType() != 1) {
        }
        return (DataPacket)np;
    }

    public NmxPacket getNmxPacket() throws IOException {
        NmxPacket nmxp = null;
        try {
            byte[] buf = new byte[1024];
            DatagramPacket rdp = null;
            rdp = new DatagramPacket(buf, buf.length);
            this.socket.receive(rdp);
            byte[] wpkt = rdp.getData();
            nmxp = NmxPacketFactory.makePacket(wpkt, this.pw.getDataOffset(), this.pw.getDataLength(wpkt));
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
            throw ex;
        }
        return nmxp;
    }

    public void close() {
        this.socket.disconnect();
        this.socket.close();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public static void main(String[] args) throws Exception {
        NmxDateFormat ndf = new NmxDateFormat();
        Log4jConfig.loadForMain("NmxpClient.properties");
        NmxpClient client = new NmxpClient();
        client.setHost("10.4.8.60");
        client.setPort(32000);
        FileOutputStream fos = new FileOutputStream("/tmp/nmxp.hex");
        int n = Integer.MAX_VALUE;
        NmxPacket nmxp = null;
        while (n-- != 0) {
            try {
                DataPacket dp;
                nmxp = client.getNmxPacket();
                if (nmxp == null) continue;
                System.out.println(nmxp + ",type=" + nmxp.getType());
                fos.write(nmxp.toBytes());
                if (nmxp.getType() != 1 || (dp = (DataPacket)nmxp).getChannel() != 2) continue;
                System.out.println(String.valueOf(ndf.format(dp.getStartTime())) + ", " + dp.getTimeFraction() + "," + dp.getInstrumentID());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        fos.close();
        client.close();
    }
}

