/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.nanometrics;

import ca.nanometrics.packet.DataPacket;
import cn.org.gddsn.liss.port.ComServPortInf;
import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.LogLostManager;
import cn.org.gddsn.liss.port.MiniSeedStreamEncoder;
import cn.org.gddsn.liss.port.SiteInfo;
import cn.org.gddsn.liss.port.nanometrics.NmxpClient;
import cn.org.gddsn.util.Log4jConfig;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.IOException;
import org.apache.log4j.Logger;

public class NmxpPort
implements ComServPortInf,
DataFrameInput {
    static Logger logger;
    private NmxpClient nmxpClient = null;
    private static final String[] compCode;
    private SiteInfo siteInfo = null;
    private String[] chanDis;
    private int data_type = 9;
    private MiniSeedStreamEncoder msis;
    private LogLostManager logLostManager = new LogLostManager();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.nanometrics.NmxpPort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        compCode = new String[]{"Z", "N", "E"};
    }

    public void open() {
    }

    public boolean prepareProcess() {
        return true;
    }

    public boolean connect() throws IOException {
        this.openComServPort();
        return true;
    }

    public void openComServPort() throws IOException {
        logger.info("close NmxpClient.");
        this.close();
        logger.info("Opening NmxpClient.");
        this.nmxpClient.connect();
        this.msis = new MiniSeedStreamEncoder(this);
        logger.info("Opened NmxpPort.");
    }

    public byte[] readMiniSeedFrame() throws IOException {
        byte[] buf = this.msis.readMiniSeedRecord();
        return buf;
    }

    public void setDataType(int data_type) {
        this.data_type = data_type;
    }

    public void setChannelDiscription(String[] chanDis) {
        this.chanDis = chanDis;
        this.siteInfo = new SiteInfo(chanDis, compCode);
    }

    public void setMaxCompressSamples(int maxSamples) {
        this.msis.setMaxSamplesInMiniSeed(maxSamples);
    }

    public void close() {
        if (this.nmxpClient != null) {
            this.nmxpClient.close();
        }
    }

    public DataFrame[] readDataFrame() throws IOException {
        DataPacket gp = this.nmxpClient.getDataPacket();
        if (gp == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(gp);
        }
        DataFrame[] dfs = new DataFrame[1];
        int nchan = gp.getChannel();
        dfs[0] = new DataFrame();
        dfs[0].time = gp.getLongSeconds();
        dfs[0].ns = (long)gp.getTimeFraction() * 100000L;
        dfs[0].siteID = nchan / 3;
        dfs[0].flag = 0;
        dfs[0].sampRate = gp.getSampleRate();
        dfs[0].data = gp.getSamples();
        dfs[0].setChannelLocator(this.siteInfo.getChannelLocator(dfs[0].siteID, compCode[nchan % 3]));
        if (logger.isDebugEnabled()) {
            logger.debug(dfs[0]);
        }
        if (this.logLostManager != null && dfs != null) {
            int i = 0;
            while (i < dfs.length) {
                LogLostManager.TimeInfo timeInfo = new LogLostManager.TimeInfo();
                timeInfo.date = dfs[i].time * 1000L + dfs[i].ns / 1000000L;
                timeInfo.length = dfs[i].data.length * 1000 / dfs[i].sampRate;
                this.logLostManager.log(dfs[i].getChannelLocator(), timeInfo);
                ++i;
            }
        }
        return dfs;
    }

    public int getDataTpe() {
        return this.data_type;
    }

    public String[] getChannelDiscription() {
        return this.chanDis;
    }

    public void setNmxpClient(NmxpClient nmxpClient) {
        this.nmxpClient = nmxpClient;
    }

    public String getHost() {
        return this.nmxpClient.getHost();
    }

    public int getPort() {
        return this.nmxpClient.getPort();
    }

    public void setLogLostManager(LogLostManager logLostManager) {
        this.logLostManager = logLostManager;
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain("NmxpPort.properties");
        NmxpPort csPort = null;
        String[] cDis = new String[]{"GD/TST/00/BHZ:BHE:BHN"};
        if (args.length < 3) {
            logger.debug("Usage:\n java cn.org.gddsn.liss.port.NmxpPort host port chanDisc");
            System.exit(-1);
        } else {
            NmxpClient client = new NmxpClient();
            client.setHost(args[0]);
            client.setPort(Integer.parseInt(args[1]));
            csPort = new NmxpPort();
            csPort.setNmxpClient(client);
            cDis = new String[args.length - 2];
            int i = 2;
            while (i < args.length) {
                cDis[i - 2] = args[i];
                ++i;
            }
            csPort.setChannelDiscription(cDis);
        }
        try {
            csPort.openComServPort();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        byte[] buf = null;
        while (true) {
            if ((buf = csPort.readMiniSeedFrame()) != null) {
                GenericMiniSeedRecord gmsr = GenericMiniSeedRecord.buildMiniSeedRecord(buf);
                logger.info(gmsr);
                continue;
            }
            logger.error("Could not read one miniseed packet");
        }
    }
}

