/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.q330;

import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.q330.Q330CommInf;
import cn.org.gddsn.liss.port.q330.Q330IOUDP;
import cn.org.gddsn.liss.util.StructUtil;
import cn.org.gddsn.security.Bytes;
import cn.org.gddsn.security.MD5;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import javolution.io.Struct;
import org.apache.log4j.Logger;

public class Q330IO {
    static Logger logger;
    private long serialNum = 72057642979512214L;
    private Q330CommInf q330comm;
    private C1_FIX c1_fix;
    private C1_LOG c1_log;
    private static long JAN_1_2000;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.q330.Q330IO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        JAN_1_2000 = 0L;
        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        c.set(2000, 0, 1, 0, 0, 0);
        JAN_1_2000 = c.getTimeInMillis() / 1000L * 1000L;
    }

    public long getSerialNum() {
        return this.serialNum;
    }

    public void setSerialNum(long serialNum) {
        this.serialNum = serialNum;
    }

    public void setQ330comm(Q330CommInf q330comm) {
        this.q330comm = q330comm;
    }

    public void connect() throws IOException {
        int ack = 0;
        int seq = 0;
        int rcvAck = 0;
        QDP qdpSend = null;
        QDP qdpRcv = null;
        qdpSend = QDP.createC1_RQSRV(this.getSerialNum(), seq, ack);
        qdpRcv = this.q330comm.command(qdpSend);
        C1_SRVCH c1_srvch = (C1_SRVCH)qdpRcv.body;
        rcvAck = qdpRcv.header.ack.get();
        ++ack;
        qdpSend = QDP.createC1_SRVRSP(this.getSerialNum(), ++seq, rcvAck, c1_srvch, new int[2]);
        qdpRcv = this.q330comm.command(qdpSend);
        if (qdpRcv.header.command.get() == 160) {
            C1_CACK c1_cack = (C1_CACK)qdpRcv.body;
            logger.info("auth OK.");
        } else {
            C1_CERR c1_cerr = (C1_CERR)qdpRcv.body;
            logger.info("auth FAILT");
        }
        rcvAck = qdpRcv.header.ack.get();
        ++ack;
        qdpSend = QDP.createC1_RQLOG(++seq, rcvAck, 1);
        qdpRcv = this.q330comm.command(qdpSend);
        if (qdpRcv.header.command.get() == 165) {
            this.c1_log = (C1_LOG)qdpRcv.body;
            logger.info("Got C1_LOG OK.");
        }
        rcvAck = qdpRcv.header.ack.get();
        ++ack;
        qdpSend = QDP.createC1_RQFIX(++seq, rcvAck);
        qdpRcv = this.q330comm.command(qdpSend);
        if (qdpRcv.header.command.get() == 167) {
            this.c1_fix = (C1_FIX)qdpRcv.body;
            logger.info("got C1_FIX OK.");
        }
        rcvAck = qdpRcv.header.ack.get();
        ++ack;
        ++seq;
    }

    public void openDataPort() throws IOException {
        boolean ack = false;
        int seq = 0;
        int rcvAck = 0;
        boolean rcvSeq = false;
        QDP qdpSend = null;
        Object qdpRcv = null;
        qdpSend = QDP.createDT_OPEN(seq, rcvAck);
        this.q330comm.send(qdpSend);
    }

    public DataFrame[] decode(DT_DATA dt_data) {
        DT_13 dt_13 = (DT_13)((Object)dt_data.DT_13_vec.get(0));
        long secOffset = dt_13.secondOffset.get() * 1000L;
        Date date = new Date(JAN_1_2000 + secOffset + dt_data.dataRecordSeq.get() * 1000L);
        logger.info(date);
        return null;
    }

    public int getFilterDelay(int freqIndex, int chan) {
        if (chan < 3) {
            return this.c1_fix.freqDelay[7 - freqIndex].get();
        }
        return this.c1_fix.freqDelay[15 - freqIndex].get();
    }

    public double getSampleRate(int freqIndex) {
        int bitmap = this.c1_fix.freqs[7 - freqIndex].get() & 0xFF;
        if (bitmap < 128) {
            return bitmap;
        }
        if ((bitmap & 0x80) == 128) {
            int b = bitmap & 0xF;
            switch (b) {
                case 4: {
                    return 200.0;
                }
                case 5: {
                    return 250.0;
                }
                case 6: {
                    return 300.0;
                }
                case 7: {
                    return 400.0;
                }
                case 8: {
                    return 500.0;
                }
                case 9: {
                    return 800.0;
                }
                case 10: {
                    return 1000.0;
                }
            }
        } else if (bitmap == 255) {
            return 0.1;
        }
        return -1.0;
    }

    public QDP getData() throws IOException {
        int ack = 0;
        int seq = 0;
        int rcvAck = 0;
        int rcvSeq = 0;
        QDP qdpSend = null;
        QDP qdpRcv = null;
        qdpRcv = this.q330comm.dataReceive();
        if (qdpRcv.header.command.get() == 0) {
            DT_DATA dt_data = (DT_DATA)qdpRcv.body;
            this.decode(dt_data);
        } else if (qdpRcv.header.command.get() == 6) {
            DT_FILL dt_fill = (DT_FILL)qdpRcv.body;
        } else {
            logger.warn("Got unexpeted QDP DATA packet in data port");
        }
        rcvSeq = qdpRcv.header.seq.get();
        rcvAck = qdpRcv.header.ack.get();
        ++ack;
        ++seq;
        int[] ackBitmap = new int[4];
        ackBitmap[0] = 1;
        qdpSend = QDP.createDT_DACK(rcvSeq + 1, rcvSeq, 0, ackBitmap);
        this.q330comm.send(qdpSend);
        return qdpRcv;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(new Date(JAN_1_2000));
        Q330IOUDP q330udp = new Q330IOUDP();
        q330udp.setBasePort(5330);
        q330udp.setHost("192.168.168.241");
        q330udp.setDataPort(0);
        q330udp.connect();
        Q330IO q330 = new Q330IO();
        q330.setQ330comm(q330udp);
        q330.connect();
        q330.openDataPort();
        int N = Integer.MAX_VALUE;
        int i = 0;
        while (i < N) {
            q330.getData();
            ++i;
        }
    }

    public static class Body
    extends Struct {
        public boolean isPacked() {
            return true;
        }

        public byte[] toByteArray() throws IOException {
            byte[] buf = new byte[this.size()];
            System.arraycopy(this.getByteBuffer().array(), 0, buf, 0, buf.length);
            return buf;
        }

        public static Body create() {
            return null;
        }

        public String toString() {
            return StructUtil.struct2String(this);
        }
    }

    public static class C1_CACK
    extends Body {
    }

    public static class C1_CERR
    extends Body {
        public final Struct.Signed16 errCode = new Struct.Signed16((Struct)this);
    }

    public static class C1_DSRV
    extends Body {
        public final Struct.Signed64 sn = new Struct.Signed64((Struct)this);
    }

    public static class C1_FIX
    extends Body {
        public final Struct.Signed32 timeOfLastReboot = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 totalNumberOfReboots = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 backupDataStructBitmap = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 defaultDataStructBitmap = new Struct.Signed32((Struct)this);
        public final Struct.Signed16 calibType = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 calibVersion = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 auxType = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 auxVersion = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 clockType = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 flags = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 systemVersion = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 slaveProcessorVersion = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 pldVersion = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 memBlockSize = new Struct.Signed16((Struct)this);
        public final Struct.Signed32 kmiPropertyTag = new Struct.Signed32((Struct)this);
        public final Struct.Signed64 systemSerial = new Struct.Signed64((Struct)this);
        public final Struct.Signed64 motherBoardSerial = new Struct.Signed64((Struct)this);
        public final Struct.Signed64 seismometer1Serial = new Struct.Signed64((Struct)this);
        public final Struct.Signed64 seismometer2Serial = new Struct.Signed64((Struct)this);
        public final Struct.Signed32 qapchp1Serial = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 internalDataMemSize = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 internalDataMemUsed = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 externalDataMemSize = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 flashMemSize = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 externalDataMemUsed = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 qapchp2Serial = new Struct.Signed32((Struct)this);
        public final Struct.Signed32[] dataPortPacketMemSize = (Struct.Signed32[])this.array((Struct.Member[])new Struct.Signed32[4]);
        public final Struct.Signed8[] freqs = (Struct.Signed8[])this.array((Struct.Member[])new Struct.Signed8[8]);
        public final Struct.Signed32[] freqDelay = (Struct.Signed32[])this.array((Struct.Member[])new Struct.Signed32[16]);
    }

    public static class C1_LOG
    extends Body {
        public final Struct.Signed16 dataPort = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 flags = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 packetBuffer = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 mtu = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 groupCount = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 maxReSendTimout = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 groupTimeout = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 minReSendTimout = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 winSize = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 dataSeq = new Struct.Signed16((Struct)this);
        public final Struct.Signed16[] chanFreqs = (Struct.Signed16[])this.array((Struct.Member[])new Struct.Signed16[6]);
        public final Struct.Signed16 ackCount = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 ackTimeout = new Struct.Signed16((Struct)this);
        public final Struct.Signed32 oldDataThreshholdTime = new Struct.Signed32((Struct)this);
        public final Struct.Signed16 ethernetThrottle = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 alarmPercent = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 autoFilters = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 manualFilters = new Struct.Signed16((Struct)this);
        public final Struct.Signed32 space = new Struct.Signed32((Struct)this);
    }

    public static class C1_RQLOG
    extends Body {
        public final Struct.Signed16 dataPort = new Struct.Signed16((Struct)this);
    }

    public static class C1_RQSRV
    extends Body {
        public final Struct.Signed64 sn = new Struct.Signed64((Struct)this);
    }

    public static class C1_SRVCH
    extends Body {
        public final Struct.Signed64 challenge = new Struct.Signed64((Struct)this);
        public final Struct.Signed32 ipAddress = new Struct.Signed32((Struct)this);
        public final Struct.Signed16 udpPort = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 regNum = new Struct.Signed16((Struct)this);
    }

    public static class C1_SRVRSP
    extends Body {
        public final Struct.Signed64 sn = new Struct.Signed64((Struct)this);
        public final Struct.Signed64 challenge = new Struct.Signed64((Struct)this);
        public final Struct.Signed32 ipAddress = new Struct.Signed32((Struct)this);
        public final Struct.Signed16 udpPort = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 regNum = new Struct.Signed16((Struct)this);
        public final Struct.Signed64 random = new Struct.Signed64((Struct)this);
        public final Struct.Signed8[] md5 = (Struct.Signed8[])this.array((Struct.Member[])new Struct.Signed8[16]);
    }

    public static class CRC {
        private static int CRC_POLYNOM = 1443300200;
        private static int[] crcTable = new int[256];

        static {
            int count = 0;
            while (count < 256) {
                int tdata = count << 24;
                int accum = 0;
                int bits = 1;
                while (bits <= 8) {
                    accum = (tdata ^ accum) < 0 ? accum << 1 ^ CRC_POLYNOM : (accum <<= 1);
                    tdata <<= 1;
                    ++bits;
                }
                CRC.crcTable[count] = accum;
                ++count;
            }
        }

        public static int crc(byte[] b, int idx, int len) {
            int crc = 0;
            int i = idx;
            while (len-- > 0) {
                int temp = (crc >>> 24 ^ b[i++]) & 0xFF;
                crc <<= 8;
                crc ^= crcTable[temp];
            }
            return crc;
        }

        public static void main(String[] args) {
            int crc = 283067560;
            int[] nArray = new int[16];
            nArray[0] = 16;
            nArray[1] = 2;
            nArray[3] = 8;
            nArray[8] = 1;
            nArray[11] = 11;
            nArray[12] = 101;
            nArray[13] = 37;
            nArray[14] = 79;
            nArray[15] = 150;
            int[] b = nArray;
            byte[] buf = new byte[b.length];
            int i = 0;
            while (i < buf.length) {
                buf[i] = (byte)b[i];
                ++i;
            }
            int v = CRC.crc(buf, 0, 16);
            if (v == crc) {
                System.out.println("OK");
            } else {
                System.out.println("FAILT");
            }
        }
    }

    public static class DT_00
    extends Body {
        public final Struct.Unsigned8[] b8 = (Struct.Unsigned8[])this.array((Struct.Member[])new Struct.Unsigned8[3]);
    }

    public static class DT_01
    extends Body {
        public final Struct.Unsigned8 b8 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 b16 = new Struct.Unsigned16((Struct)this);
    }

    public static class DT_02
    extends Body {
        public final Struct.Unsigned8 b8 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 b16 = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned32 b32 = new Struct.Unsigned32((Struct)this);
    }

    public static class DT_03
    extends Body {
        public final Struct.Unsigned8 b8 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 b16 = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned32[] b32 = (Struct.Unsigned32[])this.array((Struct.Member[])new Struct.Unsigned32[2]);
    }

    public static class DT_10
    extends Body {
        public final Struct.Unsigned8[] b8 = (Struct.Unsigned8[])this.array((Struct.Member[])new Struct.Unsigned8[3]);
    }

    public static class DT_11
    extends Body {
        public final Struct.Unsigned8 b8 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 b16 = new Struct.Unsigned16((Struct)this);
    }

    public static class DT_12
    extends Body {
        public final Struct.Unsigned8 b8 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 b16 = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned32 b32 = new Struct.Unsigned32((Struct)this);
    }

    public static class DT_13
    extends Body {
        public final Struct.Unsigned8 clockQuality = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 gpsLostInMin = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned32 secondOffset = new Struct.Unsigned32((Struct)this);
        public final Struct.Unsigned32 usec = new Struct.Unsigned32((Struct)this);
    }

    public static class DT_14
    extends Body {
        public final Struct.Unsigned8[] b8 = (Struct.Unsigned8[])this.array((Struct.Member[])new Struct.Unsigned8[3]);
    }

    public static class DT_15
    extends Body {
        public final Struct.Unsigned8 b8 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 b16 = new Struct.Unsigned16((Struct)this);
    }

    public static class DT_16
    extends Body {
        public final Struct.Unsigned8 b8 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 b16 = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned32 b32 = new Struct.Unsigned32((Struct)this);
    }

    public static class DT_17
    extends Body {
        public final Struct.Unsigned8 b8 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 b16 = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned32[] b32 = (Struct.Unsigned32[])this.array((Struct.Member[])new Struct.Unsigned32[2]);
    }

    public static class DT_18
    extends Body {
        public final Struct.Unsigned8[] b8 = (Struct.Unsigned8[])this.array((Struct.Member[])new Struct.Unsigned8[3]);
    }

    public static class DT_19
    extends Body {
        public final Struct.Unsigned8 b8 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 b16 = new Struct.Unsigned16((Struct)this);
    }

    public static class DT_1A
    extends Body {
        public final Struct.Unsigned8 b8 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16[] b16 = (Struct.Unsigned16[])this.array((Struct.Member[])new Struct.Unsigned16[3]);
    }

    public static class DT_1C
    extends Body {
        public final Struct.Unsigned8 b8 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 b16 = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned32 b32 = new Struct.Unsigned32((Struct)this);
    }

    public static class DT_1D
    extends Body {
        public final Struct.Unsigned8 freq = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 blockSize = new Struct.Unsigned16((Struct)this);
        public final Struct.Signed32 preSamp = new Struct.Signed32((Struct)this);
        public final Struct.Signed16 offset = new Struct.Signed16((Struct)this);
        public byte[] flag;
        public byte[] data;

        public void parse(DataInputStream di) throws IOException {
            short n = this.offset.get();
            this.flag = new byte[n - 2];
            di.readFully(this.flag);
            this.data = new byte[this.blockSize.get()];
            di.readFully(this.data);
        }
    }

    public static class DT_1E
    extends Body {
        public final Struct.Unsigned8 freq = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 blockSize = new Struct.Unsigned16((Struct)this);
        public byte[] data;

        public void parse(DataInputStream di) throws IOException {
            this.data = new byte[this.blockSize.get()];
            di.readFully(this.data);
        }
    }

    public static class DT_1F
    extends Body {
    }

    public static class DT_DACK
    extends Body {
        public final Struct.Signed16 newThrottlValue = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 space1 = new Struct.Signed16((Struct)this);
        public final Struct.Signed32[] ackBitmap = (Struct.Signed32[])this.array((Struct.Member[])new Struct.Signed32[4]);
        public final Struct.Signed32 space2 = new Struct.Signed32((Struct)this);
    }

    public static class DT_DATA
    extends Body {
        public final Struct.Unsigned32 dataRecordSeq = new Struct.Unsigned32((Struct)this);
        public byte[] data = null;
        public Vector DT_13_vec = new Vector();
        public Vector DT_1D_vec = new Vector();
        public Vector DT_1E_vec = new Vector();

        public void parse(DataInputStream di) throws IOException {
            Body block = null;
            while (di.available() > 0) {
                int chn = di.read() & 0xFF;
                if (logger.isDebugEnabled()) {
                    logger.debug("channel: " + Integer.toBinaryString(chn));
                }
                if (chn >>> 5 == 0) {
                    block = new DT_00();
                    block.readFully(di);
                } else if (chn >>> 5 == 1) {
                    block = new DT_01();
                    block.readFully(di);
                } else if (chn >>> 5 == 2) {
                    block = new DT_02();
                    block.readFully(di);
                } else if (chn >>> 5 == 3) {
                    block = new DT_03();
                    block.readFully(di);
                } else if (chn >>> 3 == 16) {
                    block = new DT_10();
                    block.readFully(di);
                } else if (chn >>> 3 == 17) {
                    block = new DT_11();
                    block.readFully(di);
                } else if (chn >>> 3 == 18) {
                    block = new DT_12();
                    block.readFully(di);
                } else if (chn >>> 3 == 19) {
                    block = new DT_13();
                    block.readFully(di);
                    this.DT_13_vec.add(block);
                } else if (chn >>> 3 == 20) {
                    block = new DT_14();
                    block.readFully(di);
                } else if (chn >>> 3 == 21) {
                    block = new DT_15();
                    block.readFully(di);
                } else if (chn >>> 3 == 22) {
                    block = new DT_16();
                    block.readFully(di);
                } else if (chn >>> 3 == 23) {
                    block = new DT_17();
                    block.readFully(di);
                } else if (chn >>> 3 == 24) {
                    block = new DT_18();
                    block.readFully(di);
                } else if (chn >>> 3 == 25) {
                    block = new DT_19();
                    block.readFully(di);
                } else if (chn >>> 3 == 26) {
                    block = new DT_1A();
                    block.readFully(di);
                } else if (chn >>> 3 == 28) {
                    block = new DT_1C();
                    block.readFully(di);
                } else if (chn >>> 3 == 29) {
                    DT_1D blk = new DT_1D();
                    blk.readFully(di);
                    blk.parse(di);
                    block = blk;
                    this.DT_1D_vec.add(block);
                } else if (chn >>> 3 == 30) {
                    DT_1E blk = new DT_1E();
                    blk.readFully(di);
                    blk.parse(di);
                    block = blk;
                    this.DT_1E_vec.add(block);
                } else if (chn >>> 3 == 31) {
                    int blkSize;
                    if ((chn & 7) == 0) {
                        byte[] b = new byte[28];
                        di.readFully(b);
                    } else if ((chn & 7) == 1) {
                        byte[] b = new byte[8];
                        di.readFully(b);
                    } else if ((chn & 7) == 2) {
                        int blkFlags = di.read();
                        blkSize = di.readUnsignedShort();
                        int port = di.read();
                        int unitIaD = di.read();
                        int status = di.read();
                        int msgType = di.read();
                        byte[] b = new byte[blkSize];
                        di.readFully(b);
                    } else if ((chn & 7) == 3) {
                        int subType = di.read();
                        blkSize = di.readShort();
                        byte[] b = new byte[blkSize];
                        di.readFully(b);
                    }
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("data block: " + (Object)((Object)block));
            }
        }
    }

    public static class DT_FILL
    extends Body {
    }

    public static class DT_OPEN
    extends Body {
    }

    public static class Header
    extends Struct {
        public static final int DT_DATA = 0;
        public static final int DT_FILL = 6;
        public static final int DT_DACK = 10;
        public static final int DT_OPEN = 11;
        public static final int C1_RQSRV = 16;
        public static final int C1_SRVRSP = 17;
        public static final int C1_DSRV = 18;
        public static final int C1_SAUTH = 19;
        public static final int C1_POLLSN = 20;
        public static final int C1_SPHY = 21;
        public static final int C1_QRPHY = 22;
        public static final int C1_SLOG = 23;
        public static final int C1_RQLOG = 24;
        public static final int C1_CTL = 25;
        public static final int C1_RQFIX = 28;
        public static final int C1_CACK = 160;
        public static final int C1_SRVCH = 161;
        public static final int C1_CERR = 162;
        public static final int C1_MYSN = 163;
        public static final int C1_PHY = 164;
        public static final int C1_LOG = 165;
        public static final int C1_FIX = 167;
        public final Struct.Signed32 crc = new Struct.Signed32((Struct)this);
        public final Struct.Unsigned8 command = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 ver = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 length = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 seq = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 ack = new Struct.Unsigned16((Struct)this);

        public String toString() {
            return "crc=" + Integer.toHexString(this.crc.get()) + "/command=" + Integer.toHexString(this.command.get()) + "/ver=" + Integer.toHexString(this.ver.get()) + "/seq=" + Integer.toHexString(this.seq.get()) + "/ack=" + Integer.toHexString(this.ack.get());
        }
    }

    public static class QDP
    extends Struct {
        public final Header header = (Header)this.inner(new Header());
        public Body body = null;

        public boolean isPacked() {
            return true;
        }

        public byte[] toByteArray() {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.header.write(baos);
                if (this.header.command.get() == 0) {
                    DT_DATA bd = (DT_DATA)this.body;
                    baos.write(bd.data);
                } else if (this.body != null) {
                    baos.write(this.body.toByteArray());
                }
                return baos.toByteArray();
            }
            catch (IOException ioEx) {
                logger.warn(ioEx.getMessage(), ioEx);
                return null;
            }
        }

        public String toString() {
            String buf = "\n\tHeader: " + (Object)((Object)this.header) + "\n";
            if (this.body != null) {
                try {
                    buf = String.valueOf(buf) + "\tBody(Hex): " + Bytes.toString(this.body.toByteArray()) + "\n";
                }
                catch (IOException ioEx) {
                    logger.warn(ioEx.getMessage(), ioEx);
                }
                buf = String.valueOf(buf) + "\tBody: " + this.body.toString() + "\n";
            }
            return buf;
        }

        public boolean checkCRC() {
            byte[] buf = this.toByteArray();
            int calcCRC = CRC.crc(buf, 4, buf.length - 4);
            return calcCRC == this.header.crc.get();
        }

        public void fillCRC() {
            byte[] buf = this.toByteArray();
            this.header.crc.set(CRC.crc(buf, 4, buf.length - 4));
        }

        public static QDP create(byte[] buf) throws IOException {
            Body bd;
            QDP qdp = new QDP();
            DataInputStream di = new DataInputStream(new ByteArrayInputStream(buf));
            qdp.header.readFully(di);
            short command = qdp.header.command.get();
            if (command == 0) {
                bd = new DT_DATA();
                bd.data = new byte[qdp.header.length.get()];
                System.arraycopy(buf, qdp.header.size(), bd.data, 0, bd.data.length);
                qdp.body = bd;
            } else if (command == 6) {
                bd = new DT_FILL();
                qdp.body = null;
            } else if (command == 160) {
                bd = new C1_CACK();
                qdp.body = null;
            } else if (command == 161) {
                bd = new C1_SRVCH();
                qdp.body = bd;
            } else if (command == 162) {
                bd = new C1_CERR();
                qdp.body = bd;
            } else if (command == 165) {
                bd = new C1_LOG();
                qdp.body = bd;
            } else if (command == 167) {
                bd = new C1_FIX();
                qdp.body = bd;
            }
            if (qdp.body != null) {
                qdp.body.readFully(di);
            }
            if (command == 0) {
                bd = (DT_DATA)qdp.body;
                bd.parse(di);
            }
            di.close();
            if (qdp.checkCRC()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Got QDP: " + (Object)((Object)qdp));
                }
                return qdp;
            }
            logger.warn("Got CRC error packet: " + (Object)((Object)qdp));
            return qdp;
        }

        public static QDP create(Body bd, int command, int seq, int ack) {
            QDP qdp = new QDP();
            qdp.body = bd;
            qdp.header.command.set((short)command);
            qdp.header.ver.set((short)2);
            if (bd != null) {
                qdp.header.length.set((int)((short)bd.size()));
            } else {
                qdp.header.length.set(0);
            }
            qdp.header.seq.set((int)((short)seq));
            qdp.header.ack.set((int)((short)ack));
            qdp.fillCRC();
            if (logger.isDebugEnabled()) {
                logger.debug("build QDP: " + (Object)((Object)qdp));
            }
            return qdp;
        }

        public static QDP createDT_DACK(int seq, int ack, int newThrottleValue, int[] ackBitmap) {
            DT_DACK bd = new DT_DACK();
            bd.newThrottlValue.set((short)newThrottleValue);
            int i = 0;
            while (i < bd.ackBitmap.length) {
                bd.ackBitmap[i].set((int)((short)ackBitmap[i]));
                ++i;
            }
            return QDP.create(bd, 10, seq, ack);
        }

        public static QDP createDT_OPEN(int seq, int ack) {
            return QDP.create(null, 11, seq, ack);
        }

        public static QDP createC1_RQSRV(long sn, int seq, int ack) {
            C1_RQSRV bd = new C1_RQSRV();
            bd.sn.set(sn);
            return QDP.create(bd, 16, seq, ack);
        }

        public static QDP createC1_SRVRSP(long sn, int seq, int ack, C1_SRVCH c1, int[] auth) {
            C1_SRVRSP bd = new C1_SRVRSP();
            bd.sn.set(sn);
            bd.challenge.set(c1.challenge.get());
            bd.ipAddress.set(c1.ipAddress.get());
            bd.udpPort.set(c1.udpPort.get());
            bd.regNum.set(c1.regNum.get());
            try {
                ByteArrayOutputStream bao = new ByteArrayOutputStream(64);
                DataOutputStream dos = new DataOutputStream(bao);
                dos.writeLong(bd.challenge.get());
                dos.writeInt(bd.ipAddress.get());
                dos.writeShort(bd.udpPort.get() & 0xFFFF);
                dos.writeShort(bd.regNum.get() & 0xFFFF);
                int i = 0;
                while (i < auth.length) {
                    dos.writeInt(auth[i]);
                    ++i;
                }
                dos.writeLong(sn);
                long ran = 0L;
                int i2 = 0;
                while (i2 < 8) {
                    int a = (int)(Math.random() * 255.0);
                    dos.write(a);
                    ran <<= 8;
                    ran += (long)a;
                    ++i2;
                }
                bd.random.set(ran);
                dos.close();
                MD5 md5 = new MD5();
                byte[] r = md5.digest(Bytes.toLowString(bao.toByteArray()).getBytes());
                int i3 = 0;
                while (i3 < r.length) {
                    bd.md5[i3].set(r[i3]);
                    ++i3;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("challenge msg: " + Bytes.toLowString(bao.toByteArray()));
                    logger.debug("md5: " + Bytes.toLowString(r));
                }
            }
            catch (IOException ioEx) {
                logger.warn(ioEx.getMessage(), ioEx);
            }
            return QDP.create(bd, 17, seq, ack);
        }

        public static QDP createC1_DSRV(long sn, int seq, int ack) {
            C1_DSRV bd = new C1_DSRV();
            bd.sn.set(sn);
            return QDP.create(bd, 18, seq, ack);
        }

        public static QDP createC1_RQLOG(int seq, int ack, int dataPort) {
            C1_RQLOG bd = new C1_RQLOG();
            bd.dataPort.set((short)dataPort);
            return QDP.create(bd, 24, seq, ack);
        }

        public static QDP createC1_RQFIX(int seq, int ack) {
            return QDP.create(null, 28, seq, ack);
        }
    }
}

