/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.seedlink;

import cn.org.gddsn.util.Log4jConfig;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SeedlinkClient {
    static Logger logger;
    private static final String EOL = "\n";
    private static final String SL_CMD_HELLO = "HELLO";
    private static final String SL_CMD_TIME = "TIME";
    private static final String SL_CMD_FETCH = "FETCH";
    private static final String SL_CMD_INFO = "INFO";
    private static final String SL_CMD_DATA = "DATA";
    private static final String SL_CMD_END = "END";
    private static final String SL_CMD_SELECT = "SELECT";
    private static final String SL_CMD_STATION = "STATION";
    private static final String SL_MSG_OK = "OK";
    private static final String SL_MSG_SIGNATURE = "SL";
    private static final String SL_MSG_INFO = "SLINFO  ";
    private static final String SL_MSG_ERROR = "ERROR";
    private boolean connectionOK = false;
    private String host;
    private int port;
    private Socket socket = null;
    private DataInputStream reader = null;
    private PrintWriter writer = null;
    private int timeout = 120000;
    private String selector = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.seedlink.SeedlinkClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public SeedlinkClient() {
    }

    public SeedlinkClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void connect() throws IOException {
        this.socket = new Socket(this.host, this.port);
        this.socket.setKeepAlive(true);
        this.socket.setSoTimeout(this.timeout);
        this.reader = new DataInputStream(this.socket.getInputStream());
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.socket.getOutputStream()), true);
        this.connectionOK = true;
    }

    public void close() throws IOException {
        this.connectionOK = false;
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
        this.reader = null;
        this.writer = null;
        this.socket = null;
    }

    public void requestData(String selector, Stream[] streams) throws IOException {
        this.setSelector(selector);
        try {
            this.hello();
            int i = 0;
            while (i < streams.length) {
                StringTokenizer st;
                if (streams[i].selector == null) {
                    try {
                        this.addStream(streams[i].net, streams[i].station);
                    }
                    catch (SLException sle) {
                        logger.warn(String.valueOf(sle.getMessage()) + ", ignore!");
                    }
                    if (selector != null) {
                        st = new StringTokenizer(selector);
                        while (st.hasMoreTokens()) {
                            try {
                                this.sendSelector(st.nextToken());
                            }
                            catch (SLException sle) {
                                logger.warn(String.valueOf(sle.getMessage()) + ", ignore!");
                            }
                        }
                    }
                } else {
                    try {
                        this.addStream(streams[i].net, streams[i].station);
                    }
                    catch (SLException sle) {
                        logger.warn(String.valueOf(sle.getMessage()) + ", ignore!");
                    }
                    st = new StringTokenizer(streams[i].selector);
                    while (st.hasMoreTokens()) {
                        try {
                            this.sendSelector(st.nextToken());
                        }
                        catch (SLException sle) {
                            logger.warn(String.valueOf(sle.getMessage()) + ", ignore!");
                        }
                    }
                }
                this.requestData();
                ++i;
            }
            this.end();
        }
        catch (SLException slEx) {
            logger.warn("Seedlink command Error", slEx);
        }
    }

    public void sendCommand(String cmd) throws IOException {
        String fullCmd = String.valueOf(cmd) + EOL;
        if (logger.isDebugEnabled()) {
            logger.debug("Send command: " + fullCmd);
        }
        this.writer.write(fullCmd);
        this.writer.flush();
    }

    private String receiveResponseLine() throws IOException {
        String line = this.reader.readLine();
        if (logger.isDebugEnabled()) {
            logger.debug("received line: " + line);
        }
        return line;
    }

    public void hello() throws IOException, SLException {
        this.sendCommand(SL_CMD_HELLO);
        String line = this.receiveResponseLine();
        if (line == null) {
            throw new IOException("Socket EOF");
        }
        line = this.receiveResponseLine();
        if (line == null) {
            throw new IOException("Socket EOF");
        }
    }

    public void sendSelector(String sel) throws IOException, SLException {
        if (sel == null) {
            return;
        }
        this.sendCommand("SELECT " + sel);
        String line = this.receiveResponseLine();
        if (line == null) {
            throw new IOException("Socket EOF");
        }
        if (!line.trim().equals(SL_MSG_OK)) {
            throw new SLException("Seedlink command error: command=SELECT, selector=" + sel);
        }
    }

    public void addStream(String net, String station) throws IOException, SLException {
        this.sendCommand("STATION " + station + " " + net);
        String line = this.receiveResponseLine();
        if (line == null) {
            throw new IOException("Socket EOF");
        }
        if (!line.trim().equals(SL_MSG_OK)) {
            throw new SLException("Seedlink command error: command=STATION, station=" + net + "/" + station);
        }
    }

    public void requestData() throws IOException, SLException {
        this.sendCommand(SL_CMD_DATA);
        String line = this.receiveResponseLine();
        if (line == null) {
            throw new IOException("Socket EOF");
        }
        if (!line.trim().equals(SL_MSG_OK)) {
            throw new SLException("Seedlink command error: command=DATA");
        }
    }

    public void requestInfo(String level) throws IOException, SLException {
        this.sendCommand("INFO " + level);
        String line = this.receiveResponseLine();
        if (line == null) {
            throw new IOException("Socket EOF");
        }
        if (!line.trim().equals(SL_MSG_OK)) {
            throw new SLException("Seedlink command error: command=INFO, level=" + level);
        }
    }

    public void requestTime(Date beg, Date end) throws IOException, SLException {
        String cmd = "TIME " + beg;
        if (end != null) {
            cmd = String.valueOf(cmd) + " " + end;
        }
        this.sendCommand(cmd);
        String line = this.receiveResponseLine();
        if (line == null) {
            throw new IOException("Socket EOF");
        }
        if (!line.trim().equals(SL_MSG_OK)) {
            throw new SLException("Seedlink command error: command=TIME");
        }
    }

    public void end() throws IOException, SLException {
        this.sendCommand(SL_CMD_END);
    }

    public String getSelector() {
        return this.selector;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public SLPacket getSLpacket() throws IOException {
        byte[] header = new byte[8];
        this.reader.readFully(header);
        byte[] buf = new byte[512];
        this.reader.readFully(buf);
        return new SLPacket(new String(header), buf);
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain("SeedlinkClient.properties");
        SeedlinkClient client = new SeedlinkClient("rtserve.iris.washington.edu", 18000);
        client.connect();
        Stream[] streams = new Stream[2];
        streams[0] = new Stream();
        streams[0].net = "AK";
        streams[0].station = "FIB";
        streams[0].selector = "BHE";
        streams[1] = new Stream();
        streams[1].net = "IA";
        streams[1].station = "TSI";
        streams[1].selector = "SHZ SHE";
        String selector = "BHZ";
        client.requestData(selector, streams);
        while (true) {
            SLPacket pkg = client.getSLpacket();
            GenericMiniSeedRecord gmsr = pkg.getMiniSeedRecord();
            logger.info(gmsr);
        }
    }

    public boolean isConnectionOK() {
        return this.connectionOK;
    }

    public static class SLException
    extends Exception {
        public SLException(String message) {
            super(message);
        }
    }

    public static class SLPacket {
        private String header = null;
        private byte[] data = null;

        public SLPacket(String header, byte[] data) {
            this.header = header;
            this.data = data;
        }

        public String getHeader() {
            return this.header;
        }

        public byte[] getData() {
            return this.data;
        }

        public GenericMiniSeedRecord getMiniSeedRecord() {
            if (this.header.startsWith(SeedlinkClient.SL_MSG_SIGNATURE) && !this.header.equals(SeedlinkClient.SL_MSG_INFO)) {
                return GenericMiniSeedRecord.buildMiniSeedRecord(this.data);
            }
            return null;
        }
    }

    public static class Stream {
        public String net;
        public String station;
        public String selector;
    }
}

