/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.sss;

import cn.org.gddsn.liss.client.LissClient;
import cn.org.gddsn.liss.client.LissException;
import cn.org.gddsn.liss.client.LissTransferType;
import cn.org.gddsn.liss.port.MiniSeedPort;
import cn.org.gddsn.util.Log4jConfig;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class SSSPort
extends MiniSeedPort {
    static Logger logger;
    private LissClient lissClient = null;
    private String user;
    private String passwd;
    private String chanMask;
    private String[] stationCode;
    private boolean reload = false;
    private Date startTime = null;
    private int second = 3600;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.sss.SSSPort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public SSSPort() {
    }

    public SSSPort(String newServerName, int newSeedPort, String user, String passwd, String chanMask, String[] stnCode) {
        super(newServerName, newSeedPort);
        this.user = user;
        this.passwd = passwd;
        this.chanMask = chanMask;
        this.stationCode = stnCode;
        this.thisPort = this;
        this.lissClient = new LissClient();
        this.lissClient.setHost(newServerName);
        this.lissClient.setPort(newSeedPort);
        this.lissClient.setUser(this.user);
        this.lissClient.setPassword(this.passwd);
        super.sendMiniSeedData();
    }

    public SSSPort(String newServerName, int newSeedPort, String user, String passwd, String[] stnCode) {
        this(newServerName, newSeedPort, user, passwd, "", stnCode);
    }

    public void setChanMask(String chanMask) {
        this.chanMask = chanMask;
    }

    public String getChanMask() {
        return this.chanMask;
    }

    public String[] getStationCode() {
        return this.stationCode;
    }

    public LissClient getLissClient() {
        return this.lissClient;
    }

    public void setStationCode(String[] stationCode) {
        this.stationCode = stationCode;
    }

    public void setLissClient(LissClient lissClient) {
        this.lissClient = lissClient;
        this.host = lissClient.getHost();
        this.port = lissClient.getPort();
    }

    public void closePort() {
        super.closePort();
        try {
            if (this.lissClient != null) {
                this.lissClient.quit();
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
        catch (LissException clEx) {
            logger.warn(clEx.getMessage(), clEx);
        }
    }

    public boolean connectServer() {
        logger.info("Connecting Server...");
        try {
            try {
                if (this.lissClient != null) {
                    this.lissClient.quit();
                }
            }
            catch (IOException ioEx) {
                logger.warn(ioEx.getMessage(), ioEx);
            }
            catch (LissException clEx) {
                logger.warn(clEx.getMessage(), clEx);
            }
            this.thisPort = this;
            this.lissClient.connect();
            this.lissClient.setType(LissTransferType.BINARY);
            this.lissClient.setRtServerPassiveMode(true);
            this.receiveFromLISS = this.lissClient.retrieveRealTimeStream(this.chanMask, this.stationCode);
            if (this.reload) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date from = new Date(System.currentTimeMillis() - (long)this.second * 1000L);
                this.lissClient.getMiniSeedBufferRT(this.stationCode, sdf.format(from), this.second);
            }
        }
        catch (LissException lissEx) {
            logger.warn(lissEx.getMessage(), lissEx);
            return false;
        }
        catch (UnknownHostException uhEx) {
            logger.warn("Unknown host " + this.host + " : " + uhEx);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        catch (InterruptedIOException iioEx) {
            logger.warn("InterruptedIOException: " + iioEx, iioEx);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        catch (IOException ioEx) {
            logger.warn("Failed I/O to " + this.host + " : " + ioEx, ioEx);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        logger.info("Connected Server");
        return true;
    }

    public static void main(String[] args) {
        Log4jConfig.loadForMain("CLissRTPort.properties");
        String[] stnCode = new String[]{"*"};
        SSSPort CLissRTPort1 = new SSSPort("localhost", 5000, "root", "netseis", stnCode);
        CLissRTPort1.hashCode();
    }

    public boolean isReload() {
        return this.reload;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        this.second = second;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }
}

