/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.tde;

import cn.org.gddsn.liss.port.tde.TDEStreamData;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class TDE324IO {
    static Logger logger;
    private final String WELCOME = "Connect To TDE-324CI\u0000";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.tde.TDE324IO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public void login(String password, DataInputStream is, OutputStream os) throws IOException, TDE324IOException {
        String revStr;
        os.write("Connect To TDE-324CI\u0000".getBytes());
        if (logger.isDebugEnabled()) {
            logger.debug("Send To TDE-324CIConnect To TDE-324CI\u0000");
        }
        if (!(revStr = TDE324IO.readACK(is)).startsWith("DATA RECEIVE")) {
            throw new TDE324IOException(revStr);
        }
        logger.info("Received:" + revStr);
        os.write(password.getBytes());
        if (logger.isDebugEnabled()) {
            logger.debug("Send PassWord To TDE-324CI" + password);
        }
        if (!(revStr = TDE324IO.readACK(is)).startsWith("CONNECT OK!")) {
            throw new TDE324IOException(revStr);
        }
        logger.info("login in TDE324CI");
    }

    private static String readACK(DataInputStream is) throws IOException {
        byte[] buf = new byte[2048];
        int nbyte = is.read(buf);
        if (nbyte == -1) {
            logger.warn("Reach EOF while reading data from TDE-324CI");
            throw new EOFException("Reach EOF while reading data from TDE-324CI");
        }
        String recStr = new String(buf, 0, nbyte);
        if (logger.isDebugEnabled()) {
            logger.debug("Receive" + recStr + "from TDE-324CI");
        }
        return recStr;
    }

    public TDEStreamData.STHEAD getSteim2packet(int dataCt, int[] samples, DataInputStream dis, OutputStream dos) throws IOException, TDE324IOException {
        int numSamples = 0;
        int k = 0;
        TDEStreamData.STHEAD header = new TDEStreamData.STHEAD();
        TDEStreamData tdeStream = new TDEStreamData();
        header = tdeStream.getSteim2header(dis, dos, dataCt);
        if (logger.isDebugEnabled()) {
            header.decodeSteim2Header();
        }
        int[] steim2Data = tdeStream.getSteim2Data(dis);
        try {
            numSamples = tdeStream.decodeSteim2Data(steim2Data, samples);
        }
        catch (TDEStreamData.SteimException ex) {
            throw new TDE324IOException(ex.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("decode seismic samples number:" + numSamples);
            System.out.println();
            k = 0;
            int i = 0;
            while (i < numSamples) {
                System.out.print(String.valueOf(samples[i]) + " ");
                if (++k == 10) {
                    System.out.println();
                    k = 0;
                }
                ++i;
            }
        }
        if (numSamples != header.getSamplesNum()) {
            logger.warn("header.getSamplesNum !=  tdeStream.decodeSteim2Data numSamples");
        }
        return header;
    }

    public int obtainSeismicData(int[] seismicData, DataInputStream dis, OutputStream dos) throws IOException, TDE324IOException {
        int numSamples = 0;
        int k = 0;
        int dataCt = 0;
        int n = Integer.MAX_VALUE;
        while (n-- > 0) {
            TDEStreamData.STHEAD header = new TDEStreamData.STHEAD();
            TDEStreamData tdeStream = new TDEStreamData();
            header = tdeStream.getSteim2header(dis, dos, dataCt);
            int[] steim2Data = tdeStream.getSteim2Data(dis);
            try {
                numSamples = tdeStream.decodeSteim2Data(steim2Data, seismicData);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (logger.isDebugEnabled()) {
                header.decodeSteim2Header();
                logger.debug("decode seismic samples number:" + numSamples);
                System.out.println();
                k = 0;
                int i = 0;
                while (i < numSamples) {
                    System.out.print(String.valueOf(seismicData[i]) + " ");
                    if (++k == 10) {
                        System.out.println();
                        k = 0;
                    }
                    ++i;
                }
            }
            dataCt = (int)(header.dataCt.get() + 1L & 0xFFFFFFFFL);
        }
        return numSamples;
    }

    public static void main(String[] args) throws IOException {
        String host = "192.168.168.148";
        int port = 9742;
        TDE324IO tde324io = new TDE324IO();
        PropertyConfigurator.configureAndWatch("log4j.properties");
        Socket socket = new Socket(host, port);
        logger.info("Connected" + host + ":" + port);
        socket.setSoTimeout(180000);
        DataInputStream dis = new DataInputStream(socket.getInputStream());
        OutputStream dos = socket.getOutputStream();
        int[] seismicData = new int[1000];
        try {
            tde324io.login("123456", dis, dos);
        }
        catch (TDE324IOException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        try {
            tde324io.obtainSeismicData(seismicData, dis, dos);
        }
        catch (TDE324IOException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        dis.close();
        dos.close();
        socket.close();
    }

    public static class TDE324IOException
    extends Exception {
        private static final long serialVersionUID = -2071476028888834216L;

        public TDE324IOException() {
        }

        public TDE324IOException(String s) {
            super(s);
        }
    }
}

