/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.tde;

import cn.org.gddsn.liss.port.ComServPortInf;
import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.LogLostManager;
import cn.org.gddsn.liss.port.MiniSeedStreamEncoder;
import cn.org.gddsn.liss.port.tde.TDE324IO;
import cn.org.gddsn.liss.port.tde.TDEClient;
import cn.org.gddsn.liss.port.tde.TDEStreamData;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.util.Log4jConfig;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TDEServPort
implements DataFrameInput,
ComServPortInf {
    static Logger logger;
    private int data_type = 8;
    String host;
    int port;
    String user;
    String password;
    private TDEClient client;
    private int[] samples = new int[8192];
    private MiniSeedStreamEncoder msis;
    private LogLostManager logLostManager = new LogLostManager();
    private int lastDataCt;
    private boolean retransmit = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.tde.TDEServPort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public TDEServPort(String edasServName, int edasServPort, String password) {
        this.host = edasServName;
        this.port = edasServPort;
        this.password = password;
    }

    public boolean prepareProcess() throws IOException {
        return true;
    }

    public boolean connect() throws IOException {
        boolean bvalue = false;
        logger.info("Opening TDEServPort.");
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException ioEx) {
            logger.error("IOException: " + ioEx.getMessage());
        }
        try {
            this.client = null;
            this.msis = null;
            this.client = new TDEClient();
            this.client.setHost(this.host);
            this.client.setPort(this.port);
            this.client.setPassword(this.password);
            this.client.connect();
            if (this.retransmit) {
                logger.info("Retransmit data, lastDataCt=" + this.lastDataCt);
                this.client.setDataCt(this.lastDataCt);
            }
        }
        catch (TDE324IO.TDE324IOException ex) {
            logger.error("TDE324IOException: " + ex.getMessage());
            throw new IOException(ex.getMessage());
        }
        this.msis = new MiniSeedStreamEncoder(this);
        logger.info("Opened TDEServPort.");
        bvalue = true;
        return bvalue;
    }

    public void openComServPort() throws IOException {
        this.connect();
    }

    public void close() {
        try {
            this.closeComServPort();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    public void closeComServPort() throws IOException {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException ioEx) {
            logger.error("IOException: " + ioEx.getMessage());
        }
    }

    public byte[] readMiniSeedFrame() throws IOException {
        byte[] buf = this.msis.readMiniSeedRecord();
        return buf;
    }

    public void setDataType(int data_type) {
        this.data_type = data_type;
    }

    public void setChannelDiscription(String[] chanDis) {
    }

    public void setMaxCompressSamples(int maxSamples) {
        this.msis.setMaxSamplesInMiniSeed(maxSamples);
    }

    public void setSteimLevel(int level) {
        this.msis.setSteimInfo((short)level, (short)7);
    }

    public final DataFrame[] readDataFrame() throws IOException {
        TDEStreamData.STHEAD header = null;
        try {
            header = this.client.getSteim2packet(this.samples);
        }
        catch (TDE324IO.TDE324IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        if (this.lastDataCt == header.getDataCt()) {
            logger.warn("Got dup packet, ingore it: " + (Object)((Object)header));
            return null;
        }
        if ((this.lastDataCt + 1 & 0xFFFFFFFF) == header.getDataCt() || this.lastDataCt == 0) {
            this.lastDataCt = header.getDataCt();
        } else {
            if ((this.lastDataCt + 2 & 0xFFFFFFFF) == header.getDataCt()) {
                logger.warn("Lost one packets, try to retransmit.");
                this.client.setDataCt(this.lastDataCt + 1 & 0xFFFFFFFF);
                return null;
            }
            if (this.lastDataCt != 0) {
                logger.warn("Lost " + (header.getDataCt() - this.lastDataCt + 1) + " packets");
                this.lastDataCt = header.getDataCt();
            }
        }
        DataFrame dFrame = new DataFrame();
        dFrame.flag = header.getCaliFlag();
        dFrame.siteID = 0;
        dFrame.time = header.getUtcTime();
        dFrame.ns = header.getNanoSec();
        dFrame.sampRate = header.getSsampRate();
        dFrame.setChannelLocator(new ChannelLocator(header.getNetName(), header.getStationName(), header.getMode(), String.valueOf(header.getSensor()) + header.getDirection()));
        dFrame.data = new int[header.getSamplesNum()];
        System.arraycopy(this.samples, 0, dFrame.data, 0, dFrame.data.length);
        if (this.logLostManager != null && dFrame != null) {
            LogLostManager.TimeInfo timeInfo = new LogLostManager.TimeInfo();
            timeInfo.date = dFrame.time * 1000L + dFrame.ns / 1000000L;
            timeInfo.length = dFrame.data.length * 1000 / dFrame.sampRate;
            this.logLostManager.log(dFrame.getChannelLocator(), timeInfo);
        }
        return new DataFrame[]{dFrame};
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain("TDEServPort.properties");
        TDEServPort csPort = null;
        String[] cDis = new String[]{"GD/TST/00/BHZ:BHE:BHN"};
        if (args.length < 3) {
            logger.debug("Usage:\n java cn.org.gddsn.liss.port.TDEServPort host port password chanDis");
            System.exit(-1);
        } else {
            csPort = new TDEServPort(args[0], Integer.parseInt(args[1]), args[2]);
            cDis = new String[args.length - 3];
            int i = 3;
            while (i < args.length) {
                cDis[i - 3] = args[i];
                ++i;
            }
            csPort.setChannelDiscription(cDis);
        }
        try {
            csPort.openComServPort();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        byte[] buf = null;
        block3: while (true) {
            if ((buf = csPort.readMiniSeedFrame()) != null) {
                byte[] b = new byte[512];
                int i = 0;
                while (true) {
                    if (i >= buf.length) continue block3;
                    System.arraycopy(buf, i, b, 0, 512);
                    GenericMiniSeedRecord gmsr = GenericMiniSeedRecord.buildMiniSeedRecord(b);
                    logger.info(gmsr);
                    i += 512;
                }
            }
            logger.error("Could not read one miniseed packet");
        }
    }

    public int getLastDataCt() {
        return this.lastDataCt;
    }

    public void setLastDataCt(int lastDataCt) {
        this.lastDataCt = lastDataCt;
    }

    public boolean isRetransmit() {
        return this.retransmit;
    }

    public void setRetransmit(boolean retransmit) {
        this.retransmit = retransmit;
    }
}

