/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.tde;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.liss.port.tde.TDEControlWord;
import cn.org.gddsn.liss.util.StructUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Date;
import javolution.io.Struct;
import org.apache.log4j.Logger;

public class TDEStreamData {
    static Logger logger;
    private static final int rawDataInByteSize = 448;
    private static final int rawdataInIntSize = 112;
    private byte[] rawDataInByte = new byte[448];
    private int[] rawDataInInt = new int[112];
    private static final int MASK2 = 3;
    private static final int MASK4 = 15;
    private static final int MASK5 = 31;
    private static final int MASK6 = 63;
    private static final int MASK8 = 255;
    private static final int MASK10 = 1023;
    private static final int MASK15 = Short.MAX_VALUE;
    private static final int MASK30 = 0x3FFFFFFF;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.tde.TDE324IO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public STHEAD getSteim2header(DataInputStream is, OutputStream os, int nDataCt) throws IOException {
        TDEControlWord tdecw = new TDEControlWord(nDataCt, 1);
        tdecw.write(os);
        os.flush();
        if (logger.isDebugEnabled()) {
            System.out.println();
            logger.debug("Sent cmd: " + tdecw.toString());
        }
        STHEAD header = new STHEAD();
        header.readFully(is);
        if (logger.isDebugEnabled()) {
            logger.debug("Received one STEIM2 packet, Header is: " + header.toString());
        }
        return header;
    }

    public int[] getSteim2Data(DataInputStream is) throws IOException {
        is.readFully(this.rawDataInByte, 0, 448);
        ByteArrayInputStream bais = new ByteArrayInputStream(this.rawDataInByte, 0, 448);
        LittleEndianInputStream leis = new LittleEndianInputStream(bais);
        int i = 0;
        while (i < 112) {
            this.rawDataInInt[i] = leis.readInt();
            i = (short)(i + 1);
        }
        bais.close();
        return this.rawDataInInt;
    }

    /*
     * Unable to fully structure code
     */
    public int decodeSteim2Data(int[] rawDataInInt, int[] samples) throws SteimException {
        compression_flag = new int[16];
        last_value = 0;
        end_value = 0;
        temp_data = new int[7];
        frame_num = 7;
        nsample = 0;
        p = 0;
        q = 0;
        i = 0;
        while (i < frame_num) {
            temp_wj = rawDataInInt[p++];
            j = 15;
            while (j >= 0) {
                compression_flag[j] = temp_wj & 3;
                temp_wj >>>= 2;
                --j;
            }
            j = 1;
            while (j < 16) {
                block63: {
                    block0 : switch (compression_flag[j]) {
                        case 0: {
                            if (q == samples.length) break;
                            if (i > 0) {
                                if (TDEStreamData.logger.isDebugEnabled()) {
                                    TDEStreamData.logger.debug("Steim2 compress flag W" + j + "==0 Exceptio");
                                    break;
                                }
                                throw new SteimException("Steim2 compress flag W0==0");
                            }
                            if (j == 1) {
                                last_value = rawDataInInt[p++];
                                samples[q++] = last_value;
                                ++nsample;
                                if (!TDEStreamData.logger.isDebugEnabled()) break;
                                TDEStreamData.logger.debug("X0:" + last_value);
                                break;
                            }
                            if (j == 2) {
                                end_value = rawDataInInt[p++];
                                if (!TDEStreamData.logger.isDebugEnabled()) break;
                                TDEStreamData.logger.debug("Xn:" + end_value);
                                break;
                            }
                        }
                        case 1: {
                            if (q == samples.length) break;
                            temp_wj = rawDataInInt[p++];
                            k = 3;
                            while (k >= 0) {
                                temp_data[k] = temp_wj & 255;
                                if (temp_data[k] > 127) {
                                    v0 = k;
                                    temp_data[v0] = temp_data[v0] | -256;
                                }
                                temp_wj >>>= 8;
                                --k;
                            }
                            if (i == 0 && j == 3) {
                                k = 1;
                                while (k < 4) {
                                    samples[q++] = last_value += temp_data[k];
                                    ++nsample;
                                    ++k;
                                }
                            } else {
                                k = 0;
                                while (k < 4) {
                                    samples[q++] = last_value += temp_data[k];
                                    ++nsample;
                                    ++k;
                                }
                            }
                            break;
                        }
                        case 2: {
                            temp_wj = rawDataInInt[p++];
                            dnib = temp_wj >>> 30 & 3;
                            switch (dnib) {
                                case 1: {
                                    if (q == samples.length) break block0;
                                    temp_data[0] = temp_wj & 0x3FFFFFFF;
                                    if (temp_data[0] > 0x1FFFFFFF) {
                                        temp_data[0] = temp_data[0] | -1073741824;
                                    }
                                    if (i == 0 && j == 3) break block0;
                                    samples[q++] = last_value += temp_data[0];
                                    ++nsample;
                                    break;
                                }
                                case 2: {
                                    if (q == samples.length) break block0;
                                    k = 1;
                                    while (k >= 0) {
                                        temp_data[k] = temp_wj & 32767;
                                        if (temp_data[k] > 16383) {
                                            v1 = k;
                                            temp_data[v1] = temp_data[v1] | -32768;
                                        }
                                        temp_wj >>>= 15;
                                        --k;
                                    }
                                    if (i == 0 && j == 3) {
                                        samples[q++] = last_value += temp_data[1];
                                        ++nsample;
                                        break;
                                    }
                                    k = 0;
                                    while (k < 2) {
                                        samples[q++] = last_value += temp_data[k];
                                        ++nsample;
                                        ++k;
                                    }
                                    break block0;
                                }
                                case 3: {
                                    if (q == samples.length) break block0;
                                    k = 2;
                                    while (k >= 0) {
                                        temp_data[k] = temp_wj & 1023;
                                        if (temp_data[k] > 511) {
                                            v2 = k;
                                            temp_data[v2] = temp_data[v2] | -1024;
                                        }
                                        temp_wj >>>= 10;
                                        --k;
                                    }
                                    if (i == 0 && j == 3) {
                                        k = 1;
                                        while (k < 3) {
                                            samples[q++] = last_value += temp_data[k];
                                            ++nsample;
                                            ++k;
                                        }
                                        break block0;
                                    }
                                    k = 0;
                                    while (k < 3) {
                                        samples[q++] = last_value += temp_data[k];
                                        ++nsample;
                                        ++k;
                                    }
                                    break block6;
                                }
                            }
                            break;
                        }
                        case 3: {
                            temp_wj = rawDataInInt[p++];
                            dnib = temp_wj >>> 30 & 3;
                            switch (dnib) {
                                case 0: {
                                    if (q != samples.length) {
                                        k = 4;
                                        while (k >= 0) {
                                            temp_data[k] = temp_wj & 63;
                                            if (temp_data[k] > 31) {
                                                v3 = k;
                                                temp_data[v3] = temp_data[v3] | -64;
                                            }
                                            temp_wj >>>= 6;
                                            --k;
                                        }
                                        if (i == 0 && j == 3) {
                                            k = 1;
                                            while (k < 5) {
                                                samples[q++] = last_value += temp_data[k];
                                                ++nsample;
                                                ++k;
                                            }
                                        } else {
                                            k = 0;
                                            while (k < 5) {
                                                samples[q++] = last_value += temp_data[k];
                                                ++nsample;
                                                ++k;
                                            }
                                        }
                                    }
                                    break block63;
                                }
                                case 1: {
                                    if (q != samples.length) {
                                        k = 5;
                                        while (k >= 0) {
                                            temp_data[k] = temp_wj & 31;
                                            if (temp_data[k] > 15) {
                                                v4 = k;
                                                temp_data[v4] = temp_data[v4] | -32;
                                            }
                                            temp_wj >>>= 5;
                                            --k;
                                        }
                                        if (i == 0 && j == 3) {
                                            k = 1;
                                            while (k < 6) {
                                                samples[q++] = last_value += temp_data[k];
                                                ++nsample;
                                                ++k;
                                            }
                                        } else {
                                            k = 0;
                                            while (k < 6) {
                                                samples[q++] = last_value += temp_data[k];
                                                ++nsample;
                                                ++k;
                                            }
                                        }
                                    }
                                    break block63;
                                }
                                case 2: {
                                    if (q != samples.length) {
                                        k = 6;
                                        while (k >= 0) {
                                            temp_data[k] = temp_wj & 15;
                                            if (temp_data[k] > 7) {
                                                v5 = k;
                                                temp_data[v5] = temp_data[v5] | -16;
                                            }
                                            temp_wj >>>= 4;
                                            --k;
                                        }
                                        if (i == 0 && j == 3) {
                                            k = 1;
                                            while (k < 7) {
                                                samples[q++] = last_value += temp_data[k];
                                                ++nsample;
                                                ++k;
                                            }
                                        } else {
                                            k = 0;
                                            while (k < 7) {
                                                samples[q++] = last_value += temp_data[k];
                                                ++nsample;
                                                ++k;
                                            }
                                            break block0;
                                        }
                                    } else {
                                        ** GOTO lbl211
                                    }
                                }
                            }
                        }
                    }
                }
                if (compression_flag[j] == 0 && i > 0) {
                    if (TDEStreamData.logger.isDebugEnabled()) {
                        TDEStreamData.logger.debug("Steim2 compress flag W0==0");
                        break;
                    }
                    throw new SteimException("Steim2 compress flag W0==0");
                }
                ++j;
            }
            ++i;
        }
        if (TDEStreamData.logger.isDebugEnabled()) {
            TDEStreamData.logger.debug(" The last value:" + samples[--q]);
            TDEStreamData.logger.debug("Xn:" + end_value);
        }
        return nsample;
    }

    public static class STHEAD
    extends Struct {
        public final Struct.Utf8String flag = new Struct.Utf8String((Struct)this, 8);
        public final Struct.Utf8String staName = new Struct.Utf8String((Struct)this, 3);
        public final Struct.Utf8String blank = new Struct.Utf8String((Struct)this, 2);
        public final Struct.Utf8String mode = new Struct.Utf8String((Struct)this, 2);
        public final Struct.Utf8String sensor = new Struct.Utf8String((Struct)this, 2);
        public final Struct.Utf8String direct = new Struct.Utf8String((Struct)this, 1);
        public final Struct.Utf8String netName = new Struct.Utf8String((Struct)this, 2);
        public final Struct.Unsigned32 utcTime = new Struct.Unsigned32((Struct)this);
        public final Struct.Unsigned32 dataCt = new Struct.Unsigned32((Struct)this);
        public final Struct.Unsigned16 count = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 total = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 sampRate = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16[] metaData = (Struct.Unsigned16[])this.array((Struct.Member[])new Struct.Unsigned16[6]);
        public final Struct.Unsigned16 statusParam = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned8[] unknow = (Struct.Unsigned8[])this.array((Struct.Member[])new Struct.Unsigned8[16]);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public String toString() {
            return StructUtil.struct2String(this);
        }

        public void decodeSteim2Header() {
            short statusPar = (short)this.statusParam.get();
            Date date = new Date(this.utcTime.get() * 1000L);
            System.out.println("TDE Steim2 Packet Flag:" + this.flag.get());
            System.out.println("Station Name:" + this.staName.get());
            System.out.println("Direction:" + this.direct.get());
            System.out.println("Net Name:" + this.netName.get());
            System.out.println("Time:" + date.toString());
            System.out.println("Count:" + this.count.get());
            System.out.println("Total Samples:" + this.total.get());
            System.out.println("DataCt:" + this.dataCt.get());
            System.out.println("Sample rate:" + this.sampRate.get());
            System.out.println("statusPar:" + this.statusParam.get());
            short state = (short)(statusPar >>> 3);
            if ((state & 1) == 1) {
                System.out.println("Triggered");
            } else {
                System.out.println("Not Triggered");
            }
            state = (short)(statusPar >>> 4);
            switch (state & 3) {
                case 0: {
                    System.out.println("GPS have correct time in 7200 seconds");
                    break;
                }
                case 1: {
                    System.out.println("GPS is searching");
                    break;
                }
                case 2: {
                    System.out.println("GPS ok");
                    break;
                }
                case 3: {
                    System.out.println("Never correct time");
                }
            }
            state = (short)(statusPar >>> 6);
            switch (state & 3) {
                case 0: {
                    System.out.println("NO Calibration");
                    break;
                }
                case 1: {
                    System.out.println("Pulse Calibration");
                    break;
                }
                case 2: {
                    System.out.println("Sine Calibration");
                    break;
                }
                case 3: {
                    System.out.println("***");
                }
            }
        }

        public boolean getTrigStatus() {
            int statusPar = this.statusParam.get();
            int state = statusPar >>> 3;
            return (state & 1) == 1;
        }

        public int getGpsStatus() {
            int statusPar = this.statusParam.get();
            int state = statusPar >>> 4 & 3;
            return state;
        }

        public int getCaliFlag() {
            int statusPar = this.statusParam.get();
            int state = statusPar >>> 6 & 3;
            return state;
        }

        public long getUtcTime() {
            return this.utcTime.get();
        }

        public int getNanoSec() {
            return (int)((long)this.count.get() * 1000000000L / (long)this.sampRate.get());
        }

        public int getDataCt() {
            return (int)this.dataCt.get();
        }

        public String getSensor() {
            return this.sensor.get();
        }

        public int getSsampRate() {
            return this.sampRate.get();
        }

        public String getMode() {
            return this.mode.get();
        }

        public String getStationName() {
            return this.staName.get();
        }

        public String getDirection() {
            return this.direct.get();
        }

        public String getNetName() {
            return this.netName.get();
        }

        public String getDate() {
            Date date = new Date(this.utcTime.get() * 1000L);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            return sdf.format(date);
        }

        public int getSamplesNum() {
            return this.total.get();
        }

        public short getStatusParam() {
            return (short)this.statusParam.get();
        }
    }

    public static class SteimException
    extends Exception {
        static final long serialVersionUID = 4889356424401221729L;

        public SteimException() {
        }

        public SteimException(String s) {
            super(s);
        }
    }
}

