/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.tde;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.LogLostManager;
import cn.org.gddsn.liss.port.SiteInfo;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class TdeInputStream
implements DataFrameInput {
    static Logger logger;
    private static final String[] compCode;
    private static final int SAMPRATE_CHAN_1_3 = 48;
    private static final int SAMPRATE_CHAN_5_3 = 49;
    private static final int SAMPRATE_CHAN_10_3 = 50;
    private static final int SAMPRATE_CHAN_20_3 = 51;
    private static final int SAMPRATE_CHAN_25_3 = 52;
    private static final int SAMPRATE_CHAN_40_3 = 53;
    private static final int SAMPRATE_CHAN_50_3 = 54;
    private static final int SAMPRATE_CHAN_100_3 = 55;
    private static final int SAMPRATE_CHAN_125_3 = 56;
    private static final int SAMPRATE_CHAN_200_3 = 57;
    private static final int SAMPRATE_CHAN_250_3 = 58;
    private static final int SAMPRATE_CHAN_333_3 = 59;
    private static final int SAMPRATE_CHAN_500_3 = 60;
    private static final int SAMPRATE_CHAN_1000_3 = 61;
    private static final int SAMPRATE_CHAN_2000_3 = 62;
    private static final int SAMPRATE_CHAN_4000_3 = 63;
    private static final int SAMPRATE_CHAN_1_6 = 96;
    private static final int SAMPRATE_CHAN_5_6 = 97;
    private static final int SAMPRATE_CHAN_10_6 = 98;
    private static final int SAMPRATE_CHAN_20_6 = 99;
    private static final int SAMPRATE_CHAN_25_6 = 100;
    private static final int SAMPRATE_CHAN_40_6 = 101;
    private static final int SAMPRATE_CHAN_50_6 = 102;
    private static final int SAMPRATE_CHAN_100_6 = 103;
    private static final int SAMPRATE_CHAN_125_6 = 104;
    private static final int SAMPRATE_CHAN_200_6 = 105;
    private static final int SAMPRATE_CHAN_250_6 = 106;
    private static final int SAMPRATE_CHAN_333_6 = 107;
    private static final int SAMPRATE_CHAN_500_6 = 108;
    private static final int SAMPRATE_CHAN_1000_6 = 109;
    private static final int SAMPRATE_CHAN_2000_6 = 110;
    private static final int SAMPRATE_CHAN_4000_6 = 111;
    InputStream in;
    String comPort;
    private int sampRate;
    private static final int[] frameHead;
    private int headLen = frameHead.length;
    private int[] head = new int[this.headLen];
    private int flag;
    private int second;
    private int siteID;
    private int statusPar;
    private int chan;
    private int[] data;
    private byte[] headBuf;
    private byte[] dataBuf;
    private SiteInfo siteInfo = null;
    private LogLostManager logLostManager = new LogLostManager();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.tde.TdeInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        compCode = new String[]{"Z", "E", "N"};
        frameHead = new int[]{191, 19, 151};
    }

    public TdeInputStream(InputStream in, String comPort, String[] chanDiscription) {
        this.in = in;
        this.comPort = comPort;
        this.headBuf = new byte[21];
        this.siteInfo = new SiteInfo(chanDiscription, compCode);
    }

    public int getTotalChannels() {
        return this.siteInfo.getChannalSize();
    }

    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final DataFrame[] readDataFrame() throws IOException {
        if (!this.hasEnoughData()) {
            return null;
        }
        if (!this.findFrameHead()) {
            return null;
        }
        this.readHeadPar(this.in);
        this.parsehead(this.headBuf.length);
        if (logger.isDebugEnabled()) {
            logger.debug(" date:" + this.getStringDate());
            logger.debug(" Trigger:" + this.getTrigStatus());
            logger.debug(" GPS:" + this.getGpsStatus());
            logger.debug(" Cali Flag:" + this.getCaliFlag());
        }
        switch (this.flag) {
            case 48: {
                this.sampRate = 1;
                this.chan = 3;
                break;
            }
            case 49: {
                this.sampRate = 5;
                this.chan = 3;
                break;
            }
            case 50: {
                this.sampRate = 10;
                this.chan = 3;
                break;
            }
            case 51: {
                this.sampRate = 20;
                this.chan = 3;
                break;
            }
            case 52: {
                this.sampRate = 25;
                this.chan = 3;
                break;
            }
            case 53: {
                this.sampRate = 40;
                this.chan = 3;
                break;
            }
            case 54: {
                this.sampRate = 50;
                this.chan = 3;
                break;
            }
            case 55: {
                this.sampRate = 100;
                this.chan = 3;
                break;
            }
            case 56: {
                this.sampRate = 125;
                this.chan = 3;
                break;
            }
            case 57: {
                this.sampRate = 200;
                this.chan = 3;
                break;
            }
            case 58: {
                this.sampRate = 250;
                this.chan = 3;
                break;
            }
            case 59: {
                this.sampRate = 333;
                this.chan = 3;
                break;
            }
            case 60: {
                this.sampRate = 500;
                this.chan = 3;
                break;
            }
            case 61: {
                this.sampRate = 1000;
                this.chan = 3;
                break;
            }
            case 62: {
                this.sampRate = 2000;
                this.chan = 3;
                break;
            }
            case 63: {
                this.sampRate = 4000;
                this.chan = 3;
                break;
            }
            case 96: {
                this.sampRate = 1;
                this.chan = 6;
                break;
            }
            case 97: {
                this.sampRate = 5;
                this.chan = 6;
                break;
            }
            case 98: {
                this.sampRate = 10;
                this.chan = 6;
                break;
            }
            case 99: {
                this.sampRate = 20;
                this.chan = 6;
                break;
            }
            case 100: {
                this.sampRate = 25;
                this.chan = 6;
                break;
            }
            case 101: {
                this.sampRate = 40;
                this.chan = 6;
                break;
            }
            case 102: {
                this.sampRate = 50;
                this.chan = 6;
                break;
            }
            case 103: {
                this.sampRate = 100;
                this.chan = 6;
                break;
            }
            case 104: {
                this.sampRate = 125;
                this.chan = 6;
                break;
            }
            case 105: {
                this.sampRate = 200;
                this.chan = 6;
                break;
            }
            case 106: {
                this.sampRate = 250;
                this.chan = 6;
                break;
            }
            case 107: {
                this.sampRate = 333;
                this.chan = 6;
                break;
            }
            case 108: {
                this.sampRate = 500;
                this.chan = 6;
                break;
            }
            case 109: {
                this.sampRate = 1000;
                this.chan = 6;
                break;
            }
            case 110: {
                this.sampRate = 2000;
                this.chan = 6;
                break;
            }
            case 111: {
                this.sampRate = 4000;
                this.chan = 6;
                break;
            }
            default: {
                logger.warn("frame head flag error! Unknow sample rate!");
                return null;
            }
        }
        DataFrame[] dfs = new DataFrame[this.chan];
        int f = 0;
        while (f < this.chan) {
            this.readOneChannelData(this.in);
            dfs[f] = new DataFrame();
            dfs[f].data = new int[this.data.length];
            System.arraycopy(this.data, 0, dfs[f].data, 0, this.data.length);
            dfs[f].flag = this.getCaliFlag();
            dfs[f].siteID = 0;
            dfs[f].time = this.second;
            dfs[f].sampRate = this.sampRate;
            dfs[f].setChannelLocator(this.siteInfo.getChannelLocator(dfs[f].siteID, compCode[f]));
            if (this.logLostManager != null && dfs != null) {
                LogLostManager.TimeInfo timeInfo = new LogLostManager.TimeInfo();
                timeInfo.date = dfs[f].time * 1000L;
                timeInfo.length = dfs[f].data.length * 1000 / dfs[f].sampRate;
                this.logLostManager.log(dfs[f].getChannelLocator(), timeInfo);
            }
            ++f;
        }
        return dfs;
    }

    private boolean findFrameHead() throws IOException {
        int ret;
        int i = 0;
        while (i < this.headLen) {
            this.head[i] = 0;
            ++i;
        }
        int firstIdx = 0;
        boolean found = false;
        while ((ret = this.forceRead(this.in)) != -1) {
            this.head[firstIdx % this.headLen] = ret;
            int i2 = firstIdx;
            while (i2 < firstIdx + this.headLen) {
                if (this.head[(i2 + 1) % this.headLen] != frameHead[i2 - firstIdx]) {
                    found = false;
                    break;
                }
                found = true;
                ++i2;
            }
            if (found) break;
            ++firstIdx;
            firstIdx %= this.headLen;
        }
        if (!found) {
            logger.warn(" has enough data to read, but I can't found Frame Header \"0xbf1397\".");
        }
        return found;
    }

    private boolean hasEnoughData() throws IOException {
        int delay = 3000;
        int count = 0;
        while (delay != 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.in.available() >= 1) break;
            if (count++ > 998 && this.in.available() == 0) {
                logger.warn("waite 3 seconds had not enough Data");
                return false;
            }
            --delay;
        }
        delay = 3000 - delay;
        return true;
    }

    private int readHeadPar(InputStream in) throws IOException {
        int i = 0;
        while (i < this.headBuf.length) {
            this.headBuf[i++] = (byte)this.forceRead(in);
        }
        return this.headBuf.length;
    }

    private void parsehead(int len) throws IOException {
        DataInputStream dIn = new DataInputStream(new ByteArrayInputStream(this.headBuf, 0, len));
        LittleEndianInputStream leis = new LittleEndianInputStream(dIn);
        this.flag = leis.readUnsignedByte();
        this.second = leis.readInt();
        leis.skipBytes(12);
        this.siteID = leis.readUnsignedShort();
        this.statusPar = leis.readUnsignedShort();
        leis.close();
    }

    public String getStringDate() {
        Date date = new Date((long)this.second * 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(date);
    }

    public boolean getTrigStatus() {
        int state = this.statusPar >>> 3;
        return (state & 1) == 1;
    }

    public int getGpsStatus() {
        int state = this.statusPar >>> 4 & 3;
        return state;
    }

    public int getCaliFlag() {
        int state = this.statusPar >>> 6 & 3;
        return state;
    }

    private int readOneChannelData(InputStream in) throws IOException {
        int i = 0;
        int k = 0;
        this.dataBuf = new byte[this.sampRate * 3];
        this.data = new int[this.sampRate];
        while (i < this.dataBuf.length) {
            this.dataBuf[i++] = (byte)this.forceRead(in);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.dataBuf, 0, this.dataBuf.length);
        LittleEndianInputStream leis = new LittleEndianInputStream(bais);
        k = 0;
        while (k < this.data.length) {
            this.data[k] = leis.readInt24();
            if (logger.isDebugEnabled()) {
                System.out.print(" " + this.data[k]);
                if (k == this.sampRate - 1) {
                    System.out.println();
                }
            }
            ++k;
        }
        return this.sampRate;
    }

    private int forceRead(InputStream in) throws IOException {
        while (in.available() < 1) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return in.read();
    }
}

