/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.tyt;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.SiteInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Date;
import org.apache.log4j.Logger;

public class TytInputStream
implements DataFrameInput {
    static Logger logger;
    public static final int SRATE_50 = 3;
    private static final String[] compCode;
    private String comPort;
    private LittleEndianInputStream in;
    private SiteInfo siteInfo = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.tyt.TytInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        compCode = new String[]{"Z", "N", "E"};
    }

    public TytInputStream(InputStream in, String comPort, String[] chanDiscription) {
        this.in = new LittleEndianInputStream(in);
        this.comPort = comPort;
        this.siteInfo = new SiteInfo(chanDiscription, compCode);
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final DataFrame[] readDataFrame() throws IOException {
        int nsamp;
        int sec = this.in.readInt();
        int ws = this.in.readInt();
        int srate_flag = this.in.read();
        int srate = 50;
        if (srate_flag == 3) {
            srate = 50;
        }
        if ((nsamp = this.in.readShort() & 0xFFFF) < 0 || nsamp >= 4096) {
            logger.warn("In TytInputStream, dataframe.data.length=" + nsamp + " is invalid, ignore!");
            logger.warn("\tdate=" + new Date((long)sec * 1000L + (long)(ws / 1000)) + " srate_flag=" + srate_flag);
            return null;
        }
        DataFrame[] dFrame = new DataFrame[3];
        int i = 0;
        while (i < dFrame.length) {
            dFrame[i] = new DataFrame();
            dFrame[i].flag = 0;
            dFrame[i].siteID = 0;
            dFrame[i].time = sec + 28800;
            dFrame[i].ns = ws * 1000;
            if (dFrame[i].ns < 0L || dFrame[i].ns > 999999999L) {
                logger.warn("In TytInputStream, dataframe.ns=" + dFrame[i].ns + " is invalid!, force return null!");
                logger.warn("\tdate=" + new Date((long)sec * 1000L + (long)(ws / 1000)) + "srate_flag=" + srate_flag + "/nsamp=" + nsamp);
                return null;
            }
            dFrame[i].sampRate = srate;
            dFrame[i].setChannelLocator(this.siteInfo.getChannelLocator(0, compCode[i]));
            dFrame[i].data = new int[nsamp];
            ++i;
        }
        i = 0;
        while (i < nsamp) {
            this.in.readInt();
            int chan = 0;
            while (chan < dFrame.length) {
                dFrame[chan].data[i] = this.in.readInt();
                ++chan;
            }
            ++i;
        }
        return dFrame;
    }

    public static void main(String[] args) throws Exception {
        Socket socket = new Socket("218.249.67.162", 3000);
        socket.setSoTimeout(120000);
        String[] cDis = new String[]{"GD/TST/00/BHZ:BHE:BHN"};
        TytInputStream tytinputstream = new TytInputStream(socket.getInputStream(), " 218.249.67.162:3000", cDis);
        DataFrame[] dfs = null;
        while (true) {
            dfs = tytinputstream.readDataFrame();
            logger.info(dfs[0]);
            logger.info("Current ms: " + (dfs[0].time * 1000L + dfs[0].ns / 1000000L));
            logger.info("\tExpect next ms: " + (dfs[0].time * 1000L + dfs[0].ns / 1000000L + (long)(dfs[0].data.length * 1000 / dfs[0].sampRate)));
        }
    }
}

