/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javolution.io.Struct;
import org.apache.log4j.Logger;

public class StructUtil {
    static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.util.StructUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    private StructUtil() {
    }

    public static String Member2String(Object o) {
        StringBuffer sb = new StringBuffer(128);
        Class[] parameterTypes = new Class[]{};
        Object[] arguments = new Object[]{};
        try {
            Class<?> c = o.getClass();
            Method getMethod = c.getMethod("get", parameterTypes);
            if (o instanceof Struct.Bool) {
                Boolean n = (Boolean)getMethod.invoke(o, arguments);
                sb.append(n);
            } else if (o instanceof Struct.Signed8) {
                Byte n = (Byte)getMethod.invoke(o, arguments);
                sb.append(Integer.toHexString(n.intValue()));
            } else if (o instanceof Struct.Signed16) {
                Short n = (Short)getMethod.invoke(o, arguments);
                sb.append(Integer.toHexString(n.intValue()));
            } else if (o instanceof Struct.Signed32) {
                Integer n = (Integer)getMethod.invoke(o, arguments);
                sb.append(Integer.toHexString(n));
            } else if (o instanceof Struct.Signed64) {
                Long n = (Long)getMethod.invoke(o, arguments);
                sb.append(Long.toHexString(n));
            } else if (o instanceof Struct.Unsigned8) {
                Short n = (Short)getMethod.invoke(o, arguments);
                sb.append(Integer.toHexString(n.intValue()));
            } else if (o instanceof Struct.Unsigned16) {
                Integer n = (Integer)getMethod.invoke(o, arguments);
                sb.append(Integer.toHexString(n));
            } else if (o instanceof Struct.Unsigned32) {
                Long n = (Long)getMethod.invoke(o, arguments);
                sb.append(Long.toHexString(n));
            } else if (o instanceof Struct.Utf8String) {
                String n = (String)getMethod.invoke(o, arguments);
                sb.append(n);
            } else if (o instanceof Struct.Float32) {
                Float n = (Float)getMethod.invoke(o, arguments);
                sb.append(n);
            } else if (o instanceof Struct.Float64) {
                Double n = (Double)getMethod.invoke(o, arguments);
                sb.append(n);
            } else {
                sb.append(o);
            }
        }
        catch (SecurityException e) {
            logger.warn(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            logger.warn(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            logger.warn(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            sb.append(o);
        }
        return sb.substring(0);
    }

    public static String struct2String(Struct struct) {
        String jversion = System.getProperty("java.version");
        try {
            float version = Float.parseFloat(jversion.substring(0, 3));
            if ((double)version < 1.3) {
                return "";
            }
        }
        catch (NumberFormatException nfEx) {
            return "";
        }
        StringBuffer sb = new StringBuffer(128);
        try {
            Class<?> c = struct.getClass();
            sb.append("className=" + c.getSimpleName());
            Field[] publicFields = c.getFields();
            int i = 0;
            while (i < publicFields.length) {
                String fieldName = publicFields[i].getName();
                Class<?> typeClass = publicFields[i].getType();
                Object o = publicFields[i].get(struct);
                sb.append("/" + fieldName + "=");
                if (typeClass.isArray()) {
                    int j = 0;
                    while (j < Array.getLength(o)) {
                        if (Array.get(o, j) instanceof Struct) {
                            sb.append(StructUtil.struct2String((Struct)Array.get(o, j)));
                        } else {
                            sb.append(String.valueOf(StructUtil.Member2String(Array.get(o, j))) + ",");
                        }
                        ++j;
                    }
                } else if (o instanceof Struct) {
                    sb.append(StructUtil.struct2String((Struct)o));
                } else {
                    sb.append(StructUtil.Member2String(o));
                }
                ++i;
            }
        }
        catch (SecurityException e) {
            logger.warn(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            logger.warn(e.getMessage(), e);
        }
        return sb.substring(0);
    }
}

