/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.optimization;

import cn.org.gddsn.convert.DoubleFormat;
import cn.org.gddsn.coyote.stochastic.Stochastic;
import cn.org.gddsn.coyote.stochastic.StochasticLevel3;
import cn.org.gddsn.optimization.BoundCheck;
import cn.org.gddsn.optimization.DoubleEncodeToDoubleFunction;
import cn.org.gddsn.optimization.geneDouble;
import cn.org.gddsn.optimization.geneSortTool;
import cn.org.gddsn.sort.ShellSorter;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.Logger;

public class AEAMin {
    static Logger logger;
    IllegalArgumentException internalErr = new IllegalArgumentException("The gene must be between 0 and 1");
    Stochastic rand = new StochasticLevel3();
    private DoubleEncodeToDoubleFunction funk;
    private BoundCheck bc = new DefaultBoundCheck();
    private int populationSize = 100;
    private int betterPopulationSize = 50;
    private double selectP = 0.6;
    private double mutationP = 0.25;
    private double inversionP = 0.3;
    private int iterateMax = 2000;
    private double eps = 0.01;
    private double crossP = 0.8;
    int paraSize;
    geneDouble[] inputModel;
    geneDouble[] betterModel;
    geneDouble theBestModel;
    double[] invOrder;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.optimization.AEAMin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public void setBoundCheck(BoundCheck bc) {
        this.bc = bc;
    }

    public void setFunk(DoubleEncodeToDoubleFunction newFunk) {
        this.funk = newFunk;
    }

    public void setInversionP(double newInversionP) {
        this.inversionP = newInversionP;
    }

    public double getInversionP() {
        return this.inversionP;
    }

    public void setCrossP(double newCrossP) {
        this.crossP = newCrossP;
    }

    public double getCrossP() {
        return this.crossP;
    }

    public void setMutationP(double newMutationP) {
        this.mutationP = newMutationP;
    }

    public double getMutationP() {
        return this.mutationP;
    }

    public void setPopulationSize(int newPopulationSize) {
        this.populationSize = newPopulationSize;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public void setSelectP(double newSelectP) {
        this.selectP = newSelectP;
    }

    public double getSelectP() {
        return this.selectP;
    }

    public void setEps(double newEps) {
        this.eps = newEps;
    }

    public void setIterateMax(int newIterateMax) {
        this.iterateMax = newIterateMax;
    }

    public int getIterateMax() {
        return this.iterateMax;
    }

    private void initModel() {
        this.paraSize = this.funk.getParaSize();
        this.inputModel = new geneDouble[this.populationSize];
        this.betterPopulationSize = (int)((double)this.populationSize * this.selectP);
        this.betterModel = new geneDouble[this.betterPopulationSize];
        this.invOrder = new double[this.paraSize];
        int i = 0;
        while (i < this.populationSize) {
            this.inputModel[i] = new geneDouble(this.paraSize);
            do {
                int j = 0;
                while (j < this.paraSize) {
                    this.inputModel[i].x[j] = this.rand.nextDouble(0.0, 1.0);
                    ++j;
                }
            } while (!this.bc.accept(this.inputModel[i]));
            ++i;
        }
        i = 0;
        while (i < this.betterPopulationSize) {
            this.betterModel[i] = new geneDouble(this.paraSize);
            ++i;
        }
        this.theBestModel = (geneDouble)this.inputModel[0].clone();
        this.funk.getValue(this.theBestModel);
    }

    private void calcFunkVal() {
        int i = 0;
        while (i < this.populationSize) {
            int j = 0;
            while (j < this.paraSize) {
                if (this.inputModel[i].x[j] > 1.0 || this.inputModel[i].x[j] < 0.0) {
                    throw this.internalErr;
                }
                ++j;
            }
            this.funk.getValue(this.inputModel[i]);
            ++i;
        }
    }

    private void tournamentSelect() {
        int n = 0;
        int min = 0;
        int max = 0;
        double r = 0.0;
        int i = 0;
        while (i < this.betterPopulationSize) {
            int j;
            min = this.rand.nextValue(0, this.populationSize);
            max = this.rand.nextValue(0, this.populationSize);
            while (min == max) {
                max = this.rand.nextValue(0, this.populationSize);
            }
            if (this.inputModel[min].funkVal > this.inputModel[max].funkVal) {
                n = max;
                max = min;
                min = n;
            }
            if ((r = this.rand.nextDouble(0.0, 1.0)) < this.selectP) {
                j = 0;
                while (j < this.paraSize) {
                    this.betterModel[i].x[j] = this.inputModel[min].x[j];
                    ++j;
                }
                this.betterModel[i].funkVal = this.inputModel[min].funkVal;
            } else {
                j = 0;
                while (j < this.paraSize) {
                    this.betterModel[i].x[j] = this.inputModel[max].x[j];
                    ++j;
                }
                this.betterModel[i].funkVal = this.inputModel[max].funkVal;
            }
            ++i;
        }
    }

    private void trucationSelect() {
        geneSortTool gst = new geneSortTool();
        ShellSorter sort = new ShellSorter();
        sort.Sort(this.inputModel, gst);
        int i = 0;
        while (i < this.betterPopulationSize) {
            int j = 0;
            while (j < this.paraSize) {
                this.betterModel[i].x[j] = this.inputModel[i].x[j];
                ++j;
            }
            this.betterModel[i].funkVal = this.inputModel[i].funkVal;
            ++i;
        }
        if (this.theBestModel.funkVal >= this.betterModel[0].funkVal) {
            this.theBestModel = (geneDouble)this.betterModel[0].clone();
        }
    }

    private void recombination() {
        int n = 0;
        double r = 0.0;
        int dad = 0;
        int mom = 0;
        int flow = 0;
        int i = 0;
        while (i < this.populationSize) {
            dad = this.rand.nextValue(0, this.betterPopulationSize);
            mom = this.rand.nextValue(0, this.betterPopulationSize);
            while (dad == mom) {
                mom = this.rand.nextValue(0, this.betterPopulationSize);
            }
            flow = i % 3;
            switch (flow) {
                case 0: {
                    int j;
                    do {
                        j = 0;
                        while (j < this.paraSize) {
                            r = this.rand.nextDouble(0.0, 1.0);
                            this.inputModel[i].x[j] = r * this.betterModel[dad].x[j] + (1.0 - r) * this.betterModel[mom].x[j];
                            ++j;
                        }
                    } while (!this.bc.accept(this.inputModel[i]));
                    break;
                }
                case 1: {
                    int j;
                    do {
                        r = this.rand.nextDouble(0.0, 1.0);
                        j = 0;
                        while (j < this.paraSize) {
                            this.inputModel[i].x[j] = r * this.betterModel[dad].x[j] + (1.0 - r) * this.betterModel[mom].x[j];
                            ++j;
                        }
                    } while (!this.bc.accept(this.inputModel[i]));
                    break;
                }
                case 2: {
                    do {
                        n = this.rand.nextValue(0, this.paraSize);
                        int swap = 0;
                        int j = 0;
                        while (j < this.paraSize) {
                            if (j < n) {
                                this.inputModel[i].x[j] = this.betterModel[dad].x[j];
                            } else if (j > n) {
                                this.inputModel[i].x[j] = this.betterModel[mom].x[j];
                            } else {
                                swap = this.rand.nextValue(0, 16);
                                double base = 1.0;
                                int k = 0;
                                while (k < swap) {
                                    base *= 10.0;
                                    ++k;
                                }
                                this.inputModel[i].x[j] = (long)(this.betterModel[dad].x[j] * base);
                                int n2 = j;
                                this.inputModel[i].x[n2] = this.inputModel[i].x[n2] + (this.betterModel[mom].x[j] * base - (double)((long)(this.betterModel[mom].x[j] * base)));
                                int n3 = j;
                                this.inputModel[i].x[n3] = this.inputModel[i].x[n3] / base;
                            }
                            ++j;
                        }
                    } while (!this.bc.accept(this.inputModel[i]));
                }
            }
            ++i;
        }
    }

    private void mutation() {
        double r = 0.0;
        int n = 0;
        int flow = 0;
        int swap = 0;
        double value = 0.0;
        int i = 0;
        while (i < this.populationSize) {
            if (!(this.rand.nextDouble(0.0, 1.0) > this.mutationP)) {
                flow = i % 3;
                n = this.rand.nextValue(0, this.paraSize);
                value = this.inputModel[i].x[n];
                switch (flow) {
                    case 0: {
                        do {
                            swap = this.rand.nextValue(0, 2);
                            r = this.rand.nextDouble(0.0, 1.0);
                            if (swap == 0) {
                                value *= 1.0 - r;
                            } else if ((value += r * (1.0 - value)) > 1.0) {
                                value -= 1.0;
                            }
                            if (value > 1.0) {
                                logger.info("0errer value  " + value);
                            }
                            this.inputModel[i].x[n] = value;
                        } while (!this.bc.accept(this.inputModel[i]));
                        break;
                    }
                    case 1: {
                        do {
                            double delta = 0.0;
                            double m = 2.0;
                            int j = 0;
                            while (j < 16) {
                                r = this.rand.nextDouble(0.0, 1.0);
                                m /= 2.0;
                                if (r < 0.0625) {
                                    delta += m;
                                }
                                ++j;
                            }
                            swap = this.rand.nextValue(0, 2);
                            value = swap == 0 ? (value += 0.1 * delta) : (value -= 0.1 * delta);
                            if (value > 1.0 || value < 0.0) {
                                value += 0.2;
                                value /= 1.4;
                            }
                            if (value > 1.0) {
                                logger.info("1errer value " + value);
                            }
                            this.inputModel[i].x[n] = value;
                        } while (!this.bc.accept(this.inputModel[i]));
                        break;
                    }
                    case 2: {
                        do {
                            double base = 1.0;
                            swap = this.rand.nextValue(1, 16);
                            int k = 0;
                            while (k < swap) {
                                base *= 10.0;
                                ++k;
                            }
                            int tmp = (int)(value * base);
                            tmp %= 10;
                            if ((value -= (double)(tmp -= this.rand.nextValue(0, 10)) / base) > 1.0) {
                                logger.info("2errer value " + value);
                            }
                            this.inputModel[i].x[n] = value;
                        } while (!this.bc.accept(this.inputModel[i]));
                    }
                }
            }
            ++i;
        }
    }

    private void inversion() {
        int swapMin = 0;
        int swapMax = 0;
        int n = 0;
        int i = 0;
        while (i < this.populationSize) {
            if (this.rand.nextDouble(0.0, 1.0) < this.inversionP) {
                do {
                    swapMin = this.rand.nextValue(0, this.paraSize);
                    swapMax = this.rand.nextValue(0, this.paraSize);
                    while (swapMin == swapMax) {
                        swapMax = this.rand.nextValue(0, this.paraSize);
                    }
                    if (swapMin > swapMax) {
                        n = swapMin;
                        swapMin = swapMax;
                        swapMax = n;
                    }
                    int k = swapMin;
                    while (k <= swapMax) {
                        this.invOrder[k] = this.inputModel[i].x[swapMax + swapMin - k];
                        ++k;
                    }
                    k = swapMin;
                    while (k <= swapMax) {
                        this.inputModel[i].x[k] = this.invOrder[k];
                        ++k;
                    }
                } while (!this.bc.accept(this.inputModel[i]));
            }
            ++i;
        }
    }

    private void crossOver() {
    }

    public double calAvgError() {
        double retVal = 0.0;
        int i = 0;
        while (i < this.betterPopulationSize) {
            retVal += Math.abs(this.betterModel[i].funkVal);
            ++i;
        }
        return retVal /= (double)this.betterPopulationSize;
    }

    public double calMinError() {
        return this.betterModel[0].funkVal;
    }

    public void SearchMin() {
        this.initModel();
        int count = 0;
        int interval = 500;
        double[] Residual = new double[interval];
        int next = 0;
        int pre = 0;
        this.calcFunkVal();
        this.trucationSelect();
        while (count++ < interval || Residual[pre] - Residual[next] > this.eps) {
            if (count > this.iterateMax) {
                logger.warn("iteratMax exceed in GeneticMin.SearchMin");
                return;
            }
            this.recombination();
            this.mutation();
            this.inversion();
            this.calcFunkVal();
            this.trucationSelect();
            if (count % 10 == 0) {
                this.printResult();
            }
            next = count % interval;
            Residual[next] = this.theBestModel.funkVal;
            pre = (next + 1) % interval;
        }
    }

    public double[] getResult() {
        return this.funk.ConvertToOrgValue(this.theBestModel);
    }

    public double getResidual() {
        return this.theBestModel.funkVal;
    }

    public void writeDetailResult(String fileName) {
        try {
            FileOutputStream Out = new FileOutputStream(fileName, true);
            BufferedOutputStream BufferedOut = new BufferedOutputStream(Out, 1024);
            PrintWriter p = new PrintWriter(Out);
            int i = 0;
            while (i < this.betterPopulationSize) {
                double[] x = this.funk.ConvertToOrgValue(this.betterModel[i]);
                int j = 0;
                while (j < x.length) {
                    p.print(String.valueOf(x[j]) + "  ");
                    ++j;
                }
                p.println(this.betterModel[i].funkVal);
                ++i;
            }
            p.flush();
            p.close();
            BufferedOut.close();
            Out.close();
        }
        catch (IOException e) {
            logger.warn("In AEAMin.writeResult() Write ASCII FILE Error!");
        }
    }

    public void printResult() {
        double[] x = this.funk.ConvertToOrgValue(this.theBestModel);
        int j = 0;
        while (j < x.length) {
            System.out.print(String.valueOf(DoubleFormat.toString(x[j], 4)) + "  ");
            ++j;
        }
        System.out.println(this.theBestModel.funkVal);
    }

    public static class DefaultBoundCheck
    implements BoundCheck {
        public boolean accept(geneDouble gene) {
            return true;
        }
    }
}

