/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.optimization;

import java.io.Serializable;

final class BitSet
implements Cloneable,
Serializable {
    static final long serialVersionUID = -6510408031051410579L;
    private static final int BITS_PER_UNIT = 6;
    private static final int MASK = 63;
    private long[] bits;

    private static int subscript(int bitIndex) {
        return bitIndex >> 6;
    }

    private static int bitIndex(int subscript) {
        return (subscript << 6) + 63;
    }

    public BitSet() {
        this(64);
    }

    public BitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException(Integer.toString(nbits));
        }
        if (nbits + 63 < 0) {
            nbits = 2147483584;
        }
        this.bits = new long[BitSet.subscript(nbits + 63)];
    }

    private void ensureCapacity(int nth) {
        int required = BitSet.subscript(nth) + 1;
        if (required > this.bits.length) {
            int request = Math.max(2 * this.bits.length, required);
            long[] newBits = new long[request];
            System.arraycopy(this.bits, 0, newBits, 0, this.bits.length);
            this.bits = newBits;
        }
    }

    public void set(int bit) {
        if (bit < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(bit));
        }
        this.ensureCapacity(bit);
        int n = BitSet.subscript(bit);
        this.bits[n] = this.bits[n] | 1L << (bit & 0x3F);
    }

    public void clear(int bit) {
        if (bit < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(bit));
        }
        this.ensureCapacity(bit);
        int n = BitSet.subscript(bit);
        this.bits[n] = this.bits[n] & (1L << (bit & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean get(int bit) {
        if (bit < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(bit));
        }
        boolean result = false;
        int n = BitSet.subscript(bit);
        if (n < this.bits.length) {
            result = (this.bits[n] & 1L << (bit & 0x3F)) != 0L;
        }
        return result;
    }

    public void and(BitSet set) {
        int n;
        if (this == set) {
            return;
        }
        BitSet first = this;
        BitSet second = set;
        if (System.identityHashCode(first) > System.identityHashCode(second)) {
            first = set;
            second = this;
        }
        int bitsLength = this.bits.length;
        int setLength = set.bits.length;
        int i = n = Math.min(bitsLength, setLength);
        while (i-- > 0) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] & set.bits[i];
        }
        while (n < bitsLength) {
            this.bits[n] = 0L;
            ++n;
        }
    }

    public void or(BitSet set) {
        int setLength;
        if (this == set) {
            return;
        }
        BitSet first = this;
        BitSet second = set;
        if (System.identityHashCode(first) > System.identityHashCode(second)) {
            first = set;
            second = this;
        }
        if ((setLength = set.bits.length) > 0) {
            this.ensureCapacity(BitSet.bitIndex(setLength - 1));
        }
        int i = setLength;
        while (i-- > 0) {
            int n = i;
            this.bits[n] = this.bits[n] | set.bits[i];
        }
    }

    public void xor(BitSet set) {
        int setLength;
        BitSet first = this;
        BitSet second = set;
        if (System.identityHashCode(first) > System.identityHashCode(second)) {
            first = set;
            second = this;
        }
        if ((setLength = set.bits.length) > 0) {
            this.ensureCapacity(BitSet.bitIndex(setLength - 1));
        }
        int i = setLength;
        while (i-- > 0) {
            int n = i;
            this.bits[n] = this.bits[n] ^ set.bits[i];
        }
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.bits.length;
        while (--i >= 0) {
            h ^= this.bits[i] * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    public int size() {
        return this.bits.length << 6;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BitSet) {
            int n;
            if (this == obj) {
                return true;
            }
            BitSet set = (BitSet)obj;
            BitSet first = this;
            BitSet second = set;
            if (System.identityHashCode(first) > System.identityHashCode(second)) {
                first = set;
                second = this;
            }
            int bitsLength = this.bits.length;
            int setLength = set.bits.length;
            int i = n = Math.min(bitsLength, setLength);
            while (i-- > 0) {
                if (this.bits[i] == set.bits[i]) continue;
                return false;
            }
            if (bitsLength > n) {
                i = bitsLength;
                while (i-- > n) {
                    if (this.bits[i] == 0L) continue;
                    return false;
                }
            } else if (setLength > n) {
                i = setLength;
                while (i-- > n) {
                    if (set.bits[i] == 0L) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        BitSet result = null;
        try {
            result = (BitSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, result.bits, 0, result.bits.length);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        boolean needSeparator = false;
        buffer.append('{');
        int limit = this.size();
        int i = 0;
        while (i < limit) {
            if (this.get(i)) {
                if (needSeparator) {
                    buffer.append(", ");
                } else {
                    needSeparator = true;
                }
                buffer.append(i);
            }
            ++i;
        }
        buffer.append('}');
        return buffer.toString();
    }
}

