/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.optimization;

import cn.org.gddsn.optimization.RealValueFunction;
import org.apache.log4j.Logger;

public class SimplexMin {
    static Logger logger;
    int iter;
    int mp;
    int ndim;
    int np;
    int NMAX = 20;
    int ITMAX = 5000;
    double ftol = 1.0E-8;
    double[][] p;
    double[] y;
    private RealValueFunction Func;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.optimization.SimplexMin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public SimplexMin(double[][] p, int ndim) {
        this(p, ndim, 1.0E-8);
    }

    public SimplexMin(double[][] p, int ndim, double ftol) {
        this.p = p;
        this.ndim = ndim;
        this.ftol = ftol;
        this.mp = ndim + 1;
        this.np = ndim;
    }

    public void setFunk(RealValueFunction newFunk) {
        this.Func = newFunk;
    }

    public void SearchMin() {
        this.y = new double[this.mp];
        double[] x = new double[this.np];
        int i = 0;
        while (i < this.mp) {
            int j = 0;
            while (j < this.np) {
                x[j] = this.p[i][j];
                ++j;
            }
            this.y[i] = this.Func.funk(x);
            ++i;
        }
        double[] psum = new double[this.NMAX];
        this.iter = 0;
        boolean GotoStatus = true;
        while (true) {
            int inhi;
            int ihi;
            int n;
            if (GotoStatus) {
                n = 0;
                while (n < this.ndim) {
                    double sum = 0.0;
                    int m = 0;
                    while (m < this.ndim + 1) {
                        sum += this.p[m][n];
                        ++m;
                    }
                    psum[n] = sum;
                    ++n;
                }
            }
            int ilo = 0;
            if (this.y[0] > this.y[1]) {
                ihi = 0;
                inhi = 1;
            } else {
                ihi = 1;
                inhi = 0;
            }
            i = 0;
            while (i < this.ndim + 1) {
                if (this.y[i] <= this.y[ilo]) {
                    ilo = i;
                }
                if (this.y[i] > this.y[ihi]) {
                    inhi = ihi;
                    ihi = i;
                } else if (this.y[i] > this.y[inhi] && i != ihi) {
                    inhi = i;
                }
                ++i;
            }
            double rtol = 2.0 * Math.abs(this.y[ihi] - this.y[ilo]) / (Math.abs(this.y[ihi]) + Math.abs(this.y[ilo]));
            if (rtol < this.ftol) {
                double swap = this.y[0];
                this.y[0] = this.y[ilo];
                this.y[ilo] = swap;
                n = 0;
                while (n < this.ndim) {
                    swap = this.p[0][n];
                    this.p[0][n] = this.p[ilo][n];
                    this.p[ilo][n] = swap;
                    ++n;
                }
                return;
            }
            if (this.iter >= this.ITMAX) {
                logger.warn("ITMAX exceeded in SearchMin");
                return;
            }
            this.iter += 2;
            double ytry = this.amotry(this.p, this.y, psum, this.mp, this.np, this.ndim, ihi, -1.0);
            if (ytry <= this.y[ilo]) {
                ytry = this.amotry(this.p, this.y, psum, this.mp, this.np, this.ndim, ihi, 2.0);
            } else if (ytry >= this.y[inhi]) {
                double ysave = this.y[ihi];
                ytry = this.amotry(this.p, this.y, psum, this.mp, this.np, this.ndim, ihi, 0.5);
                if (ytry >= ysave) {
                    i = 0;
                    while (i < this.ndim + 1) {
                        if (i != ilo) {
                            int j = 0;
                            while (j < this.ndim) {
                                psum[j] = 0.5 * (this.p[i][j] + this.p[ilo][j]);
                                this.p[i][j] = psum[j];
                                ++j;
                            }
                            this.y[i] = this.Func.funk(psum);
                        }
                        ++i;
                    }
                    this.iter += this.ndim;
                    GotoStatus = true;
                    continue;
                }
            } else {
                --this.iter;
            }
            GotoStatus = false;
        }
    }

    private double amotry(double[][] p, double[] y, double[] psum, int mp, int np, int ndim, int ihi, double fac) {
        double[] ptry = new double[this.NMAX];
        double fac1 = (1.0 - fac) / (double)ndim;
        double fac2 = fac1 - fac;
        int j = 0;
        while (j < ndim) {
            ptry[j] = psum[j] * fac1 - p[ihi][j] * fac2;
            ++j;
        }
        double ytry = this.Func.funk(ptry);
        if (ytry < y[ihi]) {
            y[ihi] = ytry;
            j = 0;
            while (j < ndim) {
                psum[j] = psum[j] - p[ihi][j] + ptry[j];
                p[ihi][j] = ptry[j];
                ++j;
            }
        }
        double ret = ytry;
        return ret;
    }

    public double[] getResult() {
        double Len = this.mp;
        double[] res = new double[this.ndim];
        int j = 0;
        while (j < this.ndim) {
            int i = 0;
            while (i < this.mp) {
                int n = j;
                res[n] = res[n] + this.p[i][j] / Len;
                ++i;
            }
            ++j;
        }
        return res;
    }

    public double getResidual() {
        double y = 0.0;
        double[] x = new double[this.np];
        int j = 0;
        while (j < this.np) {
            x[j] = this.p[0][j];
            ++j;
        }
        y = this.Func.funk(x);
        return y;
    }
}

