/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.CatalogI;
import cn.org.gddsn.jopens.entity.Mag;
import cn.org.gddsn.jopens.entity.PhaseI;
import cn.org.gddsn.jopens.service.ReportService;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.seis.CatalogExporterInf;
import cn.org.gddsn.seis.EventInfoUtils;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EvtData;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogExporter
implements CatalogExporterInf {
    private boolean exportArrival = true;
    private boolean exportAmp = true;

    @Override
    public void write(File cataFile, ReportService rs, String where) throws IOException {
        List<Catalog> cataList = rs.findCatalog(where);
        this.write(cataFile, cataList);
    }

    @Override
    public void write(File cataFile, List<Catalog> cataList) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(cataFile));
        for (Catalog c : cataList) {
            this.write(pw, c);
        }
        pw.close();
    }

    @Override
    public void write(EvtData evt, SeedVolumeService svs, File cataFile) throws IOException {
        CatalogI c = new CatalogI();
        if (EvtData.source == null) {
            EvtData.source = new SourceParam();
            EvtData.source.setOriginTime(evt.getArrivalTime(0));
            EvtData.source.setLat(-99999.0);
            EvtData.source.setLon(-99999.0);
            EvtData.source.setDepth(-99999.0);
            EvtData.source.setRms(-99999.0);
        }
        if (EvtData.source.getOriginTime() == null) {
            EvtData.source.setOriginTime(evt.getArrivalTime(0));
            EvtData.source.setLat(-99999.0);
            EvtData.source.setLon(-99999.0);
            EvtData.source.setDepth(-99999.0);
            EvtData.source.setRms(-99999.0);
        }
        EventInfoUtils.sourceParam2Catalog(EvtData.source, c, svs);
        c.setId(cataFile.getName());
        c.setPhases(new LinkedList<cn.org.gddsn.jopens.entity.Phase>());
        int TCH = evt.getTCN();
        int i = 0;
        while (i < TCH) {
            for (Phase p : evt.getPhases(i)) {
                PhaseI dbPh = new PhaseI();
                EventInfoUtils.phase2EntityPhase(p, dbPh, svs);
                dbPh.setCatalog(c);
                c.getPhases().add(dbPh);
            }
            ++i;
        }
        Collections.sort(c.getPhases());
        this.write(cataFile.getParentFile(), (Catalog)c);
    }

    @Override
    public void write(File path, Catalog c) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(new File(path, String.valueOf(c.getId()) + ".phase")));
        this.write(pw, c);
        pw.close();
    }

    @Override
    public void write(PrintWriter wr, Catalog c) throws IOException {
        this.exportCatalog(wr, c);
        if (this.exportArrival) {
            this.exportArrival(wr, c);
        }
        if (this.exportAmp) {
            this.exportAmp(wr, c);
        }
        wr.println();
    }

    @Override
    public void exportCatalog(PrintWriter wr, Catalog c) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy MM dd HH  mm ");
        wr.print(df.format(c.getOriginTime()));
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date(c.getOriginTime().getTime() + (long)(c.getOriginTimeFrac() / 10)));
        double sec = (double)gc.get(13) + (double)(gc.getTimeInMillis() % 1000L) / 1000.0;
        wr.printf("%.1f ", sec);
        wr.printf("%.3f %.2f %.3f %.2f %5.1f %.2f ", Float.valueOf(c.getLat()), Float.valueOf(c.getErh()), Float.valueOf(c.getLon()), Float.valueOf(c.getErh()), Float.valueOf(c.getDepth()), Float.valueOf(c.getErz()));
        for (Mag m : c.getMags()) {
            wr.printf("%.3f%6s %.2f ", Float.valueOf(m.getMagVal()), m.getMagType().getId(), m.getMagError());
        }
        wr.printf("%.1f ", Float.valueOf(c.getRms()));
        wr.println();
    }

    @Override
    public void exportArrival(PrintWriter wr, Catalog c) throws IOException {
        wr.println("#Phase Arrivals:");
        wr.printf("%5s %3s %5s %3s %6s %23s %4s %3s %5s\n", "#sta", "net", "dist", "azi", "phase", "time", "res", "wt", "sta");
        for (cn.org.gddsn.jopens.entity.Phase p : c.getPhases()) {
            if (!p.getPhaseType().equals("time")) continue;
            wr.printf("%5s %3s %5.2f %3.0f %6s ", p.getChannelLocator().getStationCode(), p.getChannelLocator().getNetCode(), p.getDistance() > -9999.0f ? (double)p.getDistance() / 111.19 : -1.0, Float.valueOf(p.getAzimuth()), String.valueOf(p.getClarity()) + p.getPhaseName() + p.getWsign());
            wr.printf("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL %2$4.1f %3$3.1f %4$5s", p.getPhaseTime(), Float.valueOf(p.getResi()), Float.valueOf(p.getWeight()), p.getChannelLocator().getStationCode());
            wr.println();
        }
    }

    @Override
    public void exportAmp(PrintWriter wr, Catalog c) throws IOException {
        wr.println("#Station Magnitudes:");
        wr.printf("%5s %3s %5s %3s %5s %4s %5s %10s %4s\n", "#sta", "net", "dist", "azi", "type", "value", "res ", "amp", "per");
        for (cn.org.gddsn.jopens.entity.Phase p : c.getPhases()) {
            if (p.getPhaseType().equals("time")) continue;
            wr.printf("%5s %3s %5.2f %3.0f %5s %4.1f %5.2f %10.2f %4.1f", p.getChannelLocator().getStationCode(), p.getChannelLocator().getNetCode(), p.getDistance() > -9999.0f ? (double)p.getDistance() / 111.19 : -1.0, Float.valueOf(p.getAzimuth()), p.getMagType().getId(), p.getMagVal() > -9999.0f ? (double)p.getMagVal() : 0.0, Float.valueOf(p.getResi() > -9999.0f ? p.getResi() : -1.0f), Float.valueOf(p.getAmp()), Float.valueOf(p.getPeriod()));
            wr.println();
        }
    }

    public void setExportAmp(boolean exportAmp) {
        this.exportAmp = exportAmp;
    }

    public void setExportArrival(boolean exportArrival) {
        this.exportArrival = exportArrival;
    }

    public static void main(String[] args) {
    }
}

