/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.aic;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AICPicker {
    static Logger logger = Logger.getLogger(AICPicker.class);

    private AICPicker() {
    }

    public static int pick(double[] v, int off, int len) {
        if (len < 3) {
            return -1;
        }
        double[] aic = new double[len];
        int k = 0;
        while (k < len) {
            double var2;
            double var1 = AICPicker.variance(v, off, k);
            aic[k] = Double.isNaN(var1) || var1 <= 1.0E-8 ? Double.NaN : (Double.isNaN(var2 = AICPicker.variance(v, off + k, len - k)) || var2 <= 1.0E-8 ? Double.NaN : (double)k * Math.log(var1) + (double)(len - k - 1) * Math.log(var2));
            ++k;
        }
        return off + AICPicker.findMinIndex(aic, 0, len);
    }

    private static double variance(double[] v, int off, int len) {
        if (len < 2) {
            return Double.NaN;
        }
        double m = AICPicker.mean(v, off, len);
        double ans = 0.0;
        int i = off;
        while (i < off + len) {
            ans += (v[i] - m) * (v[i] - m);
            ++i;
        }
        return ans / (double)(len - 1);
    }

    private static double mean(double[] v, int off, int len) {
        if (len < 1) {
            return Double.NaN;
        }
        double sum = 0.0;
        int k = off;
        while (k < off + len) {
            sum += v[k];
            ++k;
        }
        return sum / (double)len;
    }

    private static int findMinIndex(double[] v, int off, int len) {
        int minIdx = off;
        double min = Double.MAX_VALUE;
        int i = off;
        while (i < off + len) {
            if (!Double.isNaN(v[i]) && v[i] < min) {
                min = v[i];
                minIdx = i;
            }
            ++i;
        }
        return minIdx;
    }

    public static void main(String[] args) throws IOException {
        String fname = "TestData/AICPicker/XX_HSH_BHZ_2.txt";
        BufferedReader br = new BufferedReader(new FileReader(fname));
        int count = 0;
        String line = null;
        while ((line = br.readLine()) != null) {
            ++count;
        }
        br.close();
        double[] v = new double[count];
        br = new BufferedReader(new FileReader(fname));
        int i = 0;
        while (i < count) {
            line = br.readLine();
            v[i] = Double.parseDouble(line.trim());
            ++i;
        }
        br.close();
        System.out.println(AICPicker.pick(v, 2900, 500));
    }
}

